/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class AMPManager {
    public static synchronized void setServiceEnabled(XMPPConnection xMPPConnection, boolean bl) {
        if (AMPManager.isServiceEnabled(xMPPConnection) == bl) {
            return;
        }
        if (bl) {
            ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature("http://jabber.org/protocol/amp");
        } else {
            ServiceDiscoveryManager.getInstanceFor(xMPPConnection).removeFeature("http://jabber.org/protocol/amp");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection) {
        xMPPConnection.getXMPPServiceDomain();
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).includesFeature("http://jabber.org/protocol/amp");
    }

    public static boolean isActionSupported(XMPPConnection xMPPConnection, AMPExtension.Action action) {
        String string = "http://jabber.org/protocol/amp?action=" + action.toString();
        return AMPManager.isFeatureSupportedByServer(xMPPConnection, string);
    }

    public static boolean isConditionSupported(XMPPConnection xMPPConnection, String string) {
        String string2 = "http://jabber.org/protocol/amp?condition=" + string;
        return AMPManager.isFeatureSupportedByServer(xMPPConnection, string2);
    }

    private static boolean isFeatureSupportedByServer(XMPPConnection xMPPConnection, String string) {
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).serverSupportsFeature(string);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                AMPManager.setServiceEnabled(xMPPConnection, true);
            }
        });
    }
}

