/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.util.ArrayList;
import java.util.List;
import org.e.a.b.d;
import org.e.a.e;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.bookmarks.SharedBookmark;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;

public class Bookmarks
implements PrivateData {
    public static final String NAMESPACE = "storage:bookmarks";
    public static final String ELEMENT = "storage";
    private final List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private final List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement(ELEMENT).xmlnsAttribute(NAMESPACE).rightAngleBracket();
        for (BookmarkedURL sharedBookmark : this.getBookmarkedURLS()) {
            if (sharedBookmark.isShared()) continue;
            xmlStringBuilder.halfOpenElement("url").attribute("name", sharedBookmark.getName()).attribute("url", sharedBookmark.getURL());
            xmlStringBuilder.condAttribute(sharedBookmark.isRss(), "rss", "true");
            xmlStringBuilder.closeEmptyElement();
        }
        for (BookmarkedConference bookmarkedConference : this.getBookmarkedConferences()) {
            if (bookmarkedConference.isShared()) continue;
            xmlStringBuilder.halfOpenElement("conference");
            xmlStringBuilder.attribute("name", bookmarkedConference.getName());
            xmlStringBuilder.attribute("autojoin", Boolean.toString(bookmarkedConference.isAutoJoin()));
            xmlStringBuilder.attribute("jid", (CharSequence)bookmarkedConference.getJid());
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.optElement("nick", (CharSequence)bookmarkedConference.getNickname());
            xmlStringBuilder.optElement("password", bookmarkedConference.getPassword());
            xmlStringBuilder.closeElement("conference");
        }
        xmlStringBuilder.closeElement(ELEMENT);
        return xmlStringBuilder;
    }

    private static BookmarkedURL getURLStorage(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getAttributeValue("", "name");
        String string2 = xmlPullParser.getAttributeValue("", "url");
        String string3 = xmlPullParser.getAttributeValue("", "rss");
        boolean bl = string3 != null && "true".equals(string3);
        BookmarkedURL bookmarkedURL = new BookmarkedURL(string2, string, bl);
        boolean bl2 = false;
        while (!bl2) {
            XmlPullParser.Event event = xmlPullParser.next();
            if (event == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(xmlPullParser.getName())) {
                bookmarkedURL.setShared(true);
                continue;
            }
            if (event != XmlPullParser.Event.END_ELEMENT || !"url".equals(xmlPullParser.getName())) continue;
            bl2 = true;
        }
        return bookmarkedURL;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getAttributeValue("", "name");
        boolean bl = ParserUtils.getBooleanAttribute((XmlPullParser)xmlPullParser, (String)"autojoin", (boolean)false);
        e e2 = ParserUtils.getBareJidAttribute((XmlPullParser)xmlPullParser);
        BookmarkedConference bookmarkedConference = new BookmarkedConference(e2);
        bookmarkedConference.setName(string);
        bookmarkedConference.setAutoJoin(bl);
        boolean bl2 = false;
        while (!bl2) {
            XmlPullParser.Event event = xmlPullParser.next();
            if (event == XmlPullParser.Event.START_ELEMENT && "nick".equals(xmlPullParser.getName())) {
                String string2 = xmlPullParser.nextText();
                bookmarkedConference.setNickname(d.b((String)string2));
                continue;
            }
            if (event == XmlPullParser.Event.START_ELEMENT && "password".equals(xmlPullParser.getName())) {
                bookmarkedConference.setPassword(xmlPullParser.nextText());
                continue;
            }
            if (event == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(xmlPullParser.getName())) {
                bookmarkedConference.setShared(true);
                continue;
            }
            if (event != XmlPullParser.Event.END_ELEMENT || !"conference".equals(xmlPullParser.getName())) continue;
            bl2 = true;
        }
        return bookmarkedConference;
    }

    public static class Provider
    implements PrivateDataProvider {
        @Override
        public PrivateData parsePrivateData(XmlPullParser xmlPullParser) {
            Bookmarks bookmarks = new Bookmarks();
            boolean bl = false;
            while (!bl) {
                SharedBookmark sharedBookmark;
                XmlPullParser.Event event = xmlPullParser.next();
                if (event == XmlPullParser.Event.START_ELEMENT && "url".equals(xmlPullParser.getName())) {
                    sharedBookmark = Bookmarks.getURLStorage(xmlPullParser);
                    if (sharedBookmark == null) continue;
                    bookmarks.addBookmarkedURL((BookmarkedURL)sharedBookmark);
                    continue;
                }
                if (event == XmlPullParser.Event.START_ELEMENT && "conference".equals(xmlPullParser.getName())) {
                    sharedBookmark = Bookmarks.getConferenceStorage(xmlPullParser);
                    bookmarks.addBookmarkedConference((BookmarkedConference)sharedBookmark);
                    continue;
                }
                if (event != XmlPullParser.Event.END_ELEMENT || !Bookmarks.ELEMENT.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return bookmarks;
        }
    }
}

