/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.e.a.i;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.CloseListener;
import org.jivesoftware.smackx.bytestreams.ibb.DataListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InitiationListener;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

public final class InBandBytestreamManager
extends Manager
implements BytestreamManager {
    public static final int MAXIMUM_BLOCK_SIZE = 65535;
    private static final String SESSION_ID_PREFIX = "jibb_";
    private static final Map<XMPPConnection, InBandBytestreamManager> managers;
    private final Map<i, BytestreamListener> userListeners = new ConcurrentHashMap<i, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private final DataListener dataListener;
    private final CloseListener closeListener;
    private final Map<String, InBandBytestreamSession> sessions = new ConcurrentHashMap<String, InBandBytestreamSession>();
    private int defaultBlockSize = 4096;
    private int maximumBlockSize = 65535;
    private StanzaType stanza = StanzaType.IQ;
    private final List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized InBandBytestreamManager getByteStreamManager(XMPPConnection xMPPConnection) {
        if (xMPPConnection == null) {
            return null;
        }
        InBandBytestreamManager inBandBytestreamManager = managers.get(xMPPConnection);
        if (inBandBytestreamManager == null) {
            inBandBytestreamManager = new InBandBytestreamManager(xMPPConnection);
            managers.put(xMPPConnection, inBandBytestreamManager);
        }
        return inBandBytestreamManager;
    }

    private InBandBytestreamManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

            public void connectionTerminated() {
                InBandBytestreamManager.this.sessions.clear();
                InBandBytestreamManager.this.ignoredBytestreamRequests.clear();
            }
        });
        this.initiationListener = new InitiationListener(this);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.dataListener = new DataListener(this);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)this.dataListener);
        this.closeListener = new CloseListener(this);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)this.closeListener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.add(bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.remove(bytestreamListener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener, i i2) {
        this.userListeners.put(i2, bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(i i2) {
        this.userListeners.remove(i2);
    }

    public void ignoreBytestreamRequestOnce(String string) {
        this.ignoredBytestreamRequests.add(string);
    }

    public int getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public void setDefaultBlockSize(int n) {
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Default block size must be between 1 and 65535");
        }
        this.defaultBlockSize = n;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public void setMaximumBlockSize(int n) {
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Maximum block size must be between 1 and 65535");
        }
        this.maximumBlockSize = n;
    }

    public StanzaType getStanza() {
        return this.stanza;
    }

    public void setStanza(StanzaType stanzaType) {
        this.stanza = stanzaType;
    }

    @Override
    public InBandBytestreamSession establishSession(i i2) {
        String string = InBandBytestreamManager.getNextSessionID();
        return this.establishSession(i2, string);
    }

    @Override
    public InBandBytestreamSession establishSession(i i2, String string) {
        Open open = new Open(string, this.defaultBlockSize, this.stanza);
        open.setTo(i2);
        XMPPConnection xMPPConnection = this.connection();
        xMPPConnection.createStanzaCollectorAndSend((IQ)open).nextResultOrThrow();
        InBandBytestreamSession inBandBytestreamSession = new InBandBytestreamSession(xMPPConnection, open, i2);
        this.sessions.put(string, inBandBytestreamSession);
        return inBandBytestreamSession;
    }

    protected void replyRejectPacket(IQ iQ) {
        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.not_acceptable);
        this.connection().sendStanza((Stanza)errorIQ);
    }

    protected void replyItemNotFoundPacket(IQ iQ) {
        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.item_not_found);
        this.connection().sendStanza((Stanza)errorIQ);
    }

    private static String getNextSessionID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SESSION_ID_PREFIX);
        stringBuilder.append(StringUtils.secureOnlineAttackSafeRandomString());
        return stringBuilder.toString();
    }

    protected XMPPConnection getConnection() {
        return this.connection();
    }

    protected BytestreamListener getUserListener(i i2) {
        return this.userListeners.get(i2);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected Map<String, InBandBytestreamSession> getSessions() {
        return this.sessions;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                InBandBytestreamManager.getByteStreamManager(xMPPConnection);
            }
        });
        managers = new WeakHashMap<XMPPConnection, InBandBytestreamManager>();
    }

    public static enum StanzaType {
        IQ,
        MESSAGE;

    }
}

