/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public abstract class Socks5Exception
extends SmackException {
    private static final long serialVersionUID = 1L;

    protected Socks5Exception(String string) {
        super(string);
    }

    public static final class CouldNotConnectToAnyProvidedSocks5Host
    extends Socks5Exception {
        private static final long serialVersionUID = 1L;
        private final Map<Bytestream.StreamHost, Exception> streamHostsExceptions;

        private CouldNotConnectToAnyProvidedSocks5Host(String string, Map<Bytestream.StreamHost, Exception> map) {
            super(string);
            this.streamHostsExceptions = Collections.unmodifiableMap(map);
        }

        public Map<Bytestream.StreamHost, Exception> getStreamHostsExceptions() {
            return this.streamHostsExceptions;
        }

        static CouldNotConnectToAnyProvidedSocks5Host construct(Map<Bytestream.StreamHost, Exception> map) {
            Object object;
            assert (!map.isEmpty());
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("Could not establish socket with any provided SOCKS5 stream host.");
            Iterator<Bytestream.StreamHost> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Exception exception = map.get(object);
                stringBuilder.append(' ').append(object).append(" Exception: '").append(exception).append('\'');
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            object = stringBuilder.toString();
            return new CouldNotConnectToAnyProvidedSocks5Host((String)object, map);
        }
    }

    public static final class NoSocks5StreamHostsProvided
    extends Socks5Exception {
        private static final long serialVersionUID = 1L;

        NoSocks5StreamHostsProvided() {
            super("No SOCKS5 stream hosts provided.");
        }
    }
}

