/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqlast;

import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqlast.packet.LastActivity;

public final class LastActivityManager
extends Manager {
    private static final Map<XMPPConnection, LastActivityManager> instances = new WeakHashMap<XMPPConnection, LastActivityManager>();
    private static boolean enabledPerDefault = true;
    private volatile long lastMessageSent;
    private boolean enabled = false;

    public static void setEnabledPerDefault(boolean bl) {
        enabledPerDefault = bl;
    }

    public static synchronized LastActivityManager getInstanceFor(XMPPConnection xMPPConnection) {
        LastActivityManager lastActivityManager = instances.get(xMPPConnection);
        if (lastActivityManager == null) {
            lastActivityManager = new LastActivityManager(xMPPConnection);
        }
        return lastActivityManager;
    }

    private LastActivityManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Presence presence = (Presence)stanza;
                Presence.Mode mode = presence.getMode();
                if (mode == null) {
                    return;
                }
                switch (mode) {
                    case available: 
                    case chat: {
                        LastActivityManager.this.resetIdleTime();
                        break;
                    }
                }
            }
        }, (StanzaFilter)StanzaTypeFilter.PRESENCE);
        xMPPConnection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Message message = (Message)stanza;
                if (message.getType() == Message.Type.error) {
                    return;
                }
                LastActivityManager.this.resetIdleTime();
            }
        }, (StanzaFilter)StanzaTypeFilter.MESSAGE);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "jabber:iq:last", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                if (!LastActivityManager.this.enabled) {
                    return IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.not_acceptable);
                }
                LastActivity lastActivity = new LastActivity();
                lastActivity.setType(IQ.Type.result);
                lastActivity.setTo(iQ.getFrom());
                lastActivity.setFrom(iQ.getTo());
                lastActivity.setStanzaId(iQ.getStanzaId());
                lastActivity.setLastActivity(LastActivityManager.this.getIdleTime());
                return lastActivity;
            }
        });
        if (enabledPerDefault) {
            this.enable();
        }
        this.resetIdleTime();
        instances.put(xMPPConnection, this);
    }

    public synchronized void enable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).addFeature("jabber:iq:last");
        this.enabled = true;
    }

    public synchronized void disable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).removeFeature("jabber:iq:last");
        this.enabled = false;
    }

    private void resetIdleTime() {
        this.lastMessageSent = System.currentTimeMillis();
    }

    private long getIdleTime() {
        long l = this.lastMessageSent;
        long l2 = System.currentTimeMillis();
        return (l2 - l) / 1000L;
    }

    public LastActivity getLastActivity(i i2) {
        LastActivity lastActivity = new LastActivity(i2);
        return (LastActivity)this.connection().createStanzaCollectorAndSend((IQ)lastActivity).nextResultOrThrow();
    }

    public boolean isLastActivitySupported(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "jabber:iq:last");
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                LastActivityManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

