/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion;

import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqversion.packet.Version;

public final class VersionManager
extends Manager {
    private static final Map<XMPPConnection, VersionManager> INSTANCES = new WeakHashMap<XMPPConnection, VersionManager>();
    private static Version defaultVersion;
    private Version ourVersion = defaultVersion;
    private static boolean autoAppendSmackVersion;

    public static void setDefaultVersion(String string, String string2) {
        VersionManager.setDefaultVersion(string, string2, null);
    }

    public static void setDefaultVersion(String string, String string2, String string3) {
        defaultVersion = VersionManager.generateVersionFrom(string, string2, string3);
    }

    private VersionManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature("jabber:iq:version");
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "jabber:iq:version", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                if (VersionManager.this.ourVersion == null) {
                    return IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.not_acceptable);
                }
                return Version.createResultFor((Stanza)iQ, VersionManager.this.ourVersion);
            }
        });
    }

    public static synchronized VersionManager getInstanceFor(XMPPConnection xMPPConnection) {
        VersionManager versionManager = INSTANCES.get(xMPPConnection);
        if (versionManager == null) {
            versionManager = new VersionManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, versionManager);
        }
        return versionManager;
    }

    public static void setAutoAppendSmackVersion(boolean bl) {
        autoAppendSmackVersion = bl;
    }

    public void setVersion(String string, String string2) {
        this.setVersion(string, string2, null);
    }

    public void setVersion(String string, String string2, String string3) {
        this.ourVersion = VersionManager.generateVersionFrom(string, string2, string3);
    }

    public void unsetVersion() {
        this.ourVersion = null;
    }

    public boolean isSupported(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "jabber:iq:version");
    }

    public Version getVersion(i i2) {
        if (!this.isSupported(i2)) {
            return null;
        }
        return (Version)this.connection().createStanzaCollectorAndSend((IQ)new Version(i2)).nextResultOrThrow();
    }

    private static Version generateVersionFrom(String string, String string2, String string3) {
        if (autoAppendSmackVersion) {
            string = string + " (Smack " + Smack.getVersion() + ')';
        }
        return new Version(string, string2, string3);
    }

    static {
        autoAppendSmackVersion = true;
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                VersionManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

