/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.transports.JingleTransportManager;

public final class JingleTransportMethodManager
extends Manager {
    private static final WeakHashMap<XMPPConnection, JingleTransportMethodManager> INSTANCES = new WeakHashMap();
    private final HashMap<String, JingleTransportManager<?>> transportManagers = new HashMap();
    private static final String[] transportPreference = new String[]{"urn:xmpp:jingle:transports:s5b:1", "urn:xmpp:jingle:transports:ibb:1"};

    private JingleTransportMethodManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
    }

    public static synchronized JingleTransportMethodManager getInstanceFor(XMPPConnection xMPPConnection) {
        JingleTransportMethodManager jingleTransportMethodManager = INSTANCES.get(xMPPConnection);
        if (jingleTransportMethodManager == null) {
            jingleTransportMethodManager = new JingleTransportMethodManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, jingleTransportMethodManager);
        }
        return jingleTransportMethodManager;
    }

    public void registerTransportManager(JingleTransportManager<?> jingleTransportManager) {
        this.transportManagers.put(jingleTransportManager.getNamespace(), jingleTransportManager);
    }

    public static JingleTransportManager<?> getTransportManager(XMPPConnection xMPPConnection, String string) {
        return JingleTransportMethodManager.getInstanceFor(xMPPConnection).getTransportManager(string);
    }

    public JingleTransportManager<?> getTransportManager(String string) {
        return this.transportManagers.get(string);
    }

    public static JingleTransportManager<?> getTransportManager(XMPPConnection xMPPConnection, Jingle jingle) {
        return JingleTransportMethodManager.getInstanceFor(xMPPConnection).getTransportManager(jingle);
    }

    public JingleTransportManager<?> getTransportManager(Jingle jingle) {
        JingleContent jingleContent = jingle.getContents().get(0);
        if (jingleContent == null) {
            return null;
        }
        JingleContentTransport jingleContentTransport = jingleContent.getTransport();
        if (jingleContentTransport == null) {
            return null;
        }
        return this.getTransportManager(jingleContentTransport.getNamespace());
    }

    public static JingleTransportManager<?> getBestAvailableTransportManager(XMPPConnection xMPPConnection) {
        return JingleTransportMethodManager.getInstanceFor(xMPPConnection).getBestAvailableTransportManager();
    }

    public JingleTransportManager<?> getBestAvailableTransportManager() {
        for (String string : transportPreference) {
            JingleTransportManager<?> jingleTransportManager = this.getTransportManager(string);
            if (jingleTransportManager == null) continue;
            return jingleTransportManager;
        }
        Iterator<String> iterator = this.transportManagers.keySet().iterator();
        if (iterator.hasNext()) {
            return this.getTransportManager((String)iterator.next());
        }
        return null;
    }

    public JingleTransportManager<?> getBestAvailableTransportManager(Set<String> set) {
        for (String string : transportPreference) {
            JingleTransportManager<?> jingleTransportManager = this.getTransportManager(string);
            if (jingleTransportManager == null || set.contains(jingleTransportManager.getNamespace())) continue;
            return jingleTransportManager;
        }
        for (String string : this.transportManagers.keySet()) {
            if (set.contains(string)) continue;
            return this.getTransportManager(string);
        }
        return null;
    }
}

