/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.h;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.provider.JingleContentProviderManager;
import org.jivesoftware.smackx.jingle.transports.JingleTransportManager;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider.JingleS5BTransportProvider;

public final class JingleS5BTransportManager
extends JingleTransportManager<JingleS5BTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleS5BTransportManager.class.getName());
    private static final WeakHashMap<XMPPConnection, JingleS5BTransportManager> INSTANCES = new WeakHashMap();
    private List<Bytestream.StreamHost> localStreamHosts = null;
    private List<Bytestream.StreamHost> availableStreamHosts = null;
    private static boolean useLocalCandidates = true;
    private static boolean useExternalCandidates = true;

    private JingleS5BTransportManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        JingleContentProviderManager.addJingleContentTransportProvider(this.getNamespace(), new JingleS5BTransportProvider());
    }

    public static synchronized JingleS5BTransportManager getInstanceFor(XMPPConnection xMPPConnection) {
        JingleS5BTransportManager jingleS5BTransportManager = INSTANCES.get(xMPPConnection);
        if (jingleS5BTransportManager == null) {
            jingleS5BTransportManager = new JingleS5BTransportManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, jingleS5BTransportManager);
        }
        return jingleS5BTransportManager;
    }

    @Override
    public String getNamespace() {
        return "urn:xmpp:jingle:transports:s5b:1";
    }

    @Override
    public JingleTransportSession<JingleS5BTransport> transportSession(JingleSession jingleSession) {
        return new JingleS5BTransportSession(jingleSession);
    }

    private List<Bytestream.StreamHost> queryAvailableStreamHosts() {
        Socks5BytestreamManager socks5BytestreamManager = Socks5BytestreamManager.getBytestreamManager(this.getConnection());
        List<i> list = socks5BytestreamManager.determineProxies();
        return this.determineStreamHostInfo(list);
    }

    private List<Bytestream.StreamHost> queryLocalStreamHosts() {
        return Socks5BytestreamManager.getBytestreamManager(this.getConnection()).getLocalStreamHost();
    }

    public List<Bytestream.StreamHost> getAvailableStreamHosts() {
        if (this.availableStreamHosts == null) {
            this.availableStreamHosts = this.queryAvailableStreamHosts();
        }
        return this.availableStreamHosts;
    }

    public List<Bytestream.StreamHost> getLocalStreamHosts() {
        if (this.localStreamHosts == null) {
            this.localStreamHosts = this.queryLocalStreamHosts();
        }
        return this.localStreamHosts;
    }

    public List<Bytestream.StreamHost> determineStreamHostInfo(List<i> list) {
        XMPPConnection xMPPConnection = this.getConnection();
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        Iterator<i> iterator = list.iterator();
        while (iterator.hasNext()) {
            i i2 = iterator.next();
            Bytestream bytestream = new Bytestream();
            bytestream.setType(IQ.Type.get);
            bytestream.setTo(i2);
            try {
                Bytestream bytestream2 = (Bytestream)xMPPConnection.createStanzaCollectorAndSend((IQ)bytestream).nextResultOrThrow();
                arrayList.addAll(bytestream2.getStreamHosts());
            }
            catch (Exception exception) {
                iterator.remove();
            }
        }
        return arrayList;
    }

    public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
        if (!bl) {
            try {
                Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
                if (!socks5Proxy.isRunning()) {
                    socks5Proxy.start();
                }
                this.localStreamHosts = this.queryLocalStreamHosts();
                this.availableStreamHosts = this.queryAvailableStreamHosts();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not query available StreamHosts: " + throwable, throwable);
            }
        }
    }

    public Jingle createCandidateUsed(h h2, h h3, String string, JingleContent.Senders senders, JingleContent.Creator creator, String string2, String string3, String string4) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setSessionId(string).setInitiator(h3).setAction(JingleAction.transport_info);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setName(string2).setCreator(creator).setSenders(senders);
        JingleS5BTransport.Builder builder3 = JingleS5BTransport.getBuilder();
        builder3.setCandidateUsed(string4).setStreamId(string3);
        Jingle jingle = builder.addJingleContent(builder2.setTransport(builder3.build()).build()).build();
        jingle.setFrom((i)this.getConnection().getUser().u());
        jingle.setTo((i)h2);
        return jingle;
    }

    public Jingle createCandidateError(h h2, h h3, String string, JingleContent.Senders senders, JingleContent.Creator creator, String string2, String string3) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setSessionId(string).setInitiator(h3).setAction(JingleAction.transport_info);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setName(string2).setCreator(creator).setSenders(senders);
        JingleS5BTransport.Builder builder3 = JingleS5BTransport.getBuilder();
        builder3.setCandidateError().setStreamId(string3);
        Jingle jingle = builder.addJingleContent(builder2.setTransport(builder3.build()).build()).build();
        jingle.setFrom((i)this.getConnection().getUser().u());
        jingle.setTo((i)h2);
        return jingle;
    }

    public Jingle createProxyError(h h2, h h3, String string, JingleContent.Senders senders, JingleContent.Creator creator, String string2, String string3) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setSessionId(string).setAction(JingleAction.transport_info).setInitiator(h3);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setSenders(senders).setCreator(creator).setName(string2);
        JingleS5BTransport.Builder builder3 = JingleS5BTransport.getBuilder();
        builder3.setStreamId(string).setProxyError().setStreamId(string3);
        Jingle jingle = builder.addJingleContent(builder2.setTransport(builder3.build()).build()).build();
        jingle.setTo((i)h2);
        jingle.setFrom((i)this.getConnection().getUser().u());
        return jingle;
    }

    public Jingle createCandidateActivated(h h2, h h3, String string, JingleContent.Senders senders, JingleContent.Creator creator, String string2, String string3, String string4) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setInitiator(h3).setSessionId(string).setAction(JingleAction.transport_info);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setName(string2).setCreator(creator).setSenders(senders);
        JingleS5BTransport.Builder builder3 = JingleS5BTransport.getBuilder();
        builder3.setStreamId(string3).setCandidateActivated(string4);
        Jingle jingle = builder.addJingleContent(builder2.setTransport(builder3.build()).build()).build();
        jingle.setFrom((i)this.getConnection().getUser().u());
        jingle.setTo((i)h2);
        return jingle;
    }

    public static void setUseLocalCandidates(boolean bl) {
        useLocalCandidates = bl;
    }

    public static void setUseExternalCandidates(boolean bl) {
        useExternalCandidates = bl;
    }

    public static boolean isUseLocalCandidates() {
        return useLocalCandidates;
    }

    public static boolean isUseExternalCandidates() {
        return useExternalCandidates;
    }
}

