/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.b.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.g;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CleaningWeakReferenceMap;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.AutoJoinFailedCallback;
import org.jivesoftware.smackx.muc.AutoJoinSuccessCallback;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MucMessageInterceptor;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.packet.MUCUser;

public final class MultiUserChatManager
extends Manager {
    private static final String DISCO_NODE = "http://jabber.org/protocol/muc#rooms";
    private static final Logger LOGGER = Logger.getLogger(MultiUserChatManager.class.getName());
    private static final Map<XMPPConnection, MultiUserChatManager> INSTANCES;
    private static final StanzaFilter INVITATION_FILTER;
    private static final org.e.c.a.b<b, DiscoverInfo> KNOWN_MUC_SERVICES;
    private static final Set<MucMessageInterceptor> DEFAULT_MESSAGE_INTERCEPTORS;
    private final Set<InvitationListener> invitationsListeners = new CopyOnWriteArraySet<InvitationListener>();
    private final Set<e> joinedRooms = new CopyOnWriteArraySet<e>();
    private final Map<e, WeakReference<MultiUserChat>> multiUserChats = new CleaningWeakReferenceMap();
    private boolean autoJoinOnReconnect;
    private AutoJoinFailedCallback autoJoinFailedCallback;
    private AutoJoinSuccessCallback autoJoinSuccessCallback;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized MultiUserChatManager getInstanceFor(XMPPConnection xMPPConnection) {
        MultiUserChatManager multiUserChatManager = INSTANCES.get(xMPPConnection);
        if (multiUserChatManager == null) {
            multiUserChatManager = new MultiUserChatManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, multiUserChatManager);
        }
        return multiUserChatManager;
    }

    private MultiUserChatManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        StanzaListener stanzaListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Message message = (Message)stanza;
                MUCUser mUCUser = MUCUser.from((Stanza)message);
                if (mUCUser.getInvite() != null) {
                    e e2 = message.getFrom().o();
                    if (e2 == null) {
                        LOGGER.warning("Invite to non bare JID: '" + message.toXML() + "'");
                        return;
                    }
                    MultiUserChat multiUserChat = MultiUserChatManager.this.getMultiUserChat(e2);
                    XMPPConnection xMPPConnection = MultiUserChatManager.this.connection();
                    MUCUser.Invite invite = mUCUser.getInvite();
                    g g2 = invite.getFrom();
                    String string = invite.getReason();
                    String string2 = mUCUser.getPassword();
                    for (InvitationListener invitationListener : MultiUserChatManager.this.invitationsListeners) {
                        invitationListener.invitationReceived(xMPPConnection, multiUserChat, g2, string, string2, message, invite);
                    }
                }
            }
        };
        xMPPConnection.addAsyncStanzaListener(stanzaListener, INVITATION_FILTER);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (bl) {
                    return;
                }
                if (!MultiUserChatManager.this.autoJoinOnReconnect) {
                    return;
                }
                final Set<e> set = MultiUserChatManager.this.getJoinedRooms();
                if (set.isEmpty()) {
                    return;
                }
                Async.go((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AutoJoinFailedCallback autoJoinFailedCallback = MultiUserChatManager.this.autoJoinFailedCallback;
                        AutoJoinSuccessCallback autoJoinSuccessCallback = MultiUserChatManager.this.autoJoinSuccessCallback;
                        for (e e2 : set) {
                            MultiUserChat multiUserChat = MultiUserChatManager.this.getMultiUserChat(e2);
                            if (!multiUserChat.isJoined()) {
                                return;
                            }
                            d d2 = multiUserChat.getNickname();
                            if (d2 == null) {
                                return;
                            }
                            try {
                                multiUserChat.leave();
                            }
                            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.MucNotJoinedException object) {
                                if (autoJoinFailedCallback != null) {
                                    autoJoinFailedCallback.autoJoinFailed(multiUserChat, (Exception)object);
                                } else {
                                    LOGGER.log(Level.WARNING, "Could not leave room", (Throwable)object);
                                }
                                return;
                            }
                            try {
                                multiUserChat.join(d2);
                                if (autoJoinSuccessCallback == null) continue;
                                autoJoinSuccessCallback.autoJoinSuccess(multiUserChat, d2);
                            }
                            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.NotAMucServiceException object) {
                                if (autoJoinFailedCallback != null) {
                                    autoJoinFailedCallback.autoJoinFailed(multiUserChat, (Exception)object);
                                } else {
                                    LOGGER.log(Level.WARNING, "Could not leave room", (Throwable)object);
                                }
                                return;
                            }
                        }
                    }
                });
            }
        });
    }

    public synchronized MultiUserChat getMultiUserChat(e e2) {
        WeakReference<MultiUserChat> weakReference = this.multiUserChats.get(e2);
        if (weakReference == null) {
            return this.createNewMucAndAddToMap(e2);
        }
        MultiUserChat multiUserChat = (MultiUserChat)weakReference.get();
        if (multiUserChat == null) {
            return this.createNewMucAndAddToMap(e2);
        }
        return multiUserChat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDefaultMessageInterceptor(MucMessageInterceptor mucMessageInterceptor) {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return DEFAULT_MESSAGE_INTERCEPTORS.add(mucMessageInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDefaultMessageInterceptor(MucMessageInterceptor mucMessageInterceptor) {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return DEFAULT_MESSAGE_INTERCEPTORS.remove(mucMessageInterceptor);
        }
    }

    private MultiUserChat createNewMucAndAddToMap(e e2) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection(), e2, this);
        this.multiUserChats.put(e2, new WeakReference<MultiUserChat>(multiUserChat));
        return multiUserChat;
    }

    public boolean isServiceEnabled(i i2) {
        return this.serviceDiscoveryManager.supportsFeature(i2, "http://jabber.org/protocol/muc");
    }

    public Set<e> getJoinedRooms() {
        return Collections.unmodifiableSet(this.joinedRooms);
    }

    public List<e> getJoinedRooms(f f2) {
        DiscoverItems discoverItems = this.serviceDiscoveryManager.discoverItems((i)f2, DISCO_NODE);
        List<DiscoverItems.Item> list = discoverItems.getItems();
        ArrayList<e> arrayList = new ArrayList<e>(list.size());
        for (DiscoverItems.Item item : list) {
            e e2 = item.getEntityID().o();
            if (e2 == null) {
                LOGGER.warning("Not a bare JID: " + item.getEntityID());
                continue;
            }
            arrayList.add(e2);
        }
        return arrayList;
    }

    public RoomInfo getRoomInfo(e e2) {
        DiscoverInfo discoverInfo = this.serviceDiscoveryManager.discoverInfo((i)e2);
        return new RoomInfo(discoverInfo);
    }

    public List<b> getMucServiceDomains() {
        return this.serviceDiscoveryManager.findServices("http://jabber.org/protocol/muc", false, false);
    }

    @Deprecated
    public List<b> getXMPPServiceDomains() {
        return this.getMucServiceDomains();
    }

    public boolean providesMucService(b b2) {
        return this.getMucServiceDiscoInfo(b2) != null;
    }

    DiscoverInfo getMucServiceDiscoInfo(b b2) {
        DiscoverInfo discoverInfo = (DiscoverInfo)KNOWN_MUC_SERVICES.get((Object)b2);
        if (discoverInfo != null) {
            return discoverInfo;
        }
        discoverInfo = this.serviceDiscoveryManager.discoverInfo((i)b2);
        if (!discoverInfo.containsFeature("http://jabber.org/protocol/muc")) {
            return null;
        }
        KNOWN_MUC_SERVICES.put((Object)b2, (Object)discoverInfo);
        return discoverInfo;
    }

    public Map<e, HostedRoom> getRoomsHostedBy(b b2) {
        if (!this.providesMucService(b2)) {
            throw new MultiUserChatException.NotAMucServiceException(b2);
        }
        DiscoverItems discoverItems = this.serviceDiscoveryManager.discoverItems((i)b2);
        List<DiscoverItems.Item> list = discoverItems.getItems();
        HashMap<e, HostedRoom> hashMap = new HashMap<e, HostedRoom>(list.size());
        for (DiscoverItems.Item item : list) {
            HostedRoom hostedRoom = new HostedRoom(item);
            HostedRoom hostedRoom2 = hashMap.put(hostedRoom.getJid(), hostedRoom);
            assert (hostedRoom2 == null);
        }
        return hashMap;
    }

    public void decline(e e2, e e3, String string) {
        XMPPConnection xMPPConnection = this.connection();
        MessageBuilder messageBuilder = (MessageBuilder)xMPPConnection.getStanzaFactory().buildMessageStanza().to((i)e2);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline(string, e3);
        mUCUser.setDecline(decline);
        messageBuilder.addExtension((ExtensionElement)mUCUser);
        xMPPConnection.sendStanza((Stanza)messageBuilder.build());
    }

    public void addInvitationListener(InvitationListener invitationListener) {
        this.invitationsListeners.add(invitationListener);
    }

    public void removeInvitationListener(InvitationListener invitationListener) {
        this.invitationsListeners.remove(invitationListener);
    }

    public void setAutoJoinOnReconnect(boolean bl) {
        this.autoJoinOnReconnect = bl;
    }

    public void setAutoJoinFailedCallback(AutoJoinFailedCallback autoJoinFailedCallback) {
        this.autoJoinFailedCallback = autoJoinFailedCallback;
        if (autoJoinFailedCallback != null) {
            this.setAutoJoinOnReconnect(true);
        }
    }

    public void setAutoJoinSuccessCallback(AutoJoinSuccessCallback autoJoinSuccessCallback) {
        this.autoJoinSuccessCallback = autoJoinSuccessCallback;
        if (autoJoinSuccessCallback != null) {
            this.setAutoJoinOnReconnect(true);
        }
    }

    void addJoinedRoom(e e2) {
        this.joinedRooms.add(e2);
    }

    void removeJoinedRoom(e e2) {
        this.joinedRooms.remove(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CopyOnWriteArrayList<MucMessageInterceptor> getMessageInterceptors() {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return new CopyOnWriteArrayList<MucMessageInterceptor>(DEFAULT_MESSAGE_INTERCEPTORS);
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature("http://jabber.org/protocol/muc");
                final WeakReference<XMPPConnection> weakReference = new WeakReference<XMPPConnection>(xMPPConnection);
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection).setNodeInformationProvider(MultiUserChatManager.DISCO_NODE, new AbstractNodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        XMPPConnection xMPPConnection = (XMPPConnection)weakReference.get();
                        if (xMPPConnection == null) {
                            return Collections.emptyList();
                        }
                        Set<e> set = MultiUserChatManager.getInstanceFor(xMPPConnection).getJoinedRooms();
                        ArrayList<DiscoverItems.Item> arrayList = new ArrayList<DiscoverItems.Item>();
                        for (e e2 : set) {
                            arrayList.add(new DiscoverItems.Item((i)e2));
                        }
                        return arrayList;
                    }
                });
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, MultiUserChatManager>();
        INVITATION_FILTER = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter((ExtensionElement)new MUCUser()), new NotFilter(MessageTypeFilter.ERROR)});
        KNOWN_MUC_SERVICES = new org.e.c.a.b(100, 86400000L);
        DEFAULT_MESSAGE_INTERCEPTORS = new HashSet<MucMessageInterceptor>();
    }
}

