/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.e.a.i;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.GetItemsRequest;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.PublishItem;
import org.jivesoftware.smackx.pubsub.packet.PubSub;

public class LeafNode
extends Node {
    LeafNode(PubSubManager pubSubManager, String string) {
        super(pubSubManager, string);
    }

    public DiscoverItems discoverItems() {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setTo((i)this.pubSubManager.getServiceJid());
        discoverItems.setNode(this.getId());
        return (DiscoverItems)this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
    }

    public <T extends Item> List<T> getItems() {
        return this.getItems((List<ExtensionElement>)null, null);
    }

    public <T extends Item> List<T> getItems(String string) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId(), string));
        return this.getItems(pubSub);
    }

    public <T extends Item> List<T> getItems(Collection<String> collection) {
        ArrayList<Item> arrayList = new ArrayList<Item>(collection.size());
        for (String string : collection) {
            arrayList.add(new Item(string));
        }
        Object object = this.createPubsubPacket(IQ.Type.get, new ItemsExtension(ItemsExtension.ItemsElementType.items, this.getId(), arrayList));
        return this.getItems((PubSub)((Object)object));
    }

    public <T extends Item> List<T> getItems(int n) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId(), n));
        return this.getItems(pubSub);
    }

    public <T extends Item> List<T> getItems(int n, String string) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId(), string, n));
        return this.getItems(pubSub);
    }

    public <T extends Item> List<T> getItems(List<ExtensionElement> list, List<ExtensionElement> list2) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId()));
        pubSub.addExtensions(list);
        return this.getItems(pubSub, list2);
    }

    private <T extends Item> List<T> getItems(PubSub pubSub) {
        return this.getItems(pubSub, null);
    }

    private <T extends Item> List<T> getItems(PubSub pubSub, List<ExtensionElement> list) {
        PubSub pubSub2 = (PubSub)this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
        ItemsExtension itemsExtension = (ItemsExtension)pubSub2.getExtension(PubSubElementType.ITEMS);
        if (list != null) {
            list.addAll(pubSub2.getExtensions());
        }
        return itemsExtension.getItems();
    }

    @Deprecated
    public void send() {
        this.publish();
    }

    @Deprecated
    public <T extends Item> void send(T t) {
        this.publish(t);
    }

    @Deprecated
    public <T extends Item> void send(Collection<T> collection) {
        this.publish(collection);
    }

    public void publish() {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
    }

    public <T extends Item> void publish(T t) {
        ArrayList<T> arrayList = new ArrayList<T>(1);
        arrayList.add(t == null ? new Item() : t);
        this.publish(arrayList);
    }

    public <T extends Item> void publish(Collection<T> collection) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new PublishItem<T>(this.getId(), collection));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
    }

    public void deleteAllItems() {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.PURGE_OWNER, this.getId()));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
    }

    public void deleteItem(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        this.deleteItem(arrayList);
    }

    public void deleteItem(Collection<String> collection) {
        ArrayList<Item> arrayList = new ArrayList<Item>(collection.size());
        for (String string : collection) {
            arrayList.add(new Item(string));
        }
        Object object = this.createPubsubPacket(IQ.Type.set, new ItemsExtension(ItemsExtension.ItemsElementType.retract, this.getId(), arrayList));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend(object).nextResultOrThrow();
    }
}

