/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.e.a.a;
import org.e.a.a.d;
import org.e.a.b;
import org.e.a.i;
import org.e.b.c;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class PubSubManager
extends Manager {
    public static final String PLUS_NOTIFY = "+notify";
    public static final String AUTO_CREATE_FEATURE = "http://jabber.org/protocol/pubsub#auto-create";
    private static final Logger LOGGER = Logger.getLogger(PubSubManager.class.getName());
    private static final Map<XMPPConnection, Map<a, PubSubManager>> INSTANCES = new WeakHashMap<XMPPConnection, Map<a, PubSubManager>>();
    private final a pubSubService;
    private final Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public static PubSubManager getInstanceFor(XMPPConnection xMPPConnection) {
        b b2 = null;
        if (xMPPConnection.isAuthenticated()) {
            try {
                b2 = PubSubManager.getPubSubService(xMPPConnection);
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not determine PubSub service", throwable);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, "Interrupted while trying to determine PubSub service", interruptedException);
            }
        }
        if (b2 == null) {
            try {
                b2 = d.e((String)("pubsub." + xMPPConnection.getXMPPServiceDomain()));
            }
            catch (c c2) {
                throw new RuntimeException(c2);
            }
        }
        return PubSubManager.getInstanceFor(xMPPConnection, (a)b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PubSubManager getInstanceFor(XMPPConnection xMPPConnection, a a2) {
        PubSubManager pubSubManager;
        Map<a, PubSubManager> map;
        if (a2 != null && xMPPConnection.isAuthenticated() && xMPPConnection.getUser().n().a((CharSequence)a2)) {
            a2 = null;
        }
        Map<Object, Object> map2 = INSTANCES;
        synchronized (map2) {
            map = INSTANCES.get(xMPPConnection);
            if (map == null) {
                map = new HashMap<a, PubSubManager>();
                INSTANCES.put(xMPPConnection, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            pubSubManager = map.get(a2);
            if (pubSubManager == null) {
                pubSubManager = new PubSubManager(xMPPConnection, a2);
                map.put(a2, pubSubManager);
            }
        }
        return pubSubManager;
    }

    @Deprecated
    public static PubSubManager getInstance(XMPPConnection xMPPConnection) {
        return PubSubManager.getInstanceFor(xMPPConnection);
    }

    @Deprecated
    public static PubSubManager getInstance(XMPPConnection xMPPConnection, a a2) {
        return PubSubManager.getInstanceFor(xMPPConnection, a2);
    }

    PubSubManager(XMPPConnection xMPPConnection, a a2) {
        super(xMPPConnection);
        this.pubSubService = a2;
    }

    private void checkIfXmppErrorBecauseOfNotLeafNode(String string, XMPPException.XMPPErrorException xMPPErrorException) {
        StanzaError.Condition condition = xMPPErrorException.getStanzaError().getCondition();
        if (condition == StanzaError.Condition.feature_not_implemented) {
            throw new PubSubException.NotALeafNodeException(string, this.pubSubService);
        }
        throw xMPPErrorException;
    }

    public LeafNode createNode() {
        PubSub pubSub = this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.CREATE), null);
        QName qName = new QName(PubSubNamespace.basic.getXmlns(), "create");
        NodeExtension nodeExtension = (NodeExtension)pubSub.getExtension(qName);
        LeafNode leafNode = new LeafNode(this, nodeExtension.getNode());
        this.nodeMap.put(leafNode.getId(), leafNode);
        return leafNode;
    }

    public LeafNode createNode(String string) {
        return (LeafNode)this.createNode(string, null);
    }

    public Node createNode(String string, FillableConfigureForm fillableConfigureForm) {
        Object object;
        PubSub pubSub = PubSub.createPubsubPacket((i)this.pubSubService, IQ.Type.set, new NodeExtension(PubSubElementType.CREATE, string));
        boolean bl = true;
        if (fillableConfigureForm != null) {
            object = fillableConfigureForm.getDataFormToSubmit();
            pubSub.addExtension(new FormNode(FormNodeType.CONFIGURE, (DataForm)object));
            NodeType nodeType = fillableConfigureForm.getNodeType();
            bl = nodeType == null || nodeType == NodeType.leaf;
        }
        this.sendPubsubPacket(pubSub);
        object = bl ? new LeafNode(this, string) : new CollectionNode(this, string);
        this.nodeMap.put(((Node)object).getId(), (Node)object);
        return object;
    }

    public Node getNode(String string) {
        StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"The node ID can not be null or the empty string");
        Node node = this.nodeMap.get(string);
        if (node == null) {
            DiscoverInfo discoverInfo;
            XMPPConnection xMPPConnection = this.connection();
            DiscoverInfo discoverInfo2 = (DiscoverInfo)xMPPConnection.createStanzaCollectorAndSend((IQ)(discoverInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder(xMPPConnection).to((i)this.pubSubService)).setNode(string).build())).nextResultOrThrow();
            if (discoverInfo2.hasIdentity("pubsub", "leaf")) {
                node = new LeafNode(this, string);
            } else if (discoverInfo2.hasIdentity("pubsub", "collection")) {
                node = new CollectionNode(this, string);
            } else {
                throw new PubSubException.NotAPubSubNodeException(string, discoverInfo2);
            }
            this.nodeMap.put(string, node);
        }
        return node;
    }

    public LeafNode getOrCreateLeafNode(String string) {
        try {
            return this.getLeafNode(string);
        }
        catch (PubSubException.NotAPubSubNodeException notAPubSubNodeException) {
            return this.createNode(string);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                try {
                    return this.createNode(string);
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException2) {
                    if (xMPPErrorException2.getStanzaError().getCondition() == StanzaError.Condition.conflict) {
                        try {
                            return this.getLeafNode(string);
                        }
                        catch (PubSubException.NotAPubSubNodeException notAPubSubNodeException) {
                            throw new IllegalStateException((Throwable)((Object)notAPubSubNodeException));
                        }
                    }
                    throw xMPPErrorException2;
                }
            }
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                LOGGER.warning("The PubSub service " + this.pubSubService + " threw an DiscoInfoNodeAssertionError, trying workaround for Prosody bug #805 (https://prosody.im/issues/issue/805)");
                return this.getOrCreateLeafNodeProsodyWorkaround(string);
            }
            throw xMPPErrorException;
        }
    }

    public LeafNode getLeafNode(String string) {
        Node node;
        try {
            node = this.getNode(string);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return this.getLeafNodeProsodyWorkaround(string);
            }
            throw xMPPErrorException;
        }
        if (node instanceof LeafNode) {
            return (LeafNode)node;
        }
        throw new PubSubException.NotALeafNodeException(string, this.pubSubService);
    }

    private LeafNode getLeafNodeProsodyWorkaround(String string) {
        LeafNode leafNode = new LeafNode(this, string);
        try {
            leafNode.getItems(1);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            this.checkIfXmppErrorBecauseOfNotLeafNode(string, xMPPErrorException);
        }
        this.nodeMap.put(string, leafNode);
        return leafNode;
    }

    private LeafNode getOrCreateLeafNodeProsodyWorkaround(String string) {
        try {
            return this.createNode(string);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.conflict) {
                return this.getLeafNodeProsodyWorkaround(string);
            }
            throw xMPPErrorException;
        }
    }

    public <I extends Item> LeafNode tryToPublishAndPossibleAutoCreate(String string, I i2) {
        LeafNode leafNode = new LeafNode(this, string);
        try {
            leafNode.publish(i2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            this.checkIfXmppErrorBecauseOfNotLeafNode(string, xMPPErrorException);
        }
        this.nodeMap.put(string, leafNode);
        return leafNode;
    }

    public DiscoverItems discoverNodes(String string) {
        DiscoverItems discoverItems = new DiscoverItems();
        if (string != null) {
            discoverItems.setNode(string);
        }
        discoverItems.setTo((i)this.pubSubService);
        DiscoverItems discoverItems2 = (DiscoverItems)this.connection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
        return discoverItems2;
    }

    public List<Subscription> getSubscriptions() {
        PubSub pubSub = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        SubscriptionsExtension subscriptionsExtension = (SubscriptionsExtension)pubSub.getExtensionElement(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subscriptionsExtension.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() {
        PubSub pubSub = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        AffiliationsExtension affiliationsExtension = (AffiliationsExtension)pubSub.getExtension(PubSubElementType.AFFILIATIONS);
        return affiliationsExtension.getAffiliations();
    }

    public boolean deleteNode(String string) {
        boolean bl = true;
        try {
            this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.DELETE, string), PubSubElementType.DELETE.getNamespace());
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                bl = false;
            }
            throw xMPPErrorException;
        }
        this.nodeMap.remove(string);
        return bl;
    }

    public ConfigureForm getDefaultConfiguration() {
        PubSub pubSub = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket((Stanza)pubSub, PubSubElementType.DEFAULT);
    }

    public a getServiceJid() {
        return this.pubSubService;
    }

    public DiscoverInfo getSupportedFeatures() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return serviceDiscoveryManager.discoverInfo((i)this.pubSubService);
    }

    public boolean supportsAutomaticNodeCreation() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return serviceDiscoveryManager.supportsFeature((i)this.pubSubService, AUTO_CREATE_FEATURE);
    }

    public boolean canCreateNodesAndPublishItems() {
        LeafNode leafNode = null;
        try {
            leafNode = this.createNode();
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.forbidden) {
                boolean bl = false;
                return bl;
            }
            throw xMPPErrorException;
        }
        finally {
            if (leafNode != null) {
                this.deleteNode(leafNode.getId());
            }
        }
        return true;
    }

    private PubSub sendPubsubPacket(IQ.Type type, ExtensionElement extensionElement, PubSubNamespace pubSubNamespace) {
        return this.sendPubsubPacket((i)this.pubSubService, type, Collections.singletonList(extensionElement), pubSubNamespace);
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    PubSub sendPubsubPacket(i i2, IQ.Type type, List<ExtensionElement> list, PubSubNamespace pubSubNamespace) {
        PubSub pubSub = new PubSub(i2, type, pubSubNamespace);
        for (ExtensionElement extensionElement : list) {
            pubSub.addExtension(extensionElement);
        }
        return this.sendPubsubPacket(pubSub);
    }

    PubSub sendPubsubPacket(PubSub pubSub) {
        IQ iQ = (IQ)this.connection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
        if (iQ instanceof EmptyResultIQ) {
            return null;
        }
        return (PubSub)iQ;
    }

    public static b getPubSubService(XMPPConnection xMPPConnection) {
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).findService("http://jabber.org/protocol/pubsub", true, "pubsub", "service");
    }
}

