/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class SimplePayload
implements ExtensionElement {
    private final String elemName;
    private final String ns;
    private final String payload;

    public SimplePayload(String string) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = PacketParserUtils.getParserFor((String)string);
        }
        catch (IOException | XmlPullParserException throwable) {
            throw new AssertionError((Object)throwable);
        }
        QName qName = xmlPullParser.getQName();
        this.payload = string;
        this.elemName = (String)StringUtils.requireNotNullNorEmpty((CharSequence)qName.getLocalPart(), (String)"Could not determine element name from XML payload");
        this.ns = (String)StringUtils.requireNotNullNorEmpty((CharSequence)qName.getNamespaceURI(), (String)"Could not determine namespace from XML payload");
    }

    @Deprecated
    public SimplePayload(String string, String string2, CharSequence charSequence) {
        this(charSequence.toString());
        if (!string.equals(this.elemName)) {
            throw new IllegalArgumentException();
        }
        if (!string2.equals(this.ns)) {
            throw new IllegalArgumentException();
        }
    }

    public String getElementName() {
        return this.elemName;
    }

    public String getNamespace() {
        return this.ns;
    }

    public String toXML(XmlEnvironment xmlEnvironment) {
        return this.payload;
    }

    public String toString() {
        return this.getClass().getName() + "payload [" + this.toXML() + "]";
    }
}

