/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;

public final class DeliveryReceiptManager
extends Manager {
    private static final StanzaFilter NON_ERROR_GROUPCHAT_MESSAGES_WITH_DELIVERY_RECEIPT_REQUEST = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter((ExtensionElement)new DeliveryReceiptRequest()), new NotFilter(MessageTypeFilter.ERROR)});
    private static final StanzaFilter MESSAGES_WITH_DELIVERY_RECEIPT = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("received", "urn:xmpp:receipts")});
    private static final Logger LOGGER = Logger.getLogger(DeliveryReceiptManager.class.getName());
    private static final Map<XMPPConnection, DeliveryReceiptManager> instances = new WeakHashMap<XMPPConnection, DeliveryReceiptManager>();
    private static AutoReceiptMode defaultAutoReceiptMode;
    private AutoReceiptMode autoReceiptMode = defaultAutoReceiptMode;
    private final Set<ReceiptReceivedListener> receiptReceivedListeners = new CopyOnWriteArraySet<ReceiptReceivedListener>();
    private static final StanzaFilter MESSAGES_TO_REQUEST_RECEIPTS_FOR;

    public static void setDefaultAutoReceiptMode(AutoReceiptMode autoReceiptMode) {
        defaultAutoReceiptMode = autoReceiptMode;
    }

    private DeliveryReceiptManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature("urn:xmpp:receipts");
        xMPPConnection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                DeliveryReceipt deliveryReceipt = DeliveryReceipt.from((Message)stanza);
                for (ReceiptReceivedListener receiptReceivedListener : DeliveryReceiptManager.this.receiptReceivedListeners) {
                    receiptReceivedListener.onReceiptReceived(stanza.getFrom(), stanza.getTo(), deliveryReceipt.getId(), stanza);
                }
            }
        }, MESSAGES_WITH_DELIVERY_RECEIPT);
        xMPPConnection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                i i2 = stanza.getFrom();
                XMPPConnection xMPPConnection = DeliveryReceiptManager.this.connection();
                switch (DeliveryReceiptManager.this.autoReceiptMode) {
                    case disabled: {
                        return;
                    }
                    case ifIsSubscribed: {
                        if (Roster.getInstanceFor((XMPPConnection)xMPPConnection).isSubscribedToMyPresence(i2)) break;
                        return;
                    }
                }
                Message message = (Message)stanza;
                Message message2 = DeliveryReceiptManager.receiptMessageFor(message);
                if (message2 == null) {
                    LOGGER.warning("Received message stanza with receipt request from '" + i2 + "' without a stanza ID set. Message: " + message);
                    return;
                }
                xMPPConnection.sendStanza((Stanza)message2);
            }
        }, NON_ERROR_GROUPCHAT_MESSAGES_WITH_DELIVERY_RECEIPT_REQUEST);
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(XMPPConnection xMPPConnection) {
        DeliveryReceiptManager deliveryReceiptManager = instances.get(xMPPConnection);
        if (deliveryReceiptManager == null) {
            deliveryReceiptManager = new DeliveryReceiptManager(xMPPConnection);
            instances.put(xMPPConnection, deliveryReceiptManager);
        }
        return deliveryReceiptManager;
    }

    public boolean isSupported(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "urn:xmpp:receipts");
    }

    public void setAutoReceiptMode(AutoReceiptMode autoReceiptMode) {
        this.autoReceiptMode = autoReceiptMode;
    }

    public AutoReceiptMode getAutoReceiptMode() {
        return this.autoReceiptMode;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.add(receiptReceivedListener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.remove(receiptReceivedListener);
    }

    public void autoAddDeliveryReceiptRequests() {
        this.connection().addMessageInterceptor(DeliveryReceiptRequest::addTo, message -> MESSAGES_TO_REQUEST_RECEIPTS_FOR.accept((Stanza)message));
    }

    public void dontAutoAddDeliveryReceiptRequests() {
        this.connection().removeMessageInterceptor(DeliveryReceiptRequest::addTo);
    }

    public static boolean hasDeliveryReceiptRequest(Message message) {
        return DeliveryReceiptRequest.from((Stanza)message) != null;
    }

    @Deprecated
    public static String addDeliveryReceiptRequest(Message message) {
        return DeliveryReceiptRequest.addTo(message);
    }

    public static Message receiptMessageFor(Message message) {
        String string = message.getStanzaId();
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            return null;
        }
        Message message2 = ((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage().ofType(message.getType()).to(message.getFrom())).addExtension((ExtensionElement)new DeliveryReceipt(string))).build();
        return message2;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                DeliveryReceiptManager.getInstanceFor(xMPPConnection);
            }
        });
        defaultAutoReceiptMode = AutoReceiptMode.ifIsSubscribed;
        MESSAGES_TO_REQUEST_RECEIPTS_FOR = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT_OR_HEADLINE, new NotFilter((StanzaFilter)new StanzaExtensionFilter("received", "urn:xmpp:receipts")), MessageWithBodiesFilter.INSTANCE});
    }

    public static enum AutoReceiptMode {
        disabled,
        ifIsSubscribed,
        always;

    }
}

