/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune.element;

import java.net.URI;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class UserTuneElement
implements ExtensionElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/tune";
    public static final String ELEMENT = "tune";
    public static final QName QNAME = new QName("http://jabber.org/protocol/tune", "tune");
    private final String artist;
    private final UInt16 length;
    private final Integer rating;
    private final String source;
    private final String title;
    private final String track;
    private final URI uri;
    public static final UserTuneElement EMPTY_USER_TUNE = null;

    private UserTuneElement(Builder builder) {
        this.artist = builder.artist;
        this.length = builder.length;
        this.rating = builder.rating;
        this.source = builder.source;
        this.title = builder.title;
        this.track = builder.track;
        this.uri = builder.uri;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getArtist() {
        return this.artist;
    }

    public UInt16 getLength() {
        return this.length;
    }

    public Integer getRating() {
        return this.rating;
    }

    public String getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTrack() {
        return this.track;
    }

    public URI getUri() {
        return this.uri;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((ExtensionElement)this);
        if (this.isEmptyUserTune()) {
            return xmlStringBuilder.closeEmptyElement();
        }
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.optElement("artist", this.artist);
        xmlStringBuilder.optElement("length", (CharSequence)this.length);
        xmlStringBuilder.optElement("rating", (Object)this.rating);
        xmlStringBuilder.optElement("source", this.source);
        xmlStringBuilder.optElement("title", this.title);
        xmlStringBuilder.optElement("track", this.track);
        xmlStringBuilder.optElement("uri", (Object)this.uri);
        return xmlStringBuilder.closeElement(this.getElementName());
    }

    private boolean isEmptyUserTune() {
        return this.equals(EMPTY_USER_TUNE);
    }

    public static boolean hasUserTuneElement(Message message) {
        return message.hasExtension(UserTuneElement.class);
    }

    public static UserTuneElement from(Message message) {
        return (UserTuneElement)message.getExtension(UserTuneElement.class);
    }

    public int hashCode() {
        return HashCode.builder().append((Object)this.artist).append((Object)this.length).append((Object)this.rating).append((Object)this.source).append((Object)this.title).append((Object)this.track).append((Object)this.uri).build();
    }

    public boolean equals(Object object) {
        return EqualsUtil.equals((Object)this, (Object)object, (builder, userTuneElement) -> builder.append((Object)this.artist, (Object)userTuneElement.artist).append((Object)this.length, (Object)userTuneElement.length).append((Object)this.rating, (Object)userTuneElement.rating).append((Object)this.source, (Object)userTuneElement.source).append((Object)this.title, (Object)userTuneElement.title).append((Object)this.track, (Object)userTuneElement.track).append((Object)this.uri, (Object)userTuneElement.uri));
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String artist;
        private UInt16 length;
        private Integer rating;
        private String source;
        private String title;
        private String track;
        private URI uri;

        private Builder() {
        }

        public Builder setArtist(String string) {
            this.artist = string;
            return this;
        }

        public Builder setLength(int n) {
            return this.setLength(UInt16.from((int)n));
        }

        public Builder setLength(UInt16 uInt16) {
            this.length = uInt16;
            return this;
        }

        public Builder setRating(int n) {
            this.rating = n;
            return this;
        }

        public Builder setSource(String string) {
            this.source = string;
            return this;
        }

        public Builder setTitle(String string) {
            this.title = string;
            return this;
        }

        public Builder setTrack(String string) {
            this.track = string;
            return this;
        }

        public Builder setUri(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public UserTuneElement build() {
            return new UserTuneElement(this);
        }
    }
}

