/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ShortObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ShortObjectHashMap<V>
implements ShortObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private short[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Short> keySet = new KeySet();
    private final Set<Map.Entry<Short, V>> entrySet = new EntrySet();
    private final Iterable<ShortObjectMap.PrimitiveEntry<V>> entries = new Iterable<ShortObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<ShortObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public ShortObjectHashMap() {
        this(8, 0.5f);
    }

    public ShortObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public ShortObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        int n2 = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n2 - 1;
        this.keys = new short[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t == NULL_VALUE ? null : (T)t;
    }

    private static <T> T toInternal(T t) {
        return (T)(t == null ? NULL_VALUE : t);
    }

    @Override
    public V get(short s) {
        int n = this.indexOf(s);
        return n == -1 ? null : (V)ShortObjectHashMap.toExternal(this.values[n]);
    }

    @Override
    public V put(short s, V v) {
        int n;
        int n2 = n = this.hashIndex(s);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = s;
                this.values[n2] = ShortObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != s) continue;
            V v2 = this.values[n2];
            this.values[n2] = ShortObjectHashMap.toInternal(v);
            return ShortObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Short, ? extends V> map) {
        if (map instanceof ShortObjectHashMap) {
            ShortObjectHashMap shortObjectHashMap = (ShortObjectHashMap)map;
            for (int i = 0; i < shortObjectHashMap.values.length; ++i) {
                V v = shortObjectHashMap.values[i];
                if (v == null) continue;
                this.put(shortObjectHashMap.keys[i], v);
            }
            return;
        }
        for (Map.Entry<Short, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(short s) {
        int n = this.indexOf(s);
        if (n == -1) {
            return null;
        }
        V v = this.values[n];
        this.removeAt(n);
        return ShortObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(short s) {
        return this.indexOf(s) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ShortObjectHashMap.toInternal(object);
        for (V v : this.values) {
            if (v == null || !v.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ShortObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ShortObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n = this.size;
        for (short s : this.keys) {
            n ^= ShortObjectHashMap.hashCode(s);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortObjectMap)) {
            return false;
        }
        ShortObjectMap shortObjectMap = (ShortObjectMap)object;
        if (this.size != shortObjectMap.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            short s = this.keys[i];
            Object v2 = shortObjectMap.get(s);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Short s, V v) {
        return this.put(this.objectToKey(s), v);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Short> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Short, V>> entrySet() {
        return this.entrySet;
    }

    private short objectToKey(Object object) {
        return (Short)object;
    }

    private int indexOf(short s) {
        int n;
        int n2 = n = this.hashIndex(s);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (s != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(short s) {
        return ShortObjectHashMap.hashCode(s) & this.mask;
    }

    private static int hashCode(short s) {
        return s;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            short s = this.keys[n3];
            int n4 = this.hashIndex(s);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = s;
                this.values[n2] = v;
                this.keys[n3] = 0;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        short[] sArray = this.keys;
        V[] VArray = this.values;
        this.keys = new short[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (int i = 0; i < VArray.length; ++i) {
            V v = VArray[i];
            if (v == null) continue;
            short s = sArray[i];
            int n2 = this.hashIndex(s);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = s;
                    this.values[n2] = v;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : ShortObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(short s) {
        return Short.toString(s);
    }

    final class MapEntry
    implements Map.Entry<Short, V> {
        private final int entryIndex;

        MapEntry(int n) {
            this.entryIndex = n;
        }

        @Override
        public Short getKey() {
            this.verifyExists();
            return ShortObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V getValue() {
            this.verifyExists();
            return ShortObjectHashMap.toExternal(ShortObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public V setValue(V v) {
            this.verifyExists();
            Object object = ShortObjectHashMap.toExternal(ShortObjectHashMap.this.values[this.entryIndex]);
            ((ShortObjectHashMap)ShortObjectHashMap.this).values[this.entryIndex] = ShortObjectHashMap.toInternal(v);
            return object;
        }

        private void verifyExists() {
            if (ShortObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Short, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<Short, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements ShortObjectMap.PrimitiveEntry<V>,
    Iterator<ShortObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != ShortObjectHashMap.this.values.length && ShortObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != ShortObjectHashMap.this.values.length;
        }

        @Override
        public ShortObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (ShortObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public short key() {
            return ShortObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V value() {
            return ShortObjectHashMap.toExternal(ShortObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public void setValue(V v) {
            ((ShortObjectHashMap)ShortObjectHashMap.this).values[this.entryIndex] = ShortObjectHashMap.toInternal(v);
        }
    }

    private final class KeySet
    extends AbstractSet<Short> {
        private KeySet() {
        }

        @Override
        public int size() {
            return ShortObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return ShortObjectHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ShortObjectHashMap.this.remove(object) != null;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = ShortObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                ShortObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(primitiveEntry.key())) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public void clear() {
            ShortObjectHashMap.this.clear();
        }

        @Override
        public Iterator<Short> iterator() {
            return new Iterator<Short>(){
                private final Iterator<Map.Entry<Short, V>> iter;
                {
                    this.iter = ShortObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Short next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Short, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Short, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return ShortObjectHashMap.this.size();
        }
    }
}

