/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;

abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedAtomicArrayQueue(int n) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n, 2, "initialCapacity");
        int n2 = Pow2.roundToPowerOfTwo(n);
        long l = n2 - 1 << 1;
        this.producerBuffer = atomicReferenceArray = AtomicQueueUtil.allocateRefArray(n2 + 1);
        this.producerMask = l;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l;
        this.soProducerLimit(l);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public boolean isEmpty() {
        return (this.lvConsumerIndex() - this.lvProducerIndex()) / 2L == 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e) {
        AtomicReferenceArray atomicReferenceArray;
        long l;
        long l2;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long l3 = this.lvProducerLimit();
            l2 = this.lvProducerIndex();
            if ((l2 & 1L) == 1L) continue;
            l = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            if (l3 <= l2) {
                int n = this.offerSlowPath(l, l2, l3);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l, atomicReferenceArray, l2, e, null);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l2, l2 + 2L)) break;
        }
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, e);
        return true;
    }

    @Override
    public E poll() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            long l3 = this.lvProducerIndex();
            if ((l2 - l3) / 2L == 0L) {
                return null;
            }
            while ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n)) == null) {
            }
        }
        if (e == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.nextBuffer(atomicReferenceArray, l);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l2 + 2L);
        return e;
    }

    @Override
    public E peek() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            long l3 = this.lvProducerIndex();
            if ((l2 - l3) / 2L == 0L) {
                return null;
            }
            while ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n)) == null) {
            }
        }
        if (e == JUMP) {
            return this.newBufferPeek(this.nextBuffer(atomicReferenceArray, l), l2);
        }
        return e;
    }

    private int offerSlowPath(long l, long l2, long l3) {
        long l4;
        long l5 = this.lvConsumerIndex();
        if (l5 + (l4 = this.getCurrentBufferCapacity(l)) > l2) {
            if (!this.casProducerLimit(l3, l5 + l4)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l2, l5) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l2, l2 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> nextBuffer(AtomicReferenceArray<E> atomicReferenceArray, long l) {
        AtomicReferenceArray atomicReferenceArray2;
        int n = BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(l);
        this.consumerBuffer = atomicReferenceArray2 = (AtomicReferenceArray)AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        this.consumerMask = AtomicQueueUtil.length(atomicReferenceArray2) - 2 << 1;
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, BUFFER_CONSUMED);
        return atomicReferenceArray2;
    }

    private static int nextArrayOffset(long l) {
        return AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> atomicReferenceArray, long l) {
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l + 2L);
        return e;
    }

    private E newBufferPeek(AtomicReferenceArray<E> atomicReferenceArray, long l) {
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (null == e) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.nextBuffer(atomicReferenceArray, l);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l2 + 2L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == JUMP) {
            return this.newBufferPeek(this.nextBuffer(atomicReferenceArray, l), l2);
        }
        return e;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        int n;
        long l = 0L;
        int n2 = this.capacity();
        do {
            if ((n = this.fill(supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l;
        } while ((l += (long)n) <= (long)n2);
        return (int)l;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        long l;
        AtomicReferenceArray atomicReferenceArray;
        long l2;
        long l3;
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        block5: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            l = Math.min(l4, l3 + 2L * (long)n);
            if (l3 >= l4) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l2, atomicReferenceArray, l3, null, supplier);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l3, l)) break;
        }
        int n3 = (int)((l - l3) / 2L);
        for (int i = 0; i < n3; ++i) {
            int n4 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3 + 2L * (long)i, l2);
            AtomicQueueUtil.soRefElement(atomicReferenceArray, n4, supplier.get());
        }
        return n3;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        return MessagePassingQueueUtil.drain(this, consumer, n);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    private void resize(long l, AtomicReferenceArray<E> atomicReferenceArray, long l2, E e, MessagePassingQueue.Supplier<E> supplier) {
        AtomicReferenceArray atomicReferenceArray2;
        assert (e != null && supplier == null || e == null || supplier != null);
        int n = this.getNextBufferSize(atomicReferenceArray);
        try {
            atomicReferenceArray2 = AtomicQueueUtil.allocateRefArray(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            assert (this.lvProducerIndex() == l2 + 1L);
            this.soProducerIndex(l2);
            throw outOfMemoryError;
        }
        this.producerBuffer = atomicReferenceArray2;
        int n2 = n - 2 << 1;
        this.producerMask = n2;
        int n3 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        int n4 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, n2);
        AtomicQueueUtil.soRefElement(atomicReferenceArray2, n4, e == null ? supplier.get() : e);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(l), atomicReferenceArray2);
        long l3 = this.lvConsumerIndex();
        long l4 = this.availableInQueue(l2, l3);
        RangeUtil.checkPositive(l4, "availableInQueue");
        this.soProducerLimit(l2 + Math.min((long)n2, l4));
        this.soProducerIndex(l2 + 2L);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n3, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private long nextIndex;
        private E nextElement;
        private AtomicReferenceArray<E> currentBuffer;
        private int mask;

        WeakIterator(AtomicReferenceArray<E> atomicReferenceArray, long l, long l2) {
            this.pIndex = l2 >> 1;
            this.nextIndex = l >> 1;
            this.setBuffer(atomicReferenceArray);
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e;
        }

        private void setBuffer(AtomicReferenceArray<E> atomicReferenceArray) {
            this.currentBuffer = atomicReferenceArray;
            this.mask = AtomicQueueUtil.length(atomicReferenceArray) - 2;
        }

        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                long l;
                ++this.nextIndex;
                E e = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcCircularRefElementOffset(l, this.mask));
                if (e == null) continue;
                if (e != JUMP) {
                    return e;
                }
                int n = this.mask + 1;
                E e2 = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcRefElementOffset(n));
                if (e2 == BUFFER_CONSUMED || e2 == null) {
                    return null;
                }
                this.setBuffer((AtomicReferenceArray)e2);
                e = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcCircularRefElementOffset(l, this.mask));
                if (e == null) continue;
                return e;
            }
            return null;
        }
    }
}

