/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Native;
import io.netty.channel.unix.Buffer;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public final class EpollEventArray {
    private static final int EPOLL_EVENT_SIZE = Native.sizeofEpollEvent();
    private static final int EPOLL_DATA_OFFSET = Native.offsetofEpollData();
    private ByteBuffer memory;
    private long memoryAddress;
    private int length;

    EpollEventArray(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("length must be >= 1 but was " + n);
        }
        this.length = n;
        this.memory = Buffer.allocateDirectWithNativeOrder((int)EpollEventArray.calculateBufferCapacity(n));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    int length() {
        return this.length;
    }

    void increase() {
        this.length <<= 1;
        ByteBuffer byteBuffer = Buffer.allocateDirectWithNativeOrder((int)EpollEventArray.calculateBufferCapacity(this.length));
        Buffer.free((ByteBuffer)this.memory);
        this.memory = byteBuffer;
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)byteBuffer);
    }

    void free() {
        Buffer.free((ByteBuffer)this.memory);
        this.memoryAddress = 0L;
    }

    int events(int n) {
        return this.getInt(n, 0);
    }

    int fd(int n) {
        return this.getInt(n, EPOLL_DATA_OFFSET);
    }

    private int getInt(int n, int n2) {
        if (PlatformDependent.hasUnsafe()) {
            long l = (long)n * (long)EPOLL_EVENT_SIZE;
            return PlatformDependent.getInt((long)(this.memoryAddress + l + (long)n2));
        }
        return this.memory.getInt(n * EPOLL_EVENT_SIZE + n2);
    }

    private static int calculateBufferCapacity(int n) {
        return n * EPOLL_EVENT_SIZE;
    }
}

