/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.ChannelException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.epoll.VSockAddress;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class LinuxSocket
extends Socket {
    private static final long MAX_UINT32_T = 0xFFFFFFFFL;

    LinuxSocket(int n) {
        super(n);
    }

    InternetProtocolFamily family() {
        return this.ipv6 ? InternetProtocolFamily.IPv6 : InternetProtocolFamily.IPv4;
    }

    int sendmmsg(NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n, int n2) {
        return Native.sendmmsg(this.intValue(), this.ipv6, nativeDatagramPacketArray, n, n2);
    }

    int recvmmsg(NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n, int n2) {
        return Native.recvmmsg(this.intValue(), this.ipv6, nativeDatagramPacketArray, n, n2);
    }

    int recvmsg(NativeDatagramPacketArray.NativeDatagramPacket nativeDatagramPacket) {
        return Native.recvmsg(this.intValue(), this.ipv6, nativeDatagramPacket);
    }

    void setTimeToLive(int n) {
        LinuxSocket.setTimeToLive(this.intValue(), n);
    }

    void setInterface(InetAddress inetAddress) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        LinuxSocket.setInterface(this.intValue(), this.ipv6, nativeInetAddress.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(inetAddress));
    }

    void setNetworkInterface(NetworkInterface networkInterface) {
        InetAddress inetAddress = LinuxSocket.deriveInetAddress(networkInterface, this.family() == InternetProtocolFamily.IPv6);
        if (inetAddress.equals(this.family() == InternetProtocolFamily.IPv4 ? Native.INET_ANY : Native.INET6_ANY)) {
            throw new IOException("NetworkInterface does not support " + this.family());
        }
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        LinuxSocket.setInterface(this.intValue(), this.ipv6, nativeInetAddress.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface));
    }

    InetAddress getInterface() {
        Enumeration enumeration;
        NetworkInterface networkInterface = this.getNetworkInterface();
        if (networkInterface != null && (enumeration = SocketUtils.addressesFromNetworkInterface((NetworkInterface)networkInterface)).hasMoreElements()) {
            return (InetAddress)enumeration.nextElement();
        }
        return null;
    }

    NetworkInterface getNetworkInterface() {
        int n = LinuxSocket.getInterface(this.intValue(), this.ipv6);
        if (this.ipv6) {
            return PlatformDependent.javaVersion() >= 7 ? NetworkInterface.getByIndex(n) : null;
        }
        InetAddress inetAddress = LinuxSocket.inetAddress(n);
        return inetAddress != null ? NetworkInterface.getByInetAddress(inetAddress) : null;
    }

    private static InetAddress inetAddress(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    void joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        boolean bl = inetAddress instanceof Inet6Address;
        NativeInetAddress nativeInetAddress2 = NativeInetAddress.newInstance((InetAddress)LinuxSocket.deriveInetAddress(networkInterface, bl));
        if (inetAddress2 != null) {
            if (inetAddress2.getClass() != inetAddress.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            NativeInetAddress nativeInetAddress3 = NativeInetAddress.newInstance((InetAddress)inetAddress2);
            LinuxSocket.joinSsmGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface), nativeInetAddress3.address());
        } else {
            LinuxSocket.joinGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface));
        }
    }

    void leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        boolean bl = inetAddress instanceof Inet6Address;
        NativeInetAddress nativeInetAddress2 = NativeInetAddress.newInstance((InetAddress)LinuxSocket.deriveInetAddress(networkInterface, bl));
        if (inetAddress2 != null) {
            if (inetAddress2.getClass() != inetAddress.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            NativeInetAddress nativeInetAddress3 = NativeInetAddress.newInstance((InetAddress)inetAddress2);
            LinuxSocket.leaveSsmGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface), nativeInetAddress3.address());
        } else {
            LinuxSocket.leaveGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface));
        }
    }

    private static int interfaceIndex(NetworkInterface networkInterface) {
        return PlatformDependent.javaVersion() >= 7 ? networkInterface.getIndex() : -1;
    }

    private static int interfaceIndex(InetAddress inetAddress) {
        NetworkInterface networkInterface;
        if (PlatformDependent.javaVersion() >= 7 && (networkInterface = NetworkInterface.getByInetAddress(inetAddress)) != null) {
            return networkInterface.getIndex();
        }
        return -1;
    }

    void setTcpDeferAccept(int n) {
        LinuxSocket.setTcpDeferAccept(this.intValue(), n);
    }

    void setTcpQuickAck(boolean bl) {
        LinuxSocket.setTcpQuickAck(this.intValue(), bl ? 1 : 0);
    }

    void setTcpCork(boolean bl) {
        LinuxSocket.setTcpCork(this.intValue(), bl ? 1 : 0);
    }

    void setSoBusyPoll(int n) {
        LinuxSocket.setSoBusyPoll(this.intValue(), n);
    }

    void setTcpNotSentLowAt(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("tcpNotSentLowAt must be a uint32_t");
        }
        LinuxSocket.setTcpNotSentLowAt(this.intValue(), (int)l);
    }

    void setTcpFastOpen(int n) {
        LinuxSocket.setTcpFastOpen(this.intValue(), n);
    }

    void setTcpKeepIdle(int n) {
        LinuxSocket.setTcpKeepIdle(this.intValue(), n);
    }

    void setTcpKeepIntvl(int n) {
        LinuxSocket.setTcpKeepIntvl(this.intValue(), n);
    }

    void setTcpKeepCnt(int n) {
        LinuxSocket.setTcpKeepCnt(this.intValue(), n);
    }

    void setTcpUserTimeout(int n) {
        LinuxSocket.setTcpUserTimeout(this.intValue(), n);
    }

    void setIpBindAddressNoPort(boolean bl) {
        LinuxSocket.setIpBindAddressNoPort(this.intValue(), bl ? 1 : 0);
    }

    void setIpFreeBind(boolean bl) {
        LinuxSocket.setIpFreeBind(this.intValue(), bl ? 1 : 0);
    }

    void setIpTransparent(boolean bl) {
        LinuxSocket.setIpTransparent(this.intValue(), bl ? 1 : 0);
    }

    void setIpRecvOrigDestAddr(boolean bl) {
        LinuxSocket.setIpRecvOrigDestAddr(this.intValue(), bl ? 1 : 0);
    }

    int getTimeToLive() {
        return LinuxSocket.getTimeToLive(this.intValue());
    }

    void getTcpInfo(EpollTcpInfo epollTcpInfo) {
        LinuxSocket.getTcpInfo(this.intValue(), epollTcpInfo.info);
    }

    void setTcpMd5Sig(InetAddress inetAddress, byte[] byArray) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        LinuxSocket.setTcpMd5Sig(this.intValue(), this.ipv6, nativeInetAddress.address(), nativeInetAddress.scopeId(), byArray);
    }

    boolean isTcpCork() {
        return LinuxSocket.isTcpCork(this.intValue()) != 0;
    }

    int getSoBusyPoll() {
        return LinuxSocket.getSoBusyPoll(this.intValue());
    }

    int getTcpDeferAccept() {
        return LinuxSocket.getTcpDeferAccept(this.intValue());
    }

    boolean isTcpQuickAck() {
        return LinuxSocket.isTcpQuickAck(this.intValue()) != 0;
    }

    long getTcpNotSentLowAt() {
        return (long)LinuxSocket.getTcpNotSentLowAt(this.intValue()) & 0xFFFFFFFFL;
    }

    int getTcpKeepIdle() {
        return LinuxSocket.getTcpKeepIdle(this.intValue());
    }

    int getTcpKeepIntvl() {
        return LinuxSocket.getTcpKeepIntvl(this.intValue());
    }

    int getTcpKeepCnt() {
        return LinuxSocket.getTcpKeepCnt(this.intValue());
    }

    int getTcpUserTimeout() {
        return LinuxSocket.getTcpUserTimeout(this.intValue());
    }

    boolean isIpBindAddressNoPort() {
        return LinuxSocket.isIpBindAddressNoPort(this.intValue()) != 0;
    }

    boolean isIpFreeBind() {
        return LinuxSocket.isIpFreeBind(this.intValue()) != 0;
    }

    boolean isIpTransparent() {
        return LinuxSocket.isIpTransparent(this.intValue()) != 0;
    }

    boolean isIpRecvOrigDestAddr() {
        return LinuxSocket.isIpRecvOrigDestAddr(this.intValue()) != 0;
    }

    PeerCredentials getPeerCredentials() {
        return LinuxSocket.getPeerCredentials(this.intValue());
    }

    boolean isLoopbackModeDisabled() {
        return LinuxSocket.getIpMulticastLoop(this.intValue(), this.ipv6) == 0;
    }

    void setLoopbackModeDisabled(boolean bl) {
        LinuxSocket.setIpMulticastLoop(this.intValue(), this.ipv6, bl ? 0 : 1);
    }

    boolean isUdpGro() {
        return LinuxSocket.isUdpGro(this.intValue()) != 0;
    }

    void setUdpGro(boolean bl) {
        LinuxSocket.setUdpGro(this.intValue(), bl ? 1 : 0);
    }

    long sendFile(DefaultFileRegion defaultFileRegion, long l, long l2, long l3) {
        defaultFileRegion.open();
        long l4 = LinuxSocket.sendFile(this.intValue(), defaultFileRegion, l, l2, l3);
        if (l4 >= 0L) {
            return l4;
        }
        return Errors.ioResult((String)"sendfile", (int)((int)l4));
    }

    public void bindVSock(VSockAddress vSockAddress) {
        int n = LinuxSocket.bindVSock(this.intValue(), vSockAddress.getCid(), vSockAddress.getPort());
        if (n < 0) {
            throw Errors.newIOException((String)"bindVSock", (int)n);
        }
    }

    public boolean connectVSock(VSockAddress vSockAddress) {
        int n = LinuxSocket.connectVSock(this.intValue(), vSockAddress.getCid(), vSockAddress.getPort());
        if (n < 0) {
            return Errors.handleConnectErrno((String)"connectVSock", (int)n);
        }
        return true;
    }

    public VSockAddress remoteVSockAddress() {
        byte[] byArray = LinuxSocket.remoteVSockAddress(this.intValue());
        if (byArray == null) {
            return null;
        }
        int n = LinuxSocket.getIntAt(byArray, 0);
        int n2 = LinuxSocket.getIntAt(byArray, 4);
        return new VSockAddress(n, n2);
    }

    public VSockAddress localVSockAddress() {
        byte[] byArray = LinuxSocket.localVSockAddress(this.intValue());
        if (byArray == null) {
            return null;
        }
        int n = LinuxSocket.getIntAt(byArray, 0);
        int n2 = LinuxSocket.getIntAt(byArray, 4);
        return new VSockAddress(n, n2);
    }

    private static int getIntAt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static InetAddress deriveInetAddress(NetworkInterface networkInterface, boolean bl) {
        InetAddress inetAddress;
        InetAddress inetAddress2 = inetAddress = bl ? Native.INET6_ANY : Native.INET_ANY;
        if (networkInterface != null) {
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress3 = enumeration.nextElement();
                boolean bl2 = inetAddress3 instanceof Inet6Address;
                if (bl2 != bl) continue;
                return inetAddress3;
            }
        }
        return inetAddress;
    }

    public static LinuxSocket newSocket(int n) {
        return new LinuxSocket(n);
    }

    public static LinuxSocket newVSockStream() {
        return new LinuxSocket(LinuxSocket.newVSockStream0());
    }

    static int newVSockStream0() {
        int n = LinuxSocket.newVSockStreamFd();
        if (n < 0) {
            throw new ChannelException((Throwable)Errors.newIOException((String)"newVSockStream", (int)n));
        }
        return n;
    }

    public static LinuxSocket newSocketStream(boolean bl) {
        return new LinuxSocket(LinuxSocket.newSocketStream0((boolean)bl));
    }

    public static LinuxSocket newSocketStream(InternetProtocolFamily internetProtocolFamily) {
        return new LinuxSocket(LinuxSocket.newSocketStream0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static LinuxSocket newSocketStream() {
        return LinuxSocket.newSocketStream(LinuxSocket.isIPv6Preferred());
    }

    public static LinuxSocket newSocketDgram(boolean bl) {
        return new LinuxSocket(LinuxSocket.newSocketDgram0((boolean)bl));
    }

    public static LinuxSocket newSocketDgram(InternetProtocolFamily internetProtocolFamily) {
        return new LinuxSocket(LinuxSocket.newSocketDgram0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static LinuxSocket newSocketDgram() {
        return LinuxSocket.newSocketDgram(LinuxSocket.isIPv6Preferred());
    }

    public static LinuxSocket newSocketDomain() {
        return new LinuxSocket(LinuxSocket.newSocketDomain0());
    }

    public static LinuxSocket newSocketDomainDgram() {
        return new LinuxSocket(LinuxSocket.newSocketDomainDgram0());
    }

    private static native int newVSockStreamFd();

    private static native int bindVSock(int var0, int var1, int var2);

    private static native int connectVSock(int var0, int var1, int var2);

    private static native byte[] remoteVSockAddress(int var0);

    private static native byte[] localVSockAddress(int var0);

    private static native void joinGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5);

    private static native void joinSsmGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6);

    private static native void leaveGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5);

    private static native void leaveSsmGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6);

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6);

    private static native int getTcpDeferAccept(int var0);

    private static native int isTcpQuickAck(int var0);

    private static native int isTcpCork(int var0);

    private static native int getSoBusyPoll(int var0);

    private static native int getTcpNotSentLowAt(int var0);

    private static native int getTcpKeepIdle(int var0);

    private static native int getTcpKeepIntvl(int var0);

    private static native int getTcpKeepCnt(int var0);

    private static native int getTcpUserTimeout(int var0);

    private static native int getTimeToLive(int var0);

    private static native int isIpBindAddressNoPort(int var0);

    private static native int isIpFreeBind(int var0);

    private static native int isIpTransparent(int var0);

    private static native int isIpRecvOrigDestAddr(int var0);

    private static native void getTcpInfo(int var0, long[] var1);

    private static native PeerCredentials getPeerCredentials(int var0);

    private static native void setTcpDeferAccept(int var0, int var1);

    private static native void setTcpQuickAck(int var0, int var1);

    private static native void setTcpCork(int var0, int var1);

    private static native void setSoBusyPoll(int var0, int var1);

    private static native void setTcpNotSentLowAt(int var0, int var1);

    private static native void setTcpFastOpen(int var0, int var1);

    private static native void setTcpKeepIdle(int var0, int var1);

    private static native void setTcpKeepIntvl(int var0, int var1);

    private static native void setTcpKeepCnt(int var0, int var1);

    private static native void setTcpUserTimeout(int var0, int var1);

    private static native void setIpBindAddressNoPort(int var0, int var1);

    private static native void setIpFreeBind(int var0, int var1);

    private static native void setIpTransparent(int var0, int var1);

    private static native void setIpRecvOrigDestAddr(int var0, int var1);

    private static native void setTcpMd5Sig(int var0, boolean var1, byte[] var2, int var3, byte[] var4);

    private static native void setInterface(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int getInterface(int var0, boolean var1);

    private static native int getIpMulticastLoop(int var0, boolean var1);

    private static native void setIpMulticastLoop(int var0, boolean var1, int var2);

    private static native void setTimeToLive(int var0, int var1);

    private static native int isUdpGro(int var0);

    private static native void setUdpGro(int var0, int var1);
}

