/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Matrix33Kt;
import org.jetbrains.skia.Matrix44;
import org.jetbrains.skia.Point;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skia/Matrix33;", "", "mat", "", "", "([F)V", "getMat", "()[F", "asMatrix44", "Lorg/jetbrains/skia/Matrix44;", "equals", "", "other", "hashCode", "", "makeConcat", "makePreScale", "sx", "sy", "toString", "", "Companion", "skiko"})
public final class Matrix33 {
    public static final Companion Companion = new Companion(null);
    private final float[] mat;
    private static final Matrix33 IDENTITY = Companion.makeTranslate(0.0f, 0.0f);

    public Matrix33(float ... fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (!(fArray.length == 9)) {
            boolean bl = false;
            String string = "Expected 9 elements, got " + fArray.length;
            throw new IllegalArgumentException(string.toString());
        }
        this.mat = fArray;
    }

    public final float[] getMat() {
        return this.mat;
    }

    public final Matrix33 makePreScale(float f, float f2) {
        float[] fArray = new float[]{this.mat[0] * f, this.mat[1] * f2, this.mat[2], this.mat[3] * f, this.mat[4] * f2, this.mat[5], this.mat[6] * f, this.mat[7] * f2, this.mat[8]};
        return new Matrix33(fArray);
    }

    public final Matrix33 makeConcat(Matrix33 matrix33) {
        Intrinsics.checkNotNullParameter((Object)matrix33, (String)"");
        float[] fArray = new float[]{this.mat[0] * matrix33.mat[0] + this.mat[1] * matrix33.mat[3] + this.mat[2] * matrix33.mat[6], this.mat[0] * matrix33.mat[1] + this.mat[1] * matrix33.mat[4] + this.mat[2] * matrix33.mat[7], this.mat[0] * matrix33.mat[2] + this.mat[1] * matrix33.mat[5] + this.mat[2] * matrix33.mat[8], this.mat[3] * matrix33.mat[0] + this.mat[4] * matrix33.mat[3] + this.mat[5] * matrix33.mat[6], this.mat[3] * matrix33.mat[1] + this.mat[4] * matrix33.mat[4] + this.mat[5] * matrix33.mat[7], this.mat[3] * matrix33.mat[2] + this.mat[4] * matrix33.mat[5] + this.mat[5] * matrix33.mat[8], this.mat[6] * matrix33.mat[0] + this.mat[7] * matrix33.mat[3] + this.mat[8] * matrix33.mat[6], this.mat[6] * matrix33.mat[1] + this.mat[7] * matrix33.mat[4] + this.mat[8] * matrix33.mat[7], this.mat[6] * matrix33.mat[2] + this.mat[7] * matrix33.mat[5] + this.mat[8] * matrix33.mat[8]};
        return new Matrix33(fArray);
    }

    public final Matrix44 asMatrix44() {
        float[] fArray = new float[]{this.mat[0], this.mat[1], 0.0f, this.mat[2], this.mat[3], this.mat[4], 0.0f, this.mat[5], 0.0f, 0.0f, 1.0f, 0.0f, this.mat[6], this.mat[7], 0.0f, this.mat[8]};
        return new Matrix44(fArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Matrix33)) {
            return false;
        }
        return Arrays.equals(this.mat, ((Matrix33)object).mat);
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + Arrays.hashCode(this.mat);
        return n2;
    }

    public String toString() {
        return "Matrix33(_mat=" + this.mat + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skia/Matrix33$Companion;", "", "()V", "IDENTITY", "Lorg/jetbrains/skia/Matrix33;", "getIDENTITY", "()Lorg/jetbrains/skia/Matrix33;", "makeRotate", "deg", "", "pivotx", "pivoty", "pivot", "Lorg/jetbrains/skia/Point;", "makeScale", "s", "sx", "sy", "makeSkew", "makeTranslate", "dx", "dy", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final Matrix33 getIDENTITY() {
            return IDENTITY;
        }

        public final Matrix33 makeTranslate(float f, float f2) {
            float[] fArray = new float[]{1.0f, 0.0f, f, 0.0f, 1.0f, f2, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        public final Matrix33 makeScale(float f) {
            return this.makeScale(f, f);
        }

        public final Matrix33 makeScale(float f, float f2) {
            float[] fArray = new float[]{f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        public final Matrix33 makeRotate(float f) {
            double d = Matrix33Kt.toRadians(f);
            double d2 = Math.sin(d);
            double d3 = Math.cos(d);
            double d4 = 2.44140625E-4;
            if (Math.abs(d2) <= d4) {
                d2 = 0.0;
            }
            if (Math.abs(d3) <= d4) {
                d3 = 0.0;
            }
            float[] fArray = new float[]{(float)d3, (float)(-d2), 0.0f, (float)d2, (float)d3, 0.0f, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        public final Matrix33 makeRotate(float f, Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            return this.makeRotate(f, point.getX(), point.getY());
        }

        public final Matrix33 makeRotate(float f, float f2, float f3) {
            double d = Matrix33Kt.toRadians(f);
            double d2 = Math.sin(d);
            double d3 = Math.cos(d);
            double d4 = 2.44140625E-4;
            if (Math.abs(d2) <= d4) {
                d2 = 0.0;
            }
            if (Math.abs(d3) <= d4) {
                d3 = 0.0;
            }
            float[] fArray = new float[]{(float)d3, (float)(-d2), (float)((double)f2 - (double)f2 * d3 + (double)f3 * d2), (float)d2, (float)d3, (float)((double)f3 - (double)f3 * d3 - (double)f2 * d2), 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        public final Matrix33 makeSkew(float f, float f2) {
            float[] fArray = new float[]{1.0f, f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

