/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.DirectDataBuffer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u00a8\u0006\u0006"}, d2={"toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "skiko"})
public final class Convertors_jvmKt {
    public static final BufferedImage toBufferedImage(Bitmap bitmap) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"");
        Pixmap pixmap = bitmap.peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long l = pixmap.getAddr();
        ByteBuffer byteBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(l, bitmap.getRowBytes() * bitmap.getHeight());
        switch (WhenMappings.$EnumSwitchMapping$0[bitmap.getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray2 = new int[]{0, 1, 2, 3};
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray2 = new int[]{2, 1, 0, 3};
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + (Object)((Object)bitmap.getColorInfo().getColorType()));
            }
        }
        int[] nArray3 = nArray;
        WritableRaster writableRaster = Raster.createInterleavedRaster(new DirectDataBuffer(byteBuffer), bitmap.getWidth(), bitmap.getHeight(), bitmap.getWidth() * 4, 4, nArray3, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel = componentColorModel;
        WritableRaster writableRaster2 = writableRaster;
        Intrinsics.checkNotNull((Object)writableRaster2);
        return new BufferedImage(colorModel, writableRaster2, false, null);
    }

    public static final Bitmap toBitmap(BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"");
        int n = 4;
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() * n];
        int n2 = 0;
        int n3 = bufferedImage.getHeight();
        for (int i = 0; i < n3; ++i) {
            int n4 = bufferedImage.getWidth();
            for (int j = 0; j < n4; ++j) {
                int n5 = bufferedImage.getRGB(j, i);
                int n6 = n5 >> 24 & 0xFF;
                int n7 = n5 >> 16 & 0xFF;
                int n8 = n5 >> 8 & 0xFF;
                int n9 = n5 >> 0 & 0xFF;
                byArray[n2++] = (byte)n9;
                byArray[n2++] = (byte)n8;
                byArray[n2++] = (byte)n7;
                byArray[n2++] = (byte)n6;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32(bufferedImage.getWidth(), bufferedImage.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(byArray);
        return bitmap;
    }

    public static final Image toImage(BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap(bufferedImage));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.RGB_888X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.BGRA_8888.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

