/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0007H\u0014J\u0006\u0010%\u001a\u00020\u0007J\b\u0010&\u001a\u00020\u0007H\u0014J\b\u0010'\u001a\u00020\u0007H$J\b\u0010(\u001a\u00020)H$J\b\u0010*\u001a\u00020)H\u0014J\b\u0010+\u001a\u00020,H\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006-"}, d2={"Lorg/jetbrains/skiko/context/ContextHandler;", "", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "drawContent", "Lkotlin/Function1;", "Lorg/jetbrains/skia/Canvas;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/skiko/SkiaLayer;Lkotlin/jvm/functions/Function1;)V", "canvas", "getCanvas", "()Lorg/jetbrains/skia/Canvas;", "setCanvas", "(Lorg/jetbrains/skia/Canvas;)V", "context", "Lorg/jetbrains/skia/DirectContext;", "getContext", "()Lorg/jetbrains/skia/DirectContext;", "setContext", "(Lorg/jetbrains/skia/DirectContext;)V", "getLayer", "()Lorg/jetbrains/skiko/SkiaLayer;", "renderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "getRenderTarget", "()Lorg/jetbrains/skia/BackendRenderTarget;", "setRenderTarget", "(Lorg/jetbrains/skia/BackendRenderTarget;)V", "surface", "Lorg/jetbrains/skia/Surface;", "getSurface", "()Lorg/jetbrains/skia/Surface;", "setSurface", "(Lorg/jetbrains/skia/Surface;)V", "dispose", "disposeCanvas", "draw", "flush", "initCanvas", "initContext", "", "isTransparentBackground", "rendererInfo", "", "skiko"})
public abstract class ContextHandler {
    private final SkiaLayer layer;
    private final Function1<Canvas, Unit> drawContent;
    private DirectContext context;
    private BackendRenderTarget renderTarget;
    private Surface surface;
    private Canvas canvas;

    public ContextHandler(SkiaLayer skiaLayer, Function1<? super Canvas, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.layer = skiaLayer;
        this.drawContent = function1;
    }

    protected final SkiaLayer getLayer() {
        return this.layer;
    }

    protected final DirectContext getContext() {
        return this.context;
    }

    protected final void setContext(DirectContext directContext) {
        this.context = directContext;
    }

    protected final BackendRenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    protected final void setRenderTarget(BackendRenderTarget backendRenderTarget) {
        this.renderTarget = backendRenderTarget;
    }

    protected final Surface getSurface() {
        return this.surface;
    }

    protected final void setSurface(Surface surface) {
        this.surface = surface;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    protected final void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    protected abstract boolean initContext();

    protected abstract void initCanvas();

    protected void flush() {
        block0: {
            DirectContext directContext = this.context;
            if (directContext == null) break block0;
            directContext.flush();
        }
    }

    public void dispose() {
        block0: {
            this.disposeCanvas();
            DirectContext directContext = this.context;
            if (directContext == null) break block0;
            directContext.close();
        }
    }

    protected void disposeCanvas() {
        block1: {
            Surface surface = this.surface;
            if (surface != null) {
                surface.close();
            }
            BackendRenderTarget backendRenderTarget = this.renderTarget;
            if (backendRenderTarget == null) break block1;
            backendRenderTarget.close();
        }
    }

    public String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.layer.getRenderApi()) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    public final void draw() {
        if (!this.initContext()) {
            throw new RenderException("Cannot init graphic context", null, 2, null);
        }
        this.initCanvas();
        Canvas canvas = this.canvas;
        if (canvas != null) {
            Canvas canvas2;
            Canvas canvas3 = canvas2 = canvas;
            boolean bl = false;
            canvas3.clear(this.isTransparentBackground() ? 0 : -1);
            this.drawContent.invoke((Object)canvas3);
        }
        this.flush();
    }

    protected boolean isTransparentBackground() {
        if (OsArch_jvmKt.getHostOs() == OS.MacOS) {
            return true;
        }
        if (this.layer.getFullscreen()) {
            return false;
        }
        return this.layer.getTransparency();
    }
}

