/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OpenGLApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/skiko/context/OpenGLContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "currentHeight", "", "currentWidth", "initCanvas", "", "initContext", "", "isSizeChanged", "width", "height", "rendererInfo", "", "skiko"})
public final class OpenGLContextHandler
extends JvmContextHandler {
    private int currentWidth;
    private int currentHeight;

    public OpenGLContextHandler(SkiaLayer skiaLayer) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        super(skiaLayer);
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.setContext(RenderTargetsKt.makeGLContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                    Logger logger = Logger.INSTANCE;
                    boolean bl = false;
                    if (logger.getLoggerImpl().isInfoEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                        boolean bl2 = false;
                        skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger logger = Logger.INSTANCE;
            boolean bl = false;
            if (logger.getLoggerImpl().isWarnEnabled()) {
                Throwable throwable = exception;
                SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                boolean bl3 = false;
                String string = "Failed to create Skia OpenGL context!";
                skikoLoggerInterface.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    private final boolean isSizeChanged(int n2, int n3) {
        if (n2 != this.currentWidth || n3 != this.currentHeight) {
            this.currentWidth = n2;
            this.currentHeight = n3;
            return true;
        }
        return false;
    }

    @Override
    protected void initCanvas() {
        int n2;
        float f = this.getLayer().getContentScale();
        int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * f)), (int)0);
        if (this.isSizeChanged(n3, n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * f)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            OpenGLApi openGLApi = OpenGLApi.Companion.getInstance();
            int n4 = openGLApi.glGetIntegerv(openGLApi.getGL_DRAW_FRAMEBUFFER_BINDING());
            this.setRenderTarget(RenderTargetsKt.makeGLRenderTarget(n3, n2, 0, 8, n4, 32856));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
        }
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    @Override
    public String rendererInfo() {
        OpenGLApi openGLApi = OpenGLApi.Companion.getInstance();
        return super.rendererInfo() + "Vendor: " + openGLApi.glGetString(openGLApi.getGL_VENDOR()) + "\nModel: " + openGLApi.glGetString(openGLApi.getGL_RENDERER()) + "\nTotal VRAM: " + openGLApi.glGetIntegerv(openGLApi.getGL_TOTAL_MEMORY()) / 1024 + " MB\n";
    }
}

