/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020%H\u0014J\b\u0010'\u001a\u00020\u0016H\u0014J\b\u0010(\u001a\u00020\u0016H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lorg/jetbrains/skiko/context/SoftwareContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "colorModel", "Ljava/awt/image/ComponentColorModel;", "getColorModel", "()Ljava/awt/image/ComponentColorModel;", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "imageData", "", "getImageData", "()[B", "setImageData", "([B)V", "isInited", "", "()Z", "setInited", "(Z)V", "raster", "Ljava/awt/image/WritableRaster;", "getRaster", "()Ljava/awt/image/WritableRaster;", "setRaster", "(Ljava/awt/image/WritableRaster;)V", "storage", "Lorg/jetbrains/skia/Bitmap;", "getStorage", "()Lorg/jetbrains/skia/Bitmap;", "flush", "", "initCanvas", "initContext", "isTransparentBackground", "skiko"})
public final class SoftwareContextHandler
extends JvmContextHandler {
    private final ComponentColorModel colorModel;
    private final Bitmap storage;
    private BufferedImage image;
    private byte[] imageData;
    private WritableRaster raster;
    private boolean isInited;

    public SoftwareContextHandler(SkiaLayer skiaLayer) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        super(skiaLayer);
        this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        this.storage = new Bitmap();
    }

    @Override
    protected boolean isTransparentBackground() {
        return OsArch_jvmKt.getHostOs() == OS.MacOS && this.getLayer().getTransparency();
    }

    public final ComponentColorModel getColorModel() {
        return this.colorModel;
    }

    public final Bitmap getStorage() {
        return this.storage;
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public final void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public final byte[] getImageData() {
        return this.imageData;
    }

    public final void setImageData(byte[] byArray) {
        this.imageData = byArray;
    }

    public final WritableRaster getRaster() {
        return this.raster;
    }

    public final void setRaster(WritableRaster writableRaster) {
        this.raster = writableRaster;
    }

    public final boolean isInited() {
        return this.isInited;
    }

    public final void setInited(boolean bl) {
        this.isInited = bl;
    }

    @Override
    protected boolean initContext() {
        if (!this.isInited) {
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                Logger logger = Logger.INSTANCE;
                boolean bl = false;
                if (logger.getLoggerImpl().isInfoEnabled()) {
                    SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                    boolean bl2 = false;
                    skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                }
            }
            this.isInited = true;
        }
        return this.isInited;
    }

    @Override
    protected void initCanvas() {
        this.disposeCanvas();
        float f = this.getLayer().getContentScale();
        int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * f)), (int)0);
        int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * f)), (int)0);
        if (this.storage.getWidth() != n2 || this.storage.getHeight() != n3) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(n2, n3, ColorAlphaType.PREMUL), false);
        }
        this.setCanvas(new Canvas(this.storage, new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null)));
    }

    @Override
    protected void flush() {
        block4: {
            float f = this.getLayer().getContentScale();
            int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * f)), (int)0);
            int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * f)), (int)0);
            byte[] byArray = this.storage.readPixels(this.storage.getImageInfo(), n2 * 4, 0, 0);
            if (byArray == null) break block4;
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            Object object = new int[]{2, 1, 0, 3};
            this.raster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2 * 4, 4, object, null);
            ColorModel colorModel = this.colorModel;
            WritableRaster writableRaster = this.raster;
            Intrinsics.checkNotNull((Object)writableRaster);
            this.image = new BufferedImage(colorModel, writableRaster, false, null);
            object = this.getLayer().getBackedLayer$skiko().getGraphics();
            if (!this.getLayer().getFullscreen() && this.getLayer().getTransparency() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                int[] nArray = object;
                if (nArray != null) {
                    nArray.setColor(new Color(0, 0, 0, 0));
                }
                int[] nArray2 = object;
                if (nArray2 != null) {
                    nArray2.clearRect(0, 0, n2, n3);
                }
            }
            int[] nArray = object;
            if (nArray != null) {
                BufferedImage bufferedImage = this.image;
                Intrinsics.checkNotNull((Object)bufferedImage);
                nArray.drawImage(bufferedImage, 0, 0, this.getLayer().getWidth(), this.getLayer().getHeight(), null);
            }
        }
    }
}

