/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0084\b\u00f8\u0001\u0000J\b\u0010\u0017\u001a\u00020\u0013H\u0004J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0004J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "<set-?>", "", "isDisposed", "()Z", "isFirstFrameRendered", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "dispose", "", "inDrawScope", "body", "Lkotlin/Function0;", "onContextInit", "onDeviceChosen", "deviceName", "", "update", "nanoTime", "", "skiko"})
public abstract class AWTRedrawer
implements Redrawer {
    private final SkiaLayer layer;
    private final SkiaLayerAnalytics analytics;
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public AWTRedrawer(SkiaLayer skiaLayer, SkiaLayerAnalytics skiaLayerAnalytics, GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        this.layer = skiaLayer;
        this.analytics = skiaLayerAnalytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    protected final void onDeviceChosen(String string) {
        block2: {
            if (!(!this.isDisposed)) {
                boolean bl = false;
                String string2 = this.getClass() + " is disposed";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string3 = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string3.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, string);
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.init();
        }
    }

    protected final void onContextInit() {
        block2: {
            if (!(!this.isDisposed)) {
                boolean bl = false;
                String string = this.getClass() + " is disposed";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.contextInit();
        }
    }

    protected final void update(long l) {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.layer.update$skiko(l);
    }

    protected final void inDrawScope(Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        boolean bl = false;
        if (this.deviceAnalytics == null) {
            boolean bl2 = false;
            String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.isDisposed) {
            block15: {
                if (!this.isFirstFrameRendered) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer skiaLayer = this.layer;
                boolean bl3 = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean bl4 = false;
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    boolean bl5 = false;
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    function0.invoke();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block15;
                    Logger logger = Logger.INSTANCE;
                    boolean bl6 = false;
                    if (logger.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = renderException;
                        SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                        boolean bl7 = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.redrawImmediately();
                    }
                }
            }
            if (!this.isFirstFrameRendered && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
            this.isFirstFrameRendered = true;
        }
    }

    @Override
    public void syncBounds() {
        Redrawer.DefaultImpls.syncBounds(this);
    }

    @Override
    public void setVisible(boolean bl) {
        Redrawer.DefaultImpls.setVisible(this, bl);
    }
}

