/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.MetalApiKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.AcceleratedSwingPainter;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0082 J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\u0011\u0010\u001a\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010H\u0082 J\u0011\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0082 J)\u0010\u001c\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0082 J\b\u0010!\u001a\u00020\"H\u0002J(\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0010H\u0014J\b\u0010%\u001a\u00020&H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "context", "Lorg/jetbrains/skia/DirectContext;", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "texturePtr", "", "dispose", "", "disposeMetalTexture", "texture", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "makeMetalContext", "makeMetalRenderTargetOffScreen", "makeMetalTexture", "oldTexture", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "nanoTime", "rendererInfo", "", "Companion", "skiko"})
public final class MetalSwingRedrawer
extends SwingRedrawerBase {
    public static final Companion Companion = new Companion(null);
    private final SkikoRenderDelegate renderDelegate;
    private final MetalAdapter adapter;
    private final DirectContext context;
    private long texturePtr;
    private final SwingPainter painter;

    public MetalSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        MetalAdapter metalAdapter;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super(swingLayerProperties2, skiaLayerAnalytics, GraphicsApi.METAL);
        this.renderDelegate = skikoRenderDelegate;
        MetalAdapter metalAdapter2 = metalAdapter = MetalApiKt.chooseMetalAdapter(swingLayerProperties2.getAdapterPriority());
        MetalSwingRedrawer metalSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen(metalAdapter2.getName());
        metalSwingRedrawer.adapter = metalAdapter;
        this.context = this.makeMetalContext();
        this.onContextInit();
        this.painter = MetalSwingRedrawer.Companion.createSwingPainter(swingLayerProperties2);
    }

    @Override
    public void dispose() {
        this.disposeMetalTexture(this.texturePtr);
        this.context.close();
        MetalApiKt.dispose(this.adapter);
        this.painter.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRender(Graphics2D graphics2D, int n2, int n3, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        boolean bl = false;
        long l2 = MetalApiKt.access$openAutoreleasepool();
        try {
            boolean bl2 = false;
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, n2, n3, l, graphics2D){
                final /* synthetic */ MetalSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    this.this$0 = metalSwingRedrawer;
                    this.$width = n2;
                    this.$height = n3;
                    this.$nanoTime = l;
                    this.$g = graphics2D;
                    super(1);
                }

                public final void invoke(CloseScope closeScope) {
                    Surface surface;
                    Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
                    MetalSwingRedrawer.access$setTexturePtr$p(this.this$0, MetalSwingRedrawer.access$makeMetalTexture(this.this$0, MetalSwingRedrawer.access$getAdapter$p(this.this$0).getPtr(), MetalSwingRedrawer.access$getTexturePtr$p(this.this$0), this.$width, this.$height));
                    BackendRenderTarget backendRenderTarget = (BackendRenderTarget)closeScope.autoClose((AutoCloseable)MetalSwingRedrawer.access$makeRenderTarget(this.this$0));
                    Managed managed = Surface.Companion.makeFromBackendRenderTarget(MetalSwingRedrawer.access$getContext$p(this.this$0), backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (managed == null || (surface = (Surface)closeScope.autoClose((AutoCloseable)managed)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    Surface surface2 = surface;
                    managed = surface2.getCanvas();
                    ((Canvas)managed).clear(0);
                    MetalSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender((Canvas)managed, this.$width, this.$height, this.$nanoTime);
                    MetalSwingRedrawer.access$flush(this.this$0, surface2, this.$g);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            MetalApiKt.access$closeAutoreleasepool(l2);
        }
    }

    private final void flush(Surface surface, Graphics2D graphics2D) {
        surface.flushAndSubmit(true);
        this.painter.paint(graphics2D, surface, this.texturePtr);
    }

    @Override
    protected String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(this.makeMetalRenderTargetOffScreen(this.texturePtr));
    }

    private final DirectContext makeMetalContext() {
        return new DirectContext(this.makeMetalContext(this.adapter.getPtr()));
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTargetOffScreen(long var1);

    private final native long makeMetalTexture(long var1, long var3, int var5, int var6);

    private final native long disposeMetalTexture(long var1);

    public static final /* synthetic */ void access$setTexturePtr$p(MetalSwingRedrawer metalSwingRedrawer, long l) {
        metalSwingRedrawer.texturePtr = l;
    }

    public static final /* synthetic */ long access$makeMetalTexture(MetalSwingRedrawer metalSwingRedrawer, long l, long l2, int n2, int n3) {
        return metalSwingRedrawer.makeMetalTexture(l, l2, n2, n3);
    }

    public static final /* synthetic */ MetalAdapter access$getAdapter$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.adapter;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.context;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(MetalSwingRedrawer metalSwingRedrawer, Surface surface, Graphics2D graphics2D) {
        metalSwingRedrawer.flush(surface, graphics2D);
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer$Companion;", "", "()V", "createSwingPainter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        private final SwingPainter createSwingPainter(SwingLayerProperties swingLayerProperties2) {
            SwingPainter swingPainter;
            try {
                swingPainter = new AcceleratedSwingPainter();
            }
            catch (RenderException renderException) {
                swingPainter = new SoftwareSwingPainter(swingLayerProperties2);
            }
            return swingPainter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

