/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.NativeAccessibleFocusHelper;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.swing.SkiaSwingLayer;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingRedrawer;
import org.jetbrains.skiko.swing.SwingRedrawerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002$'\b\u0017\u0018\u0000 62\u00020\u0001:\u00016B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020*J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0012\u0010.\u001a\u00020*2\b\b\u0002\u0010/\u001a\u00020\u0013H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020*H\u0016J\u0010\u00104\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u00010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u00067"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "Ljavax/swing/JPanel;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "externalAccessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "(Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "isDisposed", "", "isInitialized", "nativeAccessibleFocusHelper", "Lorg/jetbrains/skiko/NativeAccessibleFocusHelper;", "getNativeAccessibleFocusHelper$annotations", "()V", "redrawer", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "getRedrawer", "()Lorg/jetbrains/skiko/swing/SwingRedrawer;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "renderDelegateWithClipping", "org/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1;", "swingLayerProperties", "org/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "addNotify", "", "dispose", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "init", "recreation", "paint", "g", "Ljava/awt/Graphics;", "removeNotify", "requestNativeFocusOnAccessible", "accessible", "Companion", "skiko"})
public class SkiaSwingLayer
extends JPanel {
    public static final Companion Companion = new Companion(null);
    private final SkiaLayerProperties properties;
    private boolean isInitialized;
    private volatile boolean isDisposed;
    private final renderDelegateWithClipping.1 renderDelegateWithClipping;
    private final swingLayerProperties.1 swingLayerProperties;
    private final RedrawerManager<SwingRedrawer> redrawerManager;
    private final NativeAccessibleFocusHelper nativeAccessibleFocusHelper;

    public SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics, Function1<? super Component, ? extends Accessible> function1, SkiaLayerProperties skiaLayerProperties) {
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        this.properties = skiaLayerProperties;
        this.renderDelegateWithClipping = new SkikoRenderDelegate(skikoRenderDelegate, this){
            private final /* synthetic */ SkikoRenderDelegate $$delegate_0;
            final /* synthetic */ SkikoRenderDelegate $renderDelegate;
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.$renderDelegate = skikoRenderDelegate;
                this.this$0 = skiaSwingLayer;
                this.$$delegate_0 = skikoRenderDelegate;
            }

            public void onRender(Canvas canvas, int n2, int n3, long l) {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
                float f = (float)this.this$0.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                for (ClipRectangle clipRectangle : this.this$0.getClipComponents()) {
                    SkiaLayer_awtKt.clipRectBy(canvas, clipRectangle, f);
                }
                this.$renderDelegate.onRender(canvas, n2, n3, l);
            }
        };
        this.swingLayerProperties = new SwingLayerProperties(this){
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.this$0 = skiaSwingLayer;
            }

            public int getWidth() {
                return this.this$0.getWidth();
            }

            public int getHeight() {
                return this.this$0.getHeight();
            }

            public GraphicsConfiguration getGraphicsConfiguration() {
                GraphicsConfiguration graphicsConfiguration = this.this$0.getGraphicsConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"");
                return graphicsConfiguration;
            }

            public GpuPriority getAdapterPriority() {
                return SkiaSwingLayer.access$getProperties$p(this.this$0).getAdapterPriority();
            }
        };
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), (Function2)new Function2<GraphicsApi, SwingRedrawer, SwingRedrawer>(this, skiaLayerAnalytics){
            final /* synthetic */ SkiaSwingLayer this$0;
            final /* synthetic */ SkiaLayerAnalytics $analytics;
            {
                this.this$0 = skiaSwingLayer;
                this.$analytics = skiaLayerAnalytics;
                super(2);
            }

            public final SwingRedrawer invoke(GraphicsApi graphicsApi, SwingRedrawer swingRedrawer) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
                    SwingRedrawer swingRedrawer2 = swingRedrawer;
                    if (swingRedrawer2 == null) break block0;
                    swingRedrawer2.dispose();
                }
                return SwingRedrawerKt.createSwingRedrawer(SkiaSwingLayer.access$getSwingLayerProperties$p(this.this$0), SkiaSwingLayer.access$getRenderDelegateWithClipping$p(this.this$0), graphicsApi, this.$analytics);
            }
        }, null, 4, null);
        this.setOpaque(false);
        this.setLayout(null);
        Function1<? super Component, ? extends Accessible> function12 = function1;
        this.nativeAccessibleFocusHelper = new NativeAccessibleFocusHelper(this, function12 != null ? (Accessible)function12.invoke((Object)this) : null);
    }

    public /* synthetic */ SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics, Function1 function1, SkiaLayerProperties skiaLayerProperties, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        if ((n2 & 8) != 0) {
            skiaLayerProperties = new SkiaLayerProperties(false, false, null, null, null, 31, null);
        }
        this(skikoRenderDelegate, skiaLayerAnalytics, (Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties);
    }

    public final List<ClipRectangle> getClipComponents() {
        return new ArrayList();
    }

    private final SwingRedrawer getRedrawer() {
        return this.redrawerManager.getRedrawer();
    }

    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    @Override
    public void removeNotify() {
        Logger logger = Logger.INSTANCE;
        boolean bl = false;
        if (logger.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#removeNotify " + this);
        }
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Logger logger = Logger.INSTANCE;
        boolean bl = false;
        if (logger.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#addNotify " + this);
        }
        super.addNotify();
        this.init(this.isInitialized);
    }

    private final void init(boolean bl) {
        this.isDisposed = false;
        this.redrawerManager.findNextWorkingRenderApi(bl);
        this.isInitialized = true;
    }

    static /* synthetic */ void init$default(SkiaSwingLayer skiaSwingLayer, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n2 & 1) != 0) {
            bl = false;
        }
        skiaSwingLayer.init(bl);
    }

    public final void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInitialized && !this.isDisposed) {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.dispose();
            }
            this.redrawerManager.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"");
            try {
                SwingRedrawer swingRedrawer = this.getRedrawer();
                if (swingRedrawer != null) {
                    swingRedrawer.redraw((Graphics2D)graphics);
                }
            }
            catch (RenderException renderException) {
                if (this.isDisposed) break block4;
                Logger logger = Logger.INSTANCE;
                boolean bl = false;
                if (logger.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = renderException;
                    SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                    boolean bl2 = false;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface.warn(throwable, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                this.repaint();
            }
        }
    }

    private static /* synthetic */ void getNativeAccessibleFocusHelper$annotations() {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = this.nativeAccessibleFocusHelper.getAccessibleContext();
        if (accessibleContext == null) {
            accessibleContext = super.getAccessibleContext();
        }
        return accessibleContext;
    }

    public final void requestNativeFocusOnAccessible(Accessible accessible) {
        this.nativeAccessibleFocusHelper.requestNativeFocusOnAccessible(accessible);
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaSwingLayer skiaSwingLayer) {
        return skiaSwingLayer.properties;
    }

    public static final /* synthetic */ swingLayerProperties.1 access$getSwingLayerProperties$p(SkiaSwingLayer skiaSwingLayer) {
        return skiaSwingLayer.swingLayerProperties;
    }

    public static final /* synthetic */ renderDelegateWithClipping.1 access$getRenderDelegateWithClipping$p(SkiaSwingLayer skiaSwingLayer) {
        return skiaSwingLayer.renderDelegateWithClipping;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

