/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0080\u0001\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002Jv\u0010(\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\u001d2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002Jd\u0010*\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\r2\b\b\u0002\u0010,\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\r2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0002J \u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0018\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "bufferedImage", "Ljava/awt/image/BufferedImage;", "createImageFromBytes", "pBytes", "", "width", "", "height", "dispose", "", "doDraw", "op", "Ljava/awt/image/BufferedImageOp;", "image", "Ljava/awt/Image;", "invG", "Ljava/awt/Graphics2D;", "hasDestinationSize", "", "dw", "dh", "sourceBounds", "Ljava/awt/Rectangle;", "userWidth", "userHeight", "g", "Ljava/awt/Graphics;", "dx", "dy", "observer", "Ljava/awt/image/ImageObserver;", "scale", "", "doDrawHiDpi", "srcBounds", "drawImage", "x", "y", "paint", "surface", "Lorg/jetbrains/skia/Surface;", "texture", "scaleSize", "size", "skiko"})
public final class SoftwareSwingPainter
implements SwingPainter {
    private final SwingLayerProperties swingLayerProperties;
    private BufferedImage bufferedImage;
    private Bitmap bitmap;

    public SoftwareSwingPainter(SwingLayerProperties swingLayerProperties2) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        this.swingLayerProperties = swingLayerProperties2;
        this.bufferedImage = new BufferedImage(1, 1, 3);
        this.bitmap = new Bitmap();
    }

    @Override
    public void paint(Graphics2D graphics2D, Surface surface, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"");
        int n2 = surface.getWidth();
        int n3 = surface.getHeight();
        if (this.bitmap.getWidth() != n2 || this.bitmap.getHeight() != n3) {
            this.bitmap.allocPixelsFlags(ImageInfo.Companion.makeS32(n2, n3, ColorAlphaType.PREMUL), false);
        }
        surface.readPixels(this.bitmap, 0, 0);
        Pixmap pixmap = this.bitmap.peekPixels();
        if (pixmap == null) {
            throw new RenderException("Can't get pixels address", null, 2, null);
        }
        long l2 = pixmap.getAddr();
        this.bufferedImage = this.createImageFromBytes(l2, n2, n3);
        SoftwareSwingPainter.drawImage$default(this, graphics2D, this.bufferedImage, 0, 0, 0, 0, null, null, null, 508, null);
    }

    @Override
    public void dispose() {
        this.bitmap.close();
    }

    private final BufferedImage createImageFromBytes(long l, int n2, int n3) {
        if (this.bufferedImage.getWidth() != n2 || this.bufferedImage.getHeight() != n3) {
            this.bufferedImage = new BufferedImage(n2, n3, 3);
        }
        BufferedImage bufferedImage = this.bufferedImage;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer);
        int[] nArray = ((DataBufferInt)dataBuffer).getData();
        ByteBuffer byteBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(l, n2 * n3 * 4);
        IntBuffer intBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"");
        IntBuffer intBuffer2 = intBuffer;
        intBuffer2.position(0).get(nArray, 0, Math.min(bufferedImage.getHeight() * bufferedImage.getWidth(), intBuffer2.capacity()));
        return bufferedImage;
    }

    private final void drawImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver) {
        boolean bl = n4 >= 0 && n5 >= 0;
        this.doDrawHiDpi(this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), graphics, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), n2, n3, n4, n5, bl, bufferedImageOp, image, rectangle, imageObserver);
    }

    static /* synthetic */ void drawImage$default(SoftwareSwingPainter softwareSwingPainter, Graphics graphics, Image image, int n2, int n3, int n4, int n5, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n2 = 0;
        }
        if ((n6 & 8) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n4 = -1;
        }
        if ((n6 & 0x20) != 0) {
            n5 = -1;
        }
        if ((n6 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n6 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n6 & 0x100) != 0) {
            imageObserver = null;
        }
        softwareSwingPainter.drawImage(graphics, image, n2, n3, n4, n5, rectangle, bufferedImageOp, imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doDrawHiDpi(int n2, int n3, Graphics graphics, double d2, int n4, int n5, int n6, int n7, boolean bl, BufferedImageOp bufferedImageOp, Image image, Rectangle rectangle, ImageObserver imageObserver) {
        double d3;
        Graphics graphics2 = graphics;
        double d4 = d2;
        int n8 = n4;
        int n9 = n5;
        double d5 = 0.0;
        int n10 = Math.max(n2, n3);
        if (n10 < 0x3FFFFFFF) {
            int n11 = 1;
            double d6 = 0.0;
            while (true) {
                double d7 = d3 = Math.pow(10.0, n11);
                double d8 = n10;
                boolean bl2 = false;
                d6 = d7;
                Unit unit = Unit.INSTANCE;
                if (!(d8 > d3)) break;
                ++n11;
            }
            d5 = 1.0 / d6;
        }
        Graphics graphics3 = graphics2;
        Intrinsics.checkNotNull((Object)graphics3);
        AffineTransform affineTransform = ((Graphics2D)graphics3).getTransform();
        Graphics graphics4 = null;
        if ((affineTransform.getType() & 0x18) == 0 && Math.abs(d4 - affineTransform.getScaleX()) <= d5) {
            d4 = affineTransform.getScaleX();
            d3 = affineTransform.getScaleX();
            double d9 = affineTransform.getScaleY();
            affineTransform.scale(1.0 / d3, 1.0 / d9);
            affineTransform.translate((double)n8 * d3, (double)n9 * d9);
            n9 = 0;
            n8 = 0;
            Graphics graphics5 = graphics2.create();
            Intrinsics.checkNotNull((Object)graphics5);
            graphics2 = graphics4 = (Graphics2D)graphics5;
            ((Graphics2D)graphics4).setTransform(affineTransform);
        }
        try {
            int n12 = n6;
            int n13 = n7;
            if (graphics4 != null && bl) {
                n12 = this.scaleSize(n12, d4);
                n13 = this.scaleSize(n13, d4);
            }
            this.doDraw(bufferedImageOp, image, (Graphics2D)graphics4, bl, n12, n13, rectangle, n2, n3, graphics2, n8, n9, imageObserver, d4);
        }
        finally {
            Graphics graphics6 = graphics4;
            if (graphics6 != null) {
                graphics6.dispose();
            }
        }
    }

    private final int scaleSize(int n2, double d2) {
        return MathKt.roundToInt((double)((double)n2 * d2));
    }

    private final void doDraw(BufferedImageOp bufferedImageOp, Image image, Graphics2D graphics2D, boolean bl, int n2, int n3, Rectangle rectangle, int n4, int n5, Graphics graphics, int n6, int n7, ImageObserver imageObserver, double d2) {
        Image image2 = image;
        if (bufferedImageOp != null && image2 instanceof BufferedImage) {
            BufferedImage bufferedImage = bufferedImageOp.filter((BufferedImage)image2, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"");
            image2 = bufferedImage;
        }
        if (rectangle != null) {
            int n8 = SoftwareSwingPainter.doDraw$size(this, d2, rectangle.x);
            int n9 = SoftwareSwingPainter.doDraw$size(this, d2, rectangle.y);
            int n10 = rectangle.width >= 0 ? SoftwareSwingPainter.doDraw$size(this, d2, rectangle.width) : SoftwareSwingPainter.doDraw$size(this, d2, n4) - n8;
            int n11 = rectangle.height >= 0 ? SoftwareSwingPainter.doDraw$size(this, d2, rectangle.height) : SoftwareSwingPainter.doDraw$size(this, d2, n5) - n9;
            int n12 = n2;
            int n13 = n3;
            if (!bl) {
                n12 = SoftwareSwingPainter.doDraw$size(this, d2, n4);
                n13 = SoftwareSwingPainter.doDraw$size(this, d2, n5);
            }
            graphics.drawImage(image2, n6, n7, n6 + n12, n7 + n13, n8, n9, n8 + n10, n9 + n11, imageObserver);
        } else if (bl) {
            graphics.drawImage(image2, n6, n7, n2, n3, imageObserver);
        } else if (graphics2D == null) {
            graphics.drawImage(image2, n6, n7, n4, n5, imageObserver);
        } else {
            graphics.drawImage(image2, n6, n7, imageObserver);
        }
    }

    private static final int doDraw$size(SoftwareSwingPainter softwareSwingPainter, double d2, int n2) {
        return softwareSwingPainter.scaleSize(n2, d2);
    }
}

