/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.platform.InternalFontApiChecker;
import androidx.compose.ui.text.platform.ReflectionUtil;
import java.awt.Font;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u0016J\u0010\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0001*\u00020\u0019H\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0001H\u0002J3\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u001d2\u001a\u0010&\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050'\"\u0006\u0012\u0002\b\u00030\u0005H\u0002\u00a2\u0006\u0002\u0010(R\u001e\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/compose/ui/text/platform/AwtFontUtils;", "", "<init>", "()V", "FontManagerFactoryClass", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "FontManagerClass", "Font2DClass", "CompositeFontClass", "PhysicalFontClass", "CFontClass", "FontManagerFactory_getInstanceMethod", "Ljava/lang/reflect/Method;", "FontManager_findFont2DMethod", "Font2D_getTypographicFamilyNameMethod", "Font2D_getFamilyNameMethod", "Font2D_handleField", "Ljava/lang/reflect/Field;", "Font2DHandle_font2DField", "CompositeFont_getSlotFontMethod", "LOGICAL_FALLBACK", "", "font2DHandlesCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/awt/Font;", "isAbleToResolveFontProperties", "", "resolvePhysicalFontFamilyNameOrNull", "", "familyName", "style", "getPreferredFontFamilyName", "font", "obtainFont2DOrNull", "getSunFontManagerInstance", "getFont2DMethodOrNull", "methodName", "parameters", "", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "ui-text"})
public final class AwtFontUtils {
    public static final AwtFontUtils INSTANCE = new AwtFontUtils();
    private static final Class<?> FontManagerFactoryClass;
    private static final Class<?> FontManagerClass;
    private static final Class<?> Font2DClass;
    private static final Class<?> CompositeFontClass;
    private static final Class<?> PhysicalFontClass;
    private static final Class<?> CFontClass;
    private static final Method FontManagerFactory_getInstanceMethod;
    private static final Method FontManager_findFont2DMethod;
    private static final Method Font2D_getTypographicFamilyNameMethod;
    private static final Method Font2D_getFamilyNameMethod;
    private static final Field Font2D_handleField;
    private static final Field Font2DHandle_font2DField;
    private static final Method CompositeFont_getSlotFontMethod;
    private static final int LOGICAL_FALLBACK = 2;
    private static final ConcurrentHashMap<Font, Object> font2DHandlesCache;
    private static final boolean isAbleToResolveFontProperties;
    public static final int $stable;

    private AwtFontUtils() {
    }

    public final String resolvePhysicalFontFamilyNameOrNull(String string, int n) {
        String string2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (!isAbleToResolveFontProperties) {
            return null;
        }
        Object object = this.getSunFontManagerInstance();
        Object object2 = FontManager_findFont2DMethod;
        if (object2 == null || (object2 = ((Method)object2).invoke(object, objectArray = new Object[]{string, n, 2})) == null) {
            return null;
        }
        Object object3 = object2;
        if (CompositeFontClass.isInstance(object3)) {
            Object object4;
            Object object5;
            Method method = CompositeFont_getSlotFontMethod;
            if (method != null) {
                objectArray = new Object[]{0};
                object5 = method.invoke(object3, objectArray);
            } else {
                object5 = null;
            }
            Object object6 = object5;
            Method method2 = Font2D_getFamilyNameMethod;
            if (method2 != null) {
                objectArray = new Object[]{Locale.getDefault()};
                object4 = method2.invoke(object6, objectArray);
            } else {
                object4 = null;
            }
            string2 = (String)object4;
        } else {
            Class<?> clazz = CFontClass;
            boolean bl = clazz != null ? clazz.isInstance(object3) : false;
            if (bl) {
                String string3 = ReflectionUtil.INSTANCE.getFieldValueOrNull(CFontClass, object3, String.class, "nativeFontName");
                string2 = this.getPreferredFontFamilyName(new Font(string3, 0, 10));
            } else if (PhysicalFontClass.isInstance(object3)) {
                Method method = Font2D_getTypographicFamilyNameMethod;
                string2 = (String)(method != null ? method.invoke(object3, new Object[0]) : null);
            } else {
                string2 = null;
            }
        }
        return string2;
    }

    public static /* synthetic */ String resolvePhysicalFontFamilyNameOrNull$default(AwtFontUtils awtFontUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return awtFontUtils.resolvePhysicalFontFamilyNameOrNull(string, n);
    }

    public final String getPreferredFontFamilyName(Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        if (!isAbleToResolveFontProperties) {
            return null;
        }
        Object object = this.obtainFont2DOrNull(font);
        if (object == null) {
            return null;
        }
        Object object2 = object;
        Method method = Font2D_getTypographicFamilyNameMethod;
        Object object3 = method != null ? method.invoke(object2, new Object[0]) : null;
        return object3 instanceof String ? (String)object3 : null;
    }

    private final Object obtainFont2DOrNull(Font font) {
        ConcurrentMap concurrentMap = font2DHandlesCache;
        boolean bl = false;
        Object object = concurrentMap.get(font);
        if (object == null) {
            Object object2;
            boolean bl2 = false;
            Object object3 = INSTANCE.getSunFontManagerInstance();
            Method method = FontManager_findFont2DMethod;
            if (method != null) {
                Object[] objectArray = new Object[]{font.getName(), font.getStyle(), 2};
                object2 = method.invoke(object3, objectArray);
            } else {
                object2 = null;
            }
            Object object4 = object2;
            Field field = Font2D_handleField;
            Object object5 = field != null ? field.get(object4) : null;
            boolean bl3 = false;
            object = concurrentMap.putIfAbsent(font, object5);
            if (object == null) {
                object = object5;
            }
        }
        Object v = object;
        Field field = Font2DHandle_font2DField;
        return field != null ? field.get(v) : null;
    }

    private final Object getSunFontManagerInstance() {
        Method method = FontManagerFactory_getInstanceMethod;
        return method != null ? method.invoke(null, new Object[0]) : null;
    }

    private final Method getFont2DMethodOrNull(String string, Class<?> ... classArray) {
        Class<?> clazz = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, string, Arrays.copyOf(classArray, classArray.length));
    }

    private static final boolean Font2D_handleField$lambda$0(Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"");
        return Intrinsics.areEqual((Object)field.getName(), (Object)"handle");
    }

    private static final boolean Font2D_handleField$lambda$1(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final boolean Font2DHandle_font2DField$lambda$2(Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"");
        return Intrinsics.areEqual((Object)field.getName(), (Object)"font2D");
    }

    private static final boolean Font2DHandle_font2DField$lambda$3(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    static {
        InternalFontApiChecker.INSTANCE.isSunFontApiAccessible();
        FontManagerFactoryClass = Class.forName("sun.font.FontManagerFactory");
        FontManagerClass = Class.forName("sun.font.FontManager");
        Font2DClass = Class.forName("sun.font.Font2D");
        CompositeFontClass = Class.forName("sun.font.CompositeFont");
        PhysicalFontClass = Class.forName("sun.font.PhysicalFont");
        CFontClass = OsArch_jvmKt.getHostOs().isMacOS() ? Class.forName("sun.font.CFont") : null;
        Class<?> clazz = FontManagerFactoryClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        FontManagerFactory_getInstanceMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, "getInstance", new Class[0]);
        Class<?> clazz2 = FontManagerClass;
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
        Class[] classArray = new Class[3];
        classArray[0] = String.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        Intrinsics.checkNotNull(Integer.TYPE);
        FontManager_findFont2DMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz2, "findFont2D", classArray);
        Font2D_getTypographicFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getTypographicFamilyName", new Class[0]);
        classArray = new Class[]{Locale.class};
        Font2D_getFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getFamilyName", classArray);
        Class<?> clazz3 = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"");
        Font2D_handleField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz3, arg_0 -> AwtFontUtils.Font2D_handleField$lambda$1(AwtFontUtils::Font2D_handleField$lambda$0, arg_0));
        Class<?> clazz4 = Class.forName("sun.font.Font2DHandle");
        Intrinsics.checkNotNullExpressionValue(clazz4, (String)"");
        Font2DHandle_font2DField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz4, arg_0 -> AwtFontUtils.Font2DHandle_font2DField$lambda$3(AwtFontUtils::Font2DHandle_font2DField$lambda$2, arg_0));
        Class<?> clazz5 = CompositeFontClass;
        Intrinsics.checkNotNullExpressionValue(clazz5, (String)"");
        classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        CompositeFont_getSlotFontMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz5, "getSlotFont", classArray);
        font2DHandlesCache = new ConcurrentHashMap();
        isAbleToResolveFontProperties = InternalFontApiChecker.INSTANCE.isRunningOnJetBrainsRuntime() && InternalFontApiChecker.INSTANCE.isSunFontApiAccessible() && Font2D_getTypographicFamilyNameMethod != null;
        $stable = 8;
    }
}

