/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.TextDelegateKt;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextPainter;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 H2\u00020\u0001:\u0001HBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020/J\u001f\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u00020/H\u0002\u00a2\u0006\u0004\bA\u0010BJ)\u0010C\u001a\u00020D2\u0006\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u00020/2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010D\u00a2\u0006\u0004\bF\u0010GR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000b\u001a\u00020\f\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b \u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010+R\u0011\u00106\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u001cR\u0011\u00108\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001c\u00a8\u0006I"}, d2={"Landroidx/compose/foundation/text/TextDelegate;", "", "text", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "maxLines", "", "minLines", "softWrap", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;IIZILandroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;Ljava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "getStyle", "()Landroidx/compose/ui/text/TextStyle;", "getMaxLines", "()I", "getMinLines", "getSoftWrap", "()Z", "getOverflow-gIe3tQ8", "I", "getDensity", "()Landroidx/compose/ui/unit/Density;", "getFontFamilyResolver", "()Landroidx/compose/ui/text/font/FontFamily$Resolver;", "getPlaceholders", "()Ljava/util/List;", "paragraphIntrinsics", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "getParagraphIntrinsics$foundation", "()Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$foundation", "(Landroidx/compose/ui/text/MultiParagraphIntrinsics;)V", "intrinsicsLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getIntrinsicsLayoutDirection$foundation", "()Landroidx/compose/ui/unit/LayoutDirection;", "setIntrinsicsLayoutDirection$foundation", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "nonNullIntrinsics", "getNonNullIntrinsics", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "layoutIntrinsics", "", "layoutDirection", "layoutText", "Landroidx/compose/ui/text/MultiParagraph;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "layoutText-K40F9xA", "(JLandroidx/compose/ui/unit/LayoutDirection;)Landroidx/compose/ui/text/MultiParagraph;", "layout", "Landroidx/compose/ui/text/TextLayoutResult;", "prevResult", "layout-NN6Ew-U", "(JLandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/text/TextLayoutResult;)Landroidx/compose/ui/text/TextLayoutResult;", "Companion", "foundation"})
public final class TextDelegate {
    public static final Companion Companion = new Companion(null);
    private final AnnotatedString text;
    private final TextStyle style;
    private final int maxLines;
    private final int minLines;
    private final boolean softWrap;
    private final int overflow;
    private final Density density;
    private final FontFamily.Resolver fontFamilyResolver;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private MultiParagraphIntrinsics paragraphIntrinsics;
    private LayoutDirection intrinsicsLayoutDirection;
    public static final int $stable;

    private TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n2, int n3, boolean bl, int n4, Density density, FontFamily.Resolver resolver, List<AnnotatedString.Range<Placeholder>> list) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.text = annotatedString;
        this.style = textStyle;
        this.maxLines = n2;
        this.minLines = n3;
        this.softWrap = bl;
        this.overflow = n4;
        this.density = density;
        this.fontFamilyResolver = resolver;
        this.placeholders = list;
        boolean bl3 = this.maxLines > 0;
        boolean bl4 = false;
        if (!bl3) {
            bl2 = false;
            InlineClassHelperKt.throwIllegalArgumentException("no maxLines");
        }
        bl3 = this.minLines > 0;
        bl4 = false;
        if (!bl3) {
            bl2 = false;
            InlineClassHelperKt.throwIllegalArgumentException("no minLines");
        }
        bl3 = this.minLines <= this.maxLines;
        bl4 = false;
        if (!bl3) {
            bl2 = false;
            InlineClassHelperKt.throwIllegalArgumentException("minLines greater than maxLines");
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n2, int n3, boolean bl, int n4, Density density, FontFamily.Resolver resolver, List list, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n5 & 8) != 0) {
            n3 = 1;
        }
        if ((n5 & 0x10) != 0) {
            bl = true;
        }
        if ((n5 & 0x20) != 0) {
            n4 = TextOverflow.Companion.getClip-gIe3tQ8();
        }
        if ((n5 & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(annotatedString, textStyle, n2, n3, bl, n4, density, resolver, list, null);
    }

    public final AnnotatedString getText() {
        return this.text;
    }

    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final int getMinLines() {
        return this.minLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    public final int getOverflow-gIe3tQ8() {
        return this.overflow;
    }

    public final Density getDensity() {
        return this.density;
    }

    public final FontFamily.Resolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    public final MultiParagraphIntrinsics getParagraphIntrinsics$foundation() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$foundation(MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    public final LayoutDirection getIntrinsicsLayoutDirection$foundation() {
        return this.intrinsicsLayoutDirection;
    }

    public final void setIntrinsicsLayoutDirection$foundation(LayoutDirection layoutDirection) {
        this.intrinsicsLayoutDirection = layoutDirection;
    }

    private final MultiParagraphIntrinsics getNonNullIntrinsics() {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutIntrinsics must be called first");
        }
        return multiParagraphIntrinsics;
    }

    public final int getMinIntrinsicWidth() {
        return TextDelegateKt.ceilToIntPx(this.getNonNullIntrinsics().getMinIntrinsicWidth());
    }

    public final int getMaxIntrinsicWidth() {
        return TextDelegateKt.ceilToIntPx(this.getNonNullIntrinsics().getMaxIntrinsicWidth());
    }

    public final void layoutIntrinsics(LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics2;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        MultiParagraphIntrinsics multiParagraphIntrinsics3 = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics3 == null || layoutDirection != this.intrinsicsLayoutDirection || multiParagraphIntrinsics3.getHasStaleResolvedFonts()) {
            this.intrinsicsLayoutDirection = layoutDirection;
            AnnotatedString annotatedString = this.text;
            TextStyle textStyle = TextStyleKt.resolveDefaults((TextStyle)this.style, (LayoutDirection)layoutDirection);
            Density density = this.density;
            FontFamily.Resolver resolver = this.fontFamilyResolver;
            List<AnnotatedString.Range<Placeholder>> list = this.placeholders;
            multiParagraphIntrinsics2 = new MultiParagraphIntrinsics(annotatedString, textStyle, list, density, resolver);
        } else {
            multiParagraphIntrinsics2 = multiParagraphIntrinsics3;
        }
        this.paragraphIntrinsics = multiParagraphIntrinsics = multiParagraphIntrinsics2;
    }

    private final MultiParagraph layoutText-K40F9xA(long l2, LayoutDirection layoutDirection) {
        this.layoutIntrinsics(layoutDirection);
        int n2 = Constraints.getMinWidth-impl((long)l2);
        boolean bl = this.softWrap || TextOverflow.equals-impl0((int)this.overflow, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int n3 = bl && Constraints.getHasBoundedWidth-impl((long)l2) ? Constraints.getMaxWidth-impl((long)l2) : Integer.MAX_VALUE;
        boolean bl2 = !this.softWrap && TextOverflow.equals-impl0((int)this.overflow, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int n4 = bl2 ? 1 : this.maxLines;
        int n5 = n2 == n3 ? n3 : RangesKt.coerceIn((int)this.getMaxIntrinsicWidth(), (int)n2, (int)n3);
        return new MultiParagraph(this.getNonNullIntrinsics(), Constraints.Companion.fitPrioritizingWidth-Zbe2FdA(0, n5, 0, Constraints.getMaxHeight-impl((long)l2)), n4, this.overflow, null);
    }

    public final TextLayoutResult layout-NN6Ew-U(long l2, LayoutDirection layoutDirection, TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        if (textLayoutResult != null && TextLayoutHelperKt.canReuse-7_7YC6M(textLayoutResult, this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, l2)) {
            TextLayoutResult textLayoutResult2 = textLayoutResult;
            boolean bl = false;
            int n2 = TextDelegateKt.ceilToIntPx(textLayoutResult2.getMultiParagraph().getWidth());
            int n3 = TextDelegateKt.ceilToIntPx(textLayoutResult2.getMultiParagraph().getHeight());
            boolean bl2 = false;
            boolean bl3 = false;
            return textLayoutResult2.copy-O0kMr_c(new TextLayoutInput(textLayoutResult2.getLayoutInput().getText(), this.style, textLayoutResult2.getLayoutInput().getPlaceholders(), textLayoutResult2.getLayoutInput().getMaxLines(), textLayoutResult2.getLayoutInput().getSoftWrap(), textLayoutResult2.getLayoutInput().getOverflow-gIe3tQ8(), textLayoutResult2.getLayoutInput().getDensity(), textLayoutResult2.getLayoutInput().getLayoutDirection(), textLayoutResult2.getLayoutInput().getFontFamilyResolver(), l2, null), ConstraintsKt.constrain-4WqzIAM((long)l2, (long)IntSize.constructor-impl((long)((long)n2 << 32 | (long)n3 & 0xFFFFFFFFL))));
        }
        MultiParagraph multiParagraph = this.layoutText-K40F9xA(l2, layoutDirection);
        int n4 = TextDelegateKt.ceilToIntPx(multiParagraph.getWidth());
        int n5 = TextDelegateKt.ceilToIntPx(multiParagraph.getHeight());
        boolean bl = false;
        boolean bl4 = false;
        long l3 = ConstraintsKt.constrain-4WqzIAM((long)l2, (long)IntSize.constructor-impl((long)((long)n4 << 32 | (long)n5 & 0xFFFFFFFFL)));
        return new TextLayoutResult(new TextLayoutInput(this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, l2, null), multiParagraph, l3, null);
    }

    public static /* synthetic */ TextLayoutResult layout-NN6Ew-U$default(TextDelegate textDelegate, long l2, LayoutDirection layoutDirection, TextLayoutResult textLayoutResult, int n2, Object object) {
        if ((n2 & 4) != 0) {
            textLayoutResult = null;
        }
        return textDelegate.layout-NN6Ew-U(l2, layoutDirection, textLayoutResult);
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n2, int n3, boolean bl, int n4, Density density, FontFamily.Resolver resolver, List list, DefaultConstructorMarker defaultConstructorMarker) {
        this(annotatedString, textStyle, n2, n3, bl, n4, density, resolver, list);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Landroidx/compose/foundation/text/TextDelegate$Companion;", "", "<init>", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public final void paint(Canvas canvas, TextLayoutResult textLayoutResult) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"");
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

