/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u001ao\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a%\u0010\u001a\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0014\u0010!\u001a\u00020\"*\u00020\u00022\u0006\u0010#\u001a\u00020\fH\u0000\u00a8\u0006$"}, d2={"canReuse", "", "Landroidx/compose/ui/text/TextLayoutResult;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "maxLines", "", "softWrap", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "canReuse-7_7YC6M", "(Landroidx/compose/ui/text/TextLayoutResult;Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;IZILandroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/text/font/FontFamily$Resolver;J)Z", "isPositionInsideSelection", "position", "Landroidx/compose/ui/geometry/Offset;", "selectionRange", "Landroidx/compose/ui/text/TextRange;", "isPositionInsideSelection-uaM50fQ", "(Landroidx/compose/ui/text/TextLayoutResult;JLandroidx/compose/ui/text/TextRange;)Z", "getLineHeight", "", "offset", "foundation"})
public final class TextLayoutHelperKt {
    public static final boolean canReuse-7_7YC6M(TextLayoutResult textLayoutResult, AnnotatedString annotatedString, TextStyle textStyle, List<AnnotatedString.Range<Placeholder>> list, int n2, boolean bl, int n3, Density density, LayoutDirection layoutDirection, FontFamily.Resolver resolver, long l2) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"");
        TextLayoutInput textLayoutInput = textLayoutResult.getLayoutInput();
        if (textLayoutResult.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts()) {
            return false;
        }
        if (!(Intrinsics.areEqual((Object)textLayoutInput.getText(), (Object)annotatedString) && textLayoutInput.getStyle().hasSameLayoutAffectingAttributes(textStyle) && Intrinsics.areEqual((Object)textLayoutInput.getPlaceholders(), list) && textLayoutInput.getMaxLines() == n2 && textLayoutInput.getSoftWrap() == bl && TextOverflow.equals-impl0((int)textLayoutInput.getOverflow-gIe3tQ8(), (int)n3) && Intrinsics.areEqual((Object)textLayoutInput.getDensity(), (Object)density) && textLayoutInput.getLayoutDirection() == layoutDirection && Intrinsics.areEqual((Object)textLayoutInput.getFontFamilyResolver(), (Object)resolver))) {
            return false;
        }
        if (Constraints.getMinWidth-impl((long)l2) != Constraints.getMinWidth-impl((long)textLayoutInput.getConstraints-msEJaDk())) {
            return false;
        }
        if (!bl && !TextOverflow.equals-impl0((int)n3, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8())) {
            return true;
        }
        return Constraints.getMaxWidth-impl((long)l2) == Constraints.getMaxWidth-impl((long)textLayoutInput.getConstraints-msEJaDk()) && Constraints.getMaxHeight-impl((long)l2) == Constraints.getMaxHeight-impl((long)textLayoutInput.getConstraints-msEJaDk());
    }

    public static final boolean isPositionInsideSelection-uaM50fQ(TextLayoutResult textLayoutResult, long l2, TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"");
        if (textRange == null || TextRange.getCollapsed-impl((long)textRange.unbox-impl())) {
            return false;
        }
        int n2 = textLayoutResult.getOffsetForPosition-k-4lQ0M(l2);
        return TextLayoutHelperKt.isPositionInsideSelection_uaM50fQ$isOffsetSelectedAndContainsPosition(textRange, textLayoutResult, l2, n2) || TextLayoutHelperKt.isPositionInsideSelection_uaM50fQ$isOffsetSelectedAndContainsPosition(textRange, textLayoutResult, l2, n2 - 1);
    }

    public static final float getLineHeight(TextLayoutResult textLayoutResult, int n2) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"");
        if (n2 < 0 || ((CharSequence)textLayoutResult.getLayoutInput().getText()).length() == 0) {
            return 0.0f;
        }
        int n3 = Math.min(textLayoutResult.getMultiParagraph().getLineForOffset(n2), Math.min(textLayoutResult.getMultiParagraph().getMaxLines() - 1, textLayoutResult.getMultiParagraph().getLineCount() - 1));
        int n4 = MultiParagraph.getLineEnd$default((MultiParagraph)textLayoutResult.getMultiParagraph(), (int)n3, (boolean)false, (int)2, null);
        if (n2 > n4) {
            return 0.0f;
        }
        return textLayoutResult.getMultiParagraph().getLineHeight(n3);
    }

    private static final boolean isPositionInsideSelection_uaM50fQ$isOffsetSelectedAndContainsPosition(TextRange textRange, TextLayoutResult textLayoutResult, long l2, int n2) {
        return TextRange.contains-impl((long)textRange.unbox-impl(), (int)n2) && textLayoutResult.getBoundingBox(n2).contains-k-4lQ0M(l2);
    }
}

