/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.text.KeyboardOptions;
import androidx.compose.foundation.text.input.InputTransformation;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000b*\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/text/input/FilterChain;", "Landroidx/compose/foundation/text/input/InputTransformation;", "first", "second", "<init>", "(Landroidx/compose/foundation/text/input/InputTransformation;Landroidx/compose/foundation/text/input/InputTransformation;)V", "keyboardOptions", "Landroidx/compose/foundation/text/KeyboardOptions;", "getKeyboardOptions", "()Landroidx/compose/foundation/text/KeyboardOptions;", "applySemantics", "", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "transformInput", "Landroidx/compose/foundation/text/input/TextFieldBuffer;", "toString", "", "equals", "", "other", "", "hashCode", "", "foundation"})
final class FilterChain
implements InputTransformation {
    private final InputTransformation first;
    private final InputTransformation second;

    public FilterChain(InputTransformation inputTransformation, InputTransformation inputTransformation2) {
        Intrinsics.checkNotNullParameter((Object)inputTransformation, (String)"");
        Intrinsics.checkNotNullParameter((Object)inputTransformation2, (String)"");
        this.first = inputTransformation;
        this.second = inputTransformation2;
    }

    @Override
    public KeyboardOptions getKeyboardOptions() {
        KeyboardOptions keyboardOptions = this.second.getKeyboardOptions();
        if (keyboardOptions == null || (keyboardOptions = keyboardOptions.fillUnspecifiedValuesWith$foundation(this.first.getKeyboardOptions())) == null) {
            keyboardOptions = this.first.getKeyboardOptions();
        }
        return keyboardOptions;
    }

    @Override
    public void applySemantics(SemanticsPropertyReceiver semanticsPropertyReceiver) {
        Intrinsics.checkNotNullParameter((Object)semanticsPropertyReceiver, (String)"");
        InputTransformation inputTransformation = this.first;
        boolean bl = false;
        inputTransformation.applySemantics(semanticsPropertyReceiver);
        inputTransformation = this.second;
        bl = false;
        inputTransformation.applySemantics(semanticsPropertyReceiver);
    }

    @Override
    public void transformInput(TextFieldBuffer textFieldBuffer) {
        Intrinsics.checkNotNullParameter((Object)textFieldBuffer, (String)"");
        InputTransformation inputTransformation = this.first;
        boolean bl = false;
        inputTransformation.transformInput(textFieldBuffer);
        inputTransformation = this.second;
        bl = false;
        inputTransformation.transformInput(textFieldBuffer);
    }

    public String toString() {
        return this.first + ".then(" + this.second + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FilterChain cfr_ignored_0 = (FilterChain)object;
        if (!Intrinsics.areEqual((Object)this.first, (Object)((FilterChain)object).first)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.second, (Object)((FilterChain)object).second)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getKeyboardOptions(), (Object)((FilterChain)object).getKeyboardOptions());
    }

    public int hashCode() {
        int n2 = this.first.hashCode();
        n2 = 31 * n2 + this.second.hashCode();
        KeyboardOptions keyboardOptions = this.getKeyboardOptions();
        n2 = 32 * n2 + (keyboardOptions != null ? ((Object)keyboardOptions).hashCode() : 0);
        return n2;
    }
}

