/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.input.InputTransformation;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0016J\f\u0010\t\u001a\u00020\u0007*\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/foundation/text/input/MaxLengthFilter;", "Landroidx/compose/foundation/text/input/InputTransformation;", "maxLength", "", "<init>", "(I)V", "applySemantics", "", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "transformInput", "Landroidx/compose/foundation/text/input/TextFieldBuffer;", "toString", "", "component1", "copy", "equals", "", "other", "", "hashCode", "foundation"})
final class MaxLengthFilter
implements InputTransformation {
    private final int maxLength;

    public MaxLengthFilter(int n2) {
        this.maxLength = n2;
        boolean bl = this.maxLength >= 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            InlineClassHelperKt.throwIllegalArgumentException("maxLength must be at least zero");
        }
    }

    @Override
    public void applySemantics(SemanticsPropertyReceiver semanticsPropertyReceiver) {
        Intrinsics.checkNotNullParameter((Object)semanticsPropertyReceiver, (String)"");
        SemanticsPropertiesKt.setMaxTextLength((SemanticsPropertyReceiver)semanticsPropertyReceiver, (int)this.maxLength);
    }

    @Override
    public void transformInput(TextFieldBuffer textFieldBuffer) {
        Intrinsics.checkNotNullParameter((Object)textFieldBuffer, (String)"");
        if (textFieldBuffer.getLength() > this.maxLength) {
            textFieldBuffer.revertAllChanges();
        }
    }

    public String toString() {
        return "InputTransformation.maxLength(" + this.maxLength + ")";
    }

    private final int component1() {
        return this.maxLength;
    }

    public final MaxLengthFilter copy(int n2) {
        return new MaxLengthFilter(n2);
    }

    public static /* synthetic */ MaxLengthFilter copy$default(MaxLengthFilter maxLengthFilter, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = maxLengthFilter.maxLength;
        }
        return maxLengthFilter.copy(n2);
    }

    public int hashCode() {
        return Integer.hashCode(this.maxLength);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MaxLengthFilter)) {
            return false;
        }
        MaxLengthFilter maxLengthFilter = (MaxLengthFilter)object;
        return this.maxLength == maxLengthFilter.maxLength;
    }
}

