/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.modifiers.SelectionController_jvmKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIconKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Landroidx/compose/foundation/text/modifiers/SelectionController;", "Landroidx/compose/runtime/RememberObserver;", "selectableId", "", "selectionRegistrar", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "backgroundSelectionColor", "Landroidx/compose/ui/graphics/Color;", "params", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "<init>", "(JLandroidx/compose/foundation/text/selection/SelectionRegistrar;JLandroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "onRemembered", "", "onForgotten", "onAbandoned", "updateTextLayout", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "updateGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "draw", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "foundation"})
public final class SelectionController
implements RememberObserver {
    private final long selectableId;
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    private StaticTextSelectionParams params;
    private Selectable selectable;
    private final Modifier modifier;
    public static final int $stable = 8;

    private SelectionController(long l2, SelectionRegistrar selectionRegistrar, long l3, StaticTextSelectionParams staticTextSelectionParams) {
        Intrinsics.checkNotNullParameter((Object)selectionRegistrar, (String)"");
        Intrinsics.checkNotNullParameter((Object)staticTextSelectionParams, (String)"");
        this.selectableId = l2;
        this.selectionRegistrar = selectionRegistrar;
        this.backgroundSelectionColor = l3;
        this.params = staticTextSelectionParams;
        this.modifier = PointerIconKt.pointerHoverIcon$default((Modifier)SelectionController_jvmKt.makeSelectionModifier(this.selectionRegistrar, this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)() -> SelectionController.modifier$lambda$0(this))), (PointerIcon)PointerIcon.Companion.getText(), (boolean)false, (int)2, null);
    }

    public /* synthetic */ SelectionController(long l2, SelectionRegistrar selectionRegistrar, long l3, StaticTextSelectionParams staticTextSelectionParams, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(l2, selectionRegistrar, l3, staticTextSelectionParams, null);
    }

    public final Modifier getModifier() {
        return this.modifier;
    }

    public void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)() -> SelectionController.onRemembered$lambda$1(this)), (Function0<TextLayoutResult>)((Function0)() -> SelectionController.onRemembered$lambda$2(this))));
    }

    public void onForgotten() {
        Selectable selectable2 = this.selectable;
        if (selectable2 != null) {
            this.selectionRegistrar.unsubscribe(selectable2);
            this.selectable = null;
        }
    }

    public void onAbandoned() {
        Selectable selectable2 = this.selectable;
        if (selectable2 != null) {
            this.selectionRegistrar.unsubscribe(selectable2);
            this.selectable = null;
        }
    }

    public final void updateTextLayout(TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"");
        TextLayoutResult textLayoutResult2 = this.params.getTextLayoutResult();
        if (textLayoutResult2 != null && !Intrinsics.areEqual((Object)textLayoutResult2.getLayoutInput().getText(), (Object)textLayoutResult.getLayoutInput().getText())) {
            this.selectionRegistrar.notifySelectableChange(this.selectableId);
        }
        this.params = StaticTextSelectionParams.copy$default(this.params, null, textLayoutResult, 1, null);
    }

    public final void updateGlobalPosition(LayoutCoordinates layoutCoordinates) {
        Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"");
        this.params = StaticTextSelectionParams.copy$default(this.params, layoutCoordinates, null, 2, null);
        this.selectionRegistrar.notifyPositionChange(this.selectableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(DrawScope drawScope) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
        Selection selection = (Selection)this.selectionRegistrar.getSubselections().a(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int n3 = !selection2.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n4 = n2 = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (n3 == n2) {
            return;
        }
        Selectable selectable2 = this.selectable;
        int n5 = selectable2 != null ? selectable2.getLastVisibleOffset() : 0;
        int n6 = RangesKt.coerceAtMost((int)n3, (int)n5);
        int n7 = RangesKt.coerceAtMost((int)n2, (int)n5);
        Path path = this.params.getPathForRange(n6, n7);
        if (path == null) {
            return;
        }
        Path path2 = path;
        DrawScope drawScope2 = drawScope;
        boolean bl = false;
        if (this.params.getShouldClip()) {
            DrawScope drawScope3 = drawScope2;
            float f2 = 0.0f;
            float f3 = 0.0f;
            long l2 = drawScope3.getSize-NH-jbRc();
            boolean bl2 = false;
            long l3 = l2;
            boolean bl3 = false;
            int n8 = (int)(l3 >> 32);
            boolean bl4 = false;
            float f4 = Float.intBitsToFloat(n8);
            l2 = drawScope3.getSize-NH-jbRc();
            bl2 = false;
            l3 = l2;
            bl3 = false;
            n8 = (int)(l3 & 0xFFFFFFFFL);
            bl4 = false;
            float f5 = Float.intBitsToFloat(n8);
            int n9 = ClipOp.Companion.getIntersect-rtfAjoo();
            boolean bl5 = false;
            DrawScope drawScope4 = drawScope3;
            boolean bl6 = false;
            DrawContext drawContext = drawScope4.getDrawContext();
            bl2 = false;
            l3 = drawContext.getSize-NH-jbRc();
            drawContext.getCanvas().save();
            try {
                DrawTransform drawTransform = drawContext.getTransform();
                n8 = 0;
                drawTransform.clipRect-N_I0leg(f2, f3, f4, f5, n9);
                DrawScope drawScope5 = drawScope4;
                boolean bl7 = false;
                DrawScope.drawPath-LG529CI$default((DrawScope)drawScope5, (Path)path2, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
            }
            finally {
                drawContext.getCanvas().restore();
                drawContext.setSize-uvyYCjk(l3);
            }
        } else {
            DrawScope.drawPath-LG529CI$default((DrawScope)drawScope2, (Path)path2, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
        }
    }

    private static final LayoutCoordinates modifier$lambda$0(SelectionController selectionController) {
        return selectionController.params.getLayoutCoordinates();
    }

    private static final LayoutCoordinates onRemembered$lambda$1(SelectionController selectionController) {
        return selectionController.params.getLayoutCoordinates();
    }

    private static final TextLayoutResult onRemembered$lambda$2(SelectionController selectionController) {
        return selectionController.params.getTextLayoutResult();
    }

    public /* synthetic */ SelectionController(long l2, SelectionRegistrar selectionRegistrar, long l3, StaticTextSelectionParams staticTextSelectionParams, DefaultConstructorMarker defaultConstructorMarker) {
        this(l2, selectionRegistrar, l3, staticTextSelectionParams);
    }
}

