/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;

public class LoggerModelHandler
extends ModelHandlerBase {
    Logger logger;
    boolean inError = false;

    public LoggerModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new LoggerModelHandler(context);
    }

    protected Class<LoggerModel> getSupportedModelClass() {
        return LoggerModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        Object object;
        this.inError = false;
        LoggerModel loggerModel = (LoggerModel)model;
        String string = modelInterpretationContext.subst(loggerModel.getName());
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.logger = loggerContext.getLogger(string);
        String string2 = modelInterpretationContext.subst(loggerModel.getLevel());
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)string2)) {
            if ("INHERITED".equalsIgnoreCase(string2) || "NULL".equalsIgnoreCase(string2)) {
                if ("ROOT".equalsIgnoreCase(string)) {
                    this.addError("The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
                } else {
                    this.addInfo("Setting level of logger [" + string + "] to null, i.e. INHERITED");
                    this.logger.setLevel(null);
                }
            } else {
                object = Level.toLevel(string2);
                this.addInfo("Setting level of logger [" + string + "] to " + String.valueOf(object));
                this.logger.setLevel((Level)object);
            }
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = modelInterpretationContext.subst(loggerModel.getAdditivity())))) {
            boolean bl = OptionHelper.toBoolean((String)object, (boolean)true);
            this.addInfo("Setting additivity of logger [" + string + "] to " + bl);
            this.logger.setAdditive(bl);
        }
        modelInterpretationContext.pushObject((Object)this.logger);
    }

    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        Object object = modelInterpretationContext.peekObject();
        if (object != this.logger) {
            LoggerModel loggerModel = (LoggerModel)model;
            this.addWarn("The object [" + String.valueOf(object) + "] on the top the of the stack is not the expected logger named " + loggerModel.getName());
        } else {
            modelInterpretationContext.popObject();
        }
    }
}

