/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.tyler;

import ch.qos.logback.classic.tyler.TylerConfiguratorBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class VariableModelHelper
extends ContextAwareBase {
    TylerConfiguratorBase tylerConfiguratorBase;
    VariableSubstitutionsHelper variableSubstitutionsHelper;

    VariableModelHelper(Context context, TylerConfiguratorBase tylerConfiguratorBase) {
        super((ContextAware)tylerConfiguratorBase);
        this.context = context;
        this.tylerConfiguratorBase = tylerConfiguratorBase;
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
    }

    void updateProperties(PropertyModel propertyModel) {
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)propertyModel.getScopeStr());
        if (PropertyModelHandlerHelper.checkFileAttributeSanity((PropertyModel)propertyModel)) {
            String string = propertyModel.getFile();
            string = this.tylerConfiguratorBase.subst(string);
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                this.loadAndSetProperties(fileInputStream, scope);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + string + "].");
            }
            catch (IOException | IllegalArgumentException exception) {
                this.addError("Could not read properties file [" + string + "].", exception);
            }
        } else if (PropertyModelHandlerHelper.checkResourceAttributeSanity((PropertyModel)propertyModel)) {
            String string = propertyModel.getResource();
            URL uRL = Loader.getResourceBySelfClassLoader((String)(string = this.tylerConfiguratorBase.subst(string)));
            if (uRL == null) {
                this.addError("Could not find resource [" + string + "].");
            } else {
                try (InputStream inputStream = uRL.openStream();){
                    this.loadAndSetProperties(inputStream, scope);
                }
                catch (IOException iOException) {
                    this.addError("Could not read resource file [" + string + "].", iOException);
                }
            }
        } else if (PropertyModelHandlerHelper.checkValueNameAttributesSanity((PropertyModel)propertyModel)) {
            String string = propertyModel.getValue();
            string = string.trim();
            string = this.tylerConfiguratorBase.subst(string);
            this.setProperty(propertyModel.getName(), string, scope);
        } else {
            this.addError("In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.");
        }
    }

    void loadAndSetProperties(InputStream inputStream, ActionUtil.Scope scope) {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setProperties(properties, scope);
    }

    public void setProperties(Properties properties, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                this.variableSubstitutionsHelper.addSubstitutionProperties(properties);
                break;
            }
            case CONTEXT: {
                ContextUtil contextUtil = new ContextUtil(this.getContext());
                contextUtil.addProperties(properties);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperties((ContextAware)this, (Properties)properties);
            }
        }
    }

    public void setProperty(String string, String string2, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                this.variableSubstitutionsHelper.addSubstitutionProperty(string, string2);
                break;
            }
            case CONTEXT: {
                this.getContext().putProperty(string, string2);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperty((ContextAware)this, (String)string, (String)string2);
            }
        }
    }
}

