/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.FileUtil;
import dorkbox.util.LocationResolver;
import dorkbox.util.Sys;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldorkbox/util/CacheUtil;", "", "tempDir", "", "(Ljava/lang/String;)V", "check", "Ljava/io/File;", "file", "fileStream", "Ljava/io/InputStream;", "fileResource", "Ljava/net/URL;", "fileName", "cacheName", "clear", "", "create", "makeCacheFile", "makeFileViaStream", "resourceStream", "save", "Companion", "Utilities"})
public final class CacheUtil {
    public static final Companion Companion = new Companion(null);
    private final String tempDir;
    private static final String version = Sys.INSTANCE.getVersion();
    private static final ThreadLocal<MessageDigest> digestLocal = ThreadLocal.withInitial(CacheUtil::digestLocal$lambda$1);

    public CacheUtil(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.tempDir = string;
    }

    public /* synthetic */ CacheUtil(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "cache";
        }
        this(string);
    }

    public final void clear() {
        FileUtil.INSTANCE.delete(new File(OS.INSTANCE.getTEMP_DIR(), this.tempDir), new String[0]);
    }

    public final File check(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return this.check(file.getAbsolutePath());
    }

    public final File check(String string) {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        File file = this.makeCacheFile(string);
        return file.canRead() && file.isFile() ? file : null;
    }

    public final File check(URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        return this.check(uRL.getPath());
    }

    public final File check(InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        return this.check(null, inputStream);
    }

    public final File check(String string, InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        File file = string == null ? this.makeCacheFile(Companion.createNameAsHash(inputStream)) : this.makeCacheFile(string);
        return file.canRead() && file.isFile() ? file : null;
    }

    public final File save(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return this.save(file.getAbsolutePath(), file);
    }

    public final File save(String string, File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        if (string == null) {
            String string2 = file.getAbsolutePath();
            String string3 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            file2 = this.save(string2, string3);
        } else {
            String string4 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            file2 = this.save(string, string4);
        }
        return file2;
    }

    public final File save(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.save(null, string);
    }

    public final File save(String string, String string2) {
        File file;
        String string3;
        File file2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        String string4 = string;
        if (string4 == null) {
            string4 = string2;
        }
        if ((file2 = this.makeCacheFile(string3 = string4)).canRead() && file2.isFile()) {
            return file2;
        }
        File file3 = new File(string2);
        if (file3.isFile()) {
            if (!file3.canRead()) {
                throw new IOException("File exists but unable to read source file " + string2);
            }
            FileUtil.INSTANCE.copyFile(file3, file2);
            file = file2;
        } else {
            URL uRL = LocationResolver.Companion.getResource(string2);
            if (uRL == null) {
                throw new IOException("Unable to load URL resource " + string2);
            }
            URL uRL2 = uRL;
            InputStream inputStream = uRL2.openStream();
            Intrinsics.checkNotNull((Object)inputStream);
            file = this.makeFileViaStream(string3, inputStream);
        }
        return file;
    }

    public final File save(URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        return this.save(null, uRL);
    }

    public final File save(String string, URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        String string2 = string;
        if (string2 == null) {
            string2 = uRL.getPath();
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        File file = this.makeCacheFile(string3);
        if (file.canRead() && file.isFile()) {
            return file;
        }
        InputStream inputStream = uRL.openStream();
        Intrinsics.checkNotNull((Object)inputStream);
        return this.makeFileViaStream(string3, inputStream);
    }

    public final File save(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("fileStream");
        }
        return this.save(null, inputStream);
    }

    public final File save(String string, InputStream inputStream) {
        String string2;
        File file;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        String string3 = string;
        if (string3 == null) {
            string3 = Companion.createNameAsHash(inputStream);
        }
        return (file = this.makeCacheFile(string2 = string3)).canRead() && file.isFile() ? file : this.makeFileViaStream(string2, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final File makeFileViaStream(String string, InputStream inputStream) {
        File file = this.makeCacheFile(string);
        if (file.canRead() && file.isFile()) {
            File file2 = file.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"");
            return file2;
        }
        OutputStream outputStream = null;
        try {
            int n = 0;
            byte[] byArray = new byte[2048];
            outputStream = new FileOutputStream(file);
            while (true) {
                int n2;
                int n3 = n2 = inputStream.read(byArray);
                boolean bl = false;
                n = n3;
                if (n2 > 0) {
                    ((FileOutputStream)outputStream).write(byArray, 0, n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            try {
                String string2 = "Unable to copy '" + string + "' to temporary location: '" + file.getAbsolutePath() + '\'';
                throw new IOException(string2, iOException);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    OutputStream outputStream3;
                    OutputStream outputStream2 = outputStream3 = outputStream;
                    if (outputStream2 == null) throw throwable;
                    outputStream2.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            OutputStream outputStream2 = outputStream;
            outputStream2.close();
        }
        catch (Exception exception) {}
        File file3 = file.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"");
        return file3;
    }

    public final File create(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.makeCacheFile(string);
    }

    private final File makeCacheFile(String string) {
        File file = new File(OS.INSTANCE.getTEMP_DIR(), this.tempDir);
        String string2 = CacheUtil.Companion.hashName(string);
        String string3 = Sys.INSTANCE.getExtension(string);
        if (((CharSequence)string3).length() == 0) {
            string3 = "cache";
        }
        File file2 = new File(file, string2 + '.' + string3).getAbsoluteFile();
        file2.getParentFile().mkdirs();
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    private static final MessageDigest digestLocal$lambda$1() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Unable to initialize hash algorithm. SHA1 digest doesn't exist?!? (This should not happen");
        }
    }

    public CacheUtil() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ldorkbox/util/CacheUtil$Companion;", "", "()V", "digestLocal", "Ljava/lang/ThreadLocal;", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "version", "", "getVersion", "()Ljava/lang/String;", "clear", "", "tempDir", "createNameAsHash", "resourceStream", "Ljava/io/InputStream;", "hashName", "name", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        public final String getVersion() {
            return version;
        }

        public final void clear(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            new CacheUtil(string).clear();
        }

        private final String hashName(String string) {
            Object object = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"");
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
            byte[] byArray2 = byArray;
            object = (MessageDigest)digestLocal.get();
            ((MessageDigest)object).reset();
            ((MessageDigest)object).update(byArray2);
            String string2 = new BigInteger(1, ((MessageDigest)object).digest()).toString(32);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            return string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String createNameAsHash(InputStream inputStream) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
            MessageDigest messageDigest = (MessageDigest)digestLocal.get();
            messageDigest.reset();
            try {
                object = new ByteArrayOutputStream(4096);
                int n = 0;
                byte[] byArray = new byte[2048];
                while (true) {
                    int n2;
                    int n3 = n2 = inputStream.read(byArray);
                    boolean bl = false;
                    n = n3;
                    if (n2 <= 0) break;
                    messageDigest.update(byArray, 0, n);
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string = new BigInteger(1, messageDigest.digest()).toString(32);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                object = stringBuilder.append(string2).append(".cache").toString();
            }
            catch (IOException iOException) {
                String string = "Unable to copy InputStream to memory.";
                throw new IOException(string, iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

