/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.LocationResolver;
import dorkbox.util.Sys;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Object mediaTrackerLock = new Object();
    private static final AtomicInteger imageTrackerIndex = new AtomicInteger(0);
    private static MediaTracker tracker = null;

    public static BufferedImage clampMaxImageSize(BufferedImage bufferedImage, int n) {
        int n2;
        double d;
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        if (n3 <= n && n4 <= n) {
            return bufferedImage;
        }
        if (n3 > n) {
            d = (double)n / (double)n3;
            n3 = n;
            n4 = (int)((double)n4 * d);
        }
        if (n4 > n) {
            d = (double)n / (double)n4;
            n4 = n;
            n3 = (int)((double)n3 * d);
        }
        if ((n2 = bufferedImage.getType()) == 0) {
            n2 = 2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        graphics2D.drawImage(bufferedImage, 0, 0, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage resizeImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        double d = (double)n4 / (double)n3;
        if (n == -1 && n2 == -1) {
            n = n4;
            n2 = n3;
        } else if (n == -1) {
            n = (int)((double)n2 * d);
        } else if (n2 == -1) {
            n2 = (int)((double)n / d);
        }
        int n5 = bufferedImage.getType();
        if (n5 == 0) {
            n5 = 2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static String resizeFileOrResource(int n, String string) {
        Image image;
        Object object;
        FileInputStream fileInputStream = new FileInputStream(string);
        Dimension dimension = ImageUtil.getImageSize(fileInputStream);
        if (n == (int)dimension.getWidth() && n == (int)dimension.getHeight()) {
            return string;
        }
        String string2 = Sys.INSTANCE.getExtension(string);
        if (string2.isEmpty()) {
            string2 = "png";
        }
        File file = new File(OS.INSTANCE.getTEMP_DIR(), "temp_resize." + string2).getAbsoluteFile();
        File file2 = new File(string);
        if (file2.isFile() && file2.canRead()) {
            object = file2.getAbsolutePath();
            image = new ImageIcon((String)object).getImage();
        } else {
            object = LocationResolver.Companion.getResource(string);
            image = new ImageIcon((URL)object).getImage();
        }
        ImageUtil.waitForImageLoad(image);
        boolean bl = file.getParentFile().mkdirs();
        if (!bl) {
            throw new IOException("Unable to create directories for " + file.getParentFile());
        }
        boolean bl2 = file.delete();
        if (!bl2) {
            throw new IOException("Temporary file already in use, cannot delete it " + file);
        }
        BufferedImage bufferedImage = ImageUtil.getSquareBufferedImage(image);
        ImageIO.write((RenderedImage)bufferedImage, string2, file);
        return file.getAbsolutePath();
    }

    public static File createImage(int n, File file, Color color) {
        if (file.canRead() && file.isFile()) {
            return file.getAbsoluteFile();
        }
        file.getParentFile().mkdirs();
        BufferedImage bufferedImage = ImageUtil.createImageAsBufferedImage(n, color);
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
        return file.getAbsoluteFile();
    }

    public static BufferedImage createImageAsBufferedImage(int n, Color color) {
        return ImageUtil.createImageAsBufferedImage(n, n, color);
    }

    public static BufferedImage createImageAsBufferedImage(int n, int n2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color == null) {
            graphics2D.setColor(new Color(0, 0, 0, 0));
        } else {
            graphics2D.setColor(color);
        }
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getSquareBufferedImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        if (n < n2) {
            n5 = n2;
            n3 = (n2 - n) / 2;
        } else {
            n4 = (n - n2) / 2;
        }
        BufferedImage bufferedImage = new BufferedImage(n5, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        graphics2D.drawImage(image, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(Icon icon) {
        if (icon instanceof BufferedImage) {
            return (BufferedImage)((Object)icon);
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static byte[] toBytes(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream inputStream) {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (iterator.hasNext()) {
                imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                Dimension dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
                return dimension;
            }
        }
        finally {
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (imageReader != null) {
                imageReader.dispose();
            }
        }
        throw new IOException("Unable to read file inputStream for image size data.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForImageLoad(Image image) {
        int n = imageTrackerIndex.getAndIncrement();
        Object object = mediaTrackerLock;
        synchronized (object) {
            if (tracker == null) {
                tracker = new MediaTracker(new Component(){});
            }
            tracker.addImage(image, n);
        }
        try {
            tracker.waitForID(n);
            if (tracker.isErrorID(n)) {
                LoggerFactory.getLogger(ImageUtil.class).error("Error loading image!");
            }
        }
        catch (InterruptedException interruptedException) {
            Object object2 = mediaTrackerLock;
            synchronized (object2) {
                tracker.removeImage(image);
            }
        }
        finally {
            object = mediaTrackerLock;
            synchronized (object) {
                tracker.removeImage(image);
            }
        }
    }
}

