/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.Sys;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\f"}, d2={"Ldorkbox/util/LocationResolver;", "", "()V", "getDirectoryContents", "", "", "clazz", "Ljava/lang/Class;", "path", "(Ljava/lang/Class;Ljava/lang/String;)[Ljava/lang/String;", "Companion", "Root", "Utilities"})
public final class LocationResolver {
    public static final Companion Companion = new Companion(null);
    private static final String version = Sys.INSTANCE.getVersion();
    private static final Pattern SLASH_PATTERN = Pattern.compile("\\\\");

    public final String[] getDirectoryContents(Class<?> clazz, String string) {
        String string2;
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        URL uRL = clazz.getClassLoader().getResource(string);
        if (uRL != null && Intrinsics.areEqual((Object)uRL.getProtocol(), (Object)"file")) {
            String[] stringArray = new File(uRL.toURI()).list();
            Intrinsics.checkNotNull((Object)stringArray);
            return stringArray;
        }
        if (uRL == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            string2 = stringBuilder.append(StringsKt.replace$default((String)string3, (String)".", (String)"/", (boolean)false, (int)4, null)).append(".class").toString();
            uRL = clazz.getClassLoader().getResource(string2);
        }
        URL uRL2 = uRL;
        Intrinsics.checkNotNull((Object)uRL2);
        if (Intrinsics.areEqual((Object)uRL2.getProtocol(), (Object)"jar")) {
            Object object;
            String string4 = uRL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            Object object2 = string4;
            int n = 5;
            String string5 = uRL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
            int n2 = StringsKt.indexOf$default((CharSequence)string5, (String)"!", (int)0, (boolean)false, (int)6, null);
            String string6 = ((String)object2).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
            string2 = string6;
            object2 = new JarFile(URLDecoder.decode(string2, "UTF-8"));
            Enumeration<JarEntry> enumeration = ((JarFile)object2).entries();
            Set set2 = new HashSet();
            while (enumeration.hasMoreElements()) {
                String string7;
                object = enumeration.nextElement().getName();
                Intrinsics.checkNotNull((Object)object);
                if (!StringsKt.startsWith$default((String)object, (String)string, (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((String)object).substring(string.length()), (String)"");
                int n3 = StringsKt.indexOf$default((CharSequence)string7, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (n3 >= 0) {
                    String string8 = string7.substring(0, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"");
                    string7 = string8;
                }
                set2.add(string7);
            }
            object = set2;
            boolean bl = false;
            Object object3 = object;
            return object3.toArray(new String[0]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + uRL);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\b\u0002\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0087\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0007J&\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002J \u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0002J\u001e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Ldorkbox/util/LocationResolver$Companion;", "", "()V", "SLASH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "version", "", "getVersion", "()Ljava/lang/String;", "get", "Ljava/io/File;", "clazz", "Ljava/lang/Class;", "getResource", "Ljava/net/URL;", "resourceName", "getResourceAsStream", "Ljava/io/InputStream;", "getResources", "Ljava/util/Enumeration;", "log", "", "message", "normalizePath", "path", "prefix", "searchResource", "visitDir", "root", "dir", "out", "", "visitRoot", "url", "resources", "", "visitZip", "jar", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        public final String getVersion() {
            return version;
        }

        private final void log(String string) {
            System.err.println(this.prefix() + string);
        }

        private final String normalizePath(String string) {
            String string2 = SLASH_PATTERN.matcher(string).replaceAll("/");
            String string3 = URLDecoder.decode(string2, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            return string3;
        }

        public final File get(Class<?> clazz) {
            File file;
            Intrinsics.checkNotNullParameter(clazz, (String)"");
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL uRL = codeSource.getLocation();
            if (uRL == null) {
                return null;
            }
            URL uRL2 = uRL;
            try {
                String string = uRL2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                file = new File(this.normalizePath(string)).getAbsoluteFile().getCanonicalFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Unable to decode file path!", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to get canonical file path!", iOException);
            }
            return file;
        }

        public static /* synthetic */ File get$default(Companion companion, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = LocationResolver.class;
            }
            return companion.get(clazz);
        }

        public final URL getResource(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = string;
            try {
                string2 = this.normalizePath(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            URL uRL = null;
            File file = new File(string2);
            if (file.canRead()) {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            if (uRL == null) {
                uRL = Thread.currentThread().getContextClassLoader().getResource(string2);
            }
            if (uRL == null) {
                uRL = ClassLoader.getSystemResource(string2);
            }
            if (uRL == null) {
                try {
                    this.searchResource(string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return uRL;
        }

        public final Enumeration<URL> getResources(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = string;
            try {
                string2 = this.normalizePath(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Enumeration<URL> enumeration = null;
            try {
                File file = new File(string2);
                if (file.canRead()) {
                    File[] fileArray;
                    ArrayDeque<URL> arrayDeque = new ArrayDeque<URL>(4);
                    arrayDeque.add(file.toURI().toURL());
                    if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                        int n = fileArray.length;
                        for (int j = 0; j < n; ++j) {
                            arrayDeque.add(fileArray[j].toURI().toURL());
                        }
                    }
                    enumeration = new Vector(arrayDeque).elements();
                }
                if (enumeration == null) {
                    enumeration = Thread.currentThread().getContextClassLoader().getResources(string2);
                }
                if (enumeration == null) {
                    enumeration = ClassLoader.getSystemResources(string2);
                }
                if (enumeration == null) {
                    this.searchResource(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return enumeration;
        }

        public final InputStream getResourceAsStream(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = string;
            try {
                string2 = this.normalizePath(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            InputStream inputStream = null;
            if (new File(string2).canRead()) {
                try {
                    inputStream = new FileInputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
            }
            if (inputStream == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(string2);
            }
            if (inputStream == null) {
                try {
                    this.searchResource(string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return inputStream;
        }

        public final void searchResource(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = string;
            try {
                string2 = this.normalizePath(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            List list = new ArrayList();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                Intrinsics.checkNotNull((Object)uRLArray);
                for (URL uRL : uRLArray) {
                    Intrinsics.checkNotNull((Object)uRL);
                    list.add(new Root(uRL));
                }
                System.err.println();
                this.log("SEARCHING: \"" + string2 + '\"');
                for (int j = 1; j < 7; ++j) {
                    for (Root root : list) {
                        if (!root.search(string2, j)) continue;
                        return;
                    }
                }
                this.log("FAILED: failed to find anything like");
                this.log("               \"" + string2 + '\"');
                this.log("         in all classpath entries:");
                for (Root root : list) {
                    File file = root.getEntry();
                    if (file == null) continue;
                    this.log("               \"" + file.getAbsolutePath() + '\"');
                }
            } else {
                throw new IOException("Unable to search for '" + string2 + "' in the context classloader of type '" + classLoader.getClass() + "'.  Please report this issue with as many specific details as possible (OS, Java version, application version");
            }
        }

        private final File visitRoot(URL uRL, List<String> list) {
            Object object;
            if (!Intrinsics.areEqual((Object)uRL.getProtocol(), (Object)"file")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            String string = uRL.getPath();
            if (OS.INSTANCE.isWindows()) {
                object = string;
                Intrinsics.checkNotNull((Object)object);
                if (StringsKt.startsWith$default((String)object, (String)"/", (boolean)false, (int)2, null)) {
                    object = string;
                    Intrinsics.checkNotNull((Object)object);
                    int n = 1;
                    String string2 = ((String)object).substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                    string = string2;
                }
            }
            if (!((File)(object = new File(string))).exists()) {
                this.log("failed to find classpath entry in filesystem: " + string);
                return null;
            }
            if (((File)object).isDirectory()) {
                String string3 = ((File)object).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                this.visitDir(this.normalizePath(string3), (File)object, (Collection<String>)list);
            } else {
                String string4 = ((File)object).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                String string5 = string4;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                String string6 = string5.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                String string7 = string6;
                if (StringsKt.endsWith$default((String)string7, (String)".zip", (boolean)false, (int)2, null)) {
                    this.visitZip((File)object, (Collection<String>)list);
                } else if (StringsKt.endsWith$default((String)string7, (String)".jar", (boolean)false, (int)2, null)) {
                    this.visitZip((File)object, (Collection<String>)list);
                } else {
                    this.log("unknown classpath entry type: " + string);
                    return null;
                }
            }
            return object;
        }

        private final void visitDir(String string, File file, Collection<String> collection) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (file2.isDirectory()) {
                        Intrinsics.checkNotNull((Object)file2);
                        this.visitDir(string, file2, collection);
                    }
                    String string2 = file2.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                    String string3 = StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                    int n = string.length() + 1;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                    collection.add(string4);
                }
            }
        }

        private final void visitZip(File file, Collection<String> collection) {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while (zipInputStream.getNextEntry() != null) {
                ZipEntry zipEntry;
                String string = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                collection.add(StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null));
            }
            zipInputStream.close();
        }

        private final String prefix() {
            return '[' + LocationResolver.class.getSimpleName() + "] ";
        }

        public final File get() {
            return dorkbox.util.LocationResolver$Companion.get$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Ldorkbox/util/LocationResolver$Root;", "", "entry", "Ljava/net/URL;", "(Ljava/net/URL;)V", "Ljava/io/File;", "getEntry", "()Ljava/io/File;", "resources", "", "", "getResources", "()Ljava/util/List;", "search", "", "path", "attempt", "", "Utilities"})
    private static final class Root {
        private final File entry;
        private final List<String> resources;

        public Root(URL uRL) {
            Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
            this.resources = new ArrayList();
            this.entry = Companion.visitRoot(uRL, this.resources);
        }

        public final File getEntry() {
            return this.entry;
        }

        public final List<String> getResources() {
            return this.resources;
        }

        public final boolean search(String string, int n) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = string;
            try {
                string2 = Companion.normalizePath(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            switch (n) {
                case 1: {
                    for (String string3 : this.resources) {
                        if (!Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
                        Companion.log("SUCCESS: found resource \"" + string2 + "\" in root: " + this.entry);
                        return true;
                    }
                    break;
                }
                case 2: {
                    for (String string4 : this.resources) {
                        String string5 = string2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        String string6 = string5.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                        string5 = string4;
                        Locale locale2 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
                        String string7 = string5.toLowerCase(locale2);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
                        if (!Intrinsics.areEqual((Object)string6, (Object)string7)) continue;
                        Companion.log("FOUND: similarly named resource:");
                        Companion.log("               \"" + string4 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string4 + "\");");
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (String string8 : this.resources) {
                        String string9 = string2;
                        String string10 = string8;
                        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string11 = string9.substring(StringsKt.lastIndexOf$default((CharSequence)string9, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"");
                            string9 = string11;
                        }
                        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string12 = string10.substring(StringsKt.lastIndexOf$default((CharSequence)string10, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"");
                            string10 = string12;
                        }
                        if (!Intrinsics.areEqual((Object)string9, (Object)string10)) continue;
                        Companion.log("FOUND: mislocated resource:");
                        Companion.log("               \"" + string8 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string8 + "\");");
                        return true;
                    }
                    break;
                }
                case 4: {
                    for (String string13 : this.resources) {
                        String string14;
                        String string15 = string2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        Intrinsics.checkNotNullExpressionValue((Object)string15.toLowerCase(locale), (String)"");
                        String string16 = string13;
                        Locale locale3 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"");
                        String string17 = string16.toLowerCase(locale3);
                        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"");
                        string15 = string17;
                        if (StringsKt.contains$default((CharSequence)string14, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string18 = string14.substring(StringsKt.lastIndexOf$default((CharSequence)string14, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"");
                            string14 = string18;
                        }
                        if (StringsKt.contains$default((CharSequence)string15, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string19 = string15.substring(StringsKt.lastIndexOf$default((CharSequence)string15, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"");
                            string15 = string19;
                        }
                        if (!Intrinsics.areEqual((Object)string14, (Object)string15)) continue;
                        Companion.log("FOUND: mislocated, similarly named resource:");
                        Companion.log("               \"" + string13 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string13 + "\");");
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (String string20 : this.resources) {
                        String string21 = string2;
                        String string22 = string20;
                        if (StringsKt.contains$default((CharSequence)string21, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string23 = string21.substring(StringsKt.lastIndexOf$default((CharSequence)string21, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"");
                            string21 = string23;
                        }
                        if (StringsKt.contains$default((CharSequence)string22, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string24 = string22.substring(StringsKt.lastIndexOf$default((CharSequence)string22, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"");
                            string22 = string24;
                        }
                        if (StringsKt.contains$default((CharSequence)string21, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string25 = string21.substring(0, StringsKt.lastIndexOf$default((CharSequence)string21, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"");
                            string21 = string25;
                        }
                        if (StringsKt.contains$default((CharSequence)string22, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string26 = string22.substring(0, StringsKt.lastIndexOf$default((CharSequence)string22, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"");
                            string22 = string26;
                        }
                        if (!Intrinsics.areEqual((Object)string21, (Object)string22)) continue;
                        Companion.log("FOUND: resource with different extension:");
                        Companion.log("               \"" + string20 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string20 + "\");");
                        return true;
                    }
                    break;
                }
                case 6: {
                    for (String string27 : this.resources) {
                        String string28;
                        String string29 = string2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        Intrinsics.checkNotNullExpressionValue((Object)string29.toLowerCase(locale), (String)"");
                        String string30 = string27;
                        Locale locale4 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"");
                        String string31 = string30.toLowerCase(locale4);
                        Intrinsics.checkNotNullExpressionValue((Object)string31, (String)"");
                        string29 = string31;
                        if (StringsKt.contains$default((CharSequence)string28, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string32 = string28.substring(StringsKt.lastIndexOf$default((CharSequence)string28, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string32, (String)"");
                            string28 = string32;
                        }
                        if (StringsKt.contains$default((CharSequence)string29, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string33 = string29.substring(StringsKt.lastIndexOf$default((CharSequence)string29, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string33, (String)"");
                            string29 = string33;
                        }
                        if (StringsKt.contains$default((CharSequence)string28, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string34 = string28.substring(0, StringsKt.lastIndexOf$default((CharSequence)string28, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string34, (String)"");
                            string28 = string34;
                        }
                        if (StringsKt.contains$default((CharSequence)string29, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string35 = string29.substring(0, StringsKt.lastIndexOf$default((CharSequence)string29, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string35, (String)"");
                            string29 = string35;
                        }
                        if (!Intrinsics.areEqual((Object)string28, (Object)string29)) continue;
                        Companion.log("FOUND: similarly named resource with different extension:");
                        Companion.log("               \"" + string27 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string27 + "\");");
                        return true;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return false;
        }
    }
}

