/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.gwt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class GwtSymbolMapParser {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Map<String, String> symbolMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, UTF_8);
        StringBuilder stringBuilder = new StringBuilder(1024);
        int n = 13;
        char c = (char)n;
        try {
            while ((n = inputStreamReader.read()) != -1) {
                c = (char)n;
                if (c != '\r' && c != '\n') {
                    stringBuilder.append(c);
                    continue;
                }
                this.processLine(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.capacity());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Map<String, String> getSymbolMap() {
        return this.symbolMap;
    }

    public void processLine(String string) {
        if (string.charAt(0) == '#') {
            return;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            if (string4.isEmpty() && !string2.equals(string3)) {
                this.symbolMap.put(string2, string3);
            }
        } else {
            this.symbolMap.put(stringArray[0], stringArray[1]);
        }
    }
}

