/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnKt;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0004B(\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u00104\u001a\u0002052\n\u00106\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u000e\u00108\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fJ\u0010\u00109\u001a\u00020\b2\b\b\u0002\u0010:\u001a\u00020%J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0013\u0010<\u001a\u00020%2\b\u00106\u001a\u0004\u0018\u00010=H\u0096\u0002J\b\u0010>\u001a\u000205H\u0016J\u0006\u0010$\u001a\u00020%J\r\u0010?\u001a\u00020%H\u0000\u00a2\u0006\u0002\b@J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020\bJ\u0006\u0010F\u001a\u00020\bJ\u0018\u0010/\u001a\n\u0012\u0004\u0012\u0002HG\u0018\u00010\u0000\"\b\b\u0001\u0010G*\u00028\u0000J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020\bH\u0016J\u001f\u0010M\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\n\u00f8\u0001\u0000R\u001f\u0010\t\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\nX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010'R\u0014\u0010+\u001a\u00020%8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010'R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006N"}, d2={"Lorg/jetbrains/exposed/sql/Column;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "name", "", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;)V", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "dbDefaultValue", "Lorg/jetbrains/exposed/sql/Expression;", "getDbDefaultValue$exposed_core", "()Lorg/jetbrains/exposed/sql/Expression;", "setDbDefaultValue$exposed_core", "(Lorg/jetbrains/exposed/sql/Expression;)V", "ddl", "", "getDdl", "()Ljava/util/List;", "defaultValueFun", "Lkotlin/Function0;", "getDefaultValueFun", "()Lkotlin/jvm/functions/Function0;", "setDefaultValueFun", "(Lkotlin/jvm/functions/Function0;)V", "foreignKey", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "getForeignKey", "()Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "setForeignKey", "(Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;)V", "isDatabaseGenerated", "", "isDatabaseGenerated$exposed_core", "()Z", "setDatabaseGenerated$exposed_core", "(Z)V", "isLastColumnInPK", "isPrimaryConstraintWillBeDefined", "isPrimaryConstraintWillBeDefined$exposed_core", "getName", "()Ljava/lang/String;", "referee", "getReferee", "()Lorg/jetbrains/exposed/sql/Column;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "compareTo", "", "other", "createStatement", "defaultValueInDb", "descriptionDdl", "modify", "dropStatement", "equals", "", "hashCode", "isOneColumnPK", "isOneColumnPK$exposed_core", "modifyStatement", "modifyStatements", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "nameInDatabaseCase", "nameUnquoted", "S", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "toString", "withColumnType", "exposed-core"})
public final class Column<T>
extends ExpressionWithColumnType<T>
implements Comparable<Column<?>>,
DdlAware {
    private final Table table;
    private final String name;
    private final IColumnType<T> columnType;
    private ForeignKeyConstraint foreignKey;
    private Function0<? extends T> defaultValueFun;
    private Expression<T> dbDefaultValue;
    private boolean isDatabaseGenerated;

    public Column(Table table, String string, IColumnType<T> iColumnType) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        this.table = table;
        this.name = string;
        this.columnType = iColumnType;
    }

    public final Table getTable() {
        return this.table;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public IColumnType<T> getColumnType() {
        return this.columnType;
    }

    public final ForeignKeyConstraint getForeignKey() {
        return this.foreignKey;
    }

    public final void setForeignKey(ForeignKeyConstraint foreignKeyConstraint) {
        this.foreignKey = foreignKeyConstraint;
    }

    public final Column<?> getReferee() {
        ForeignKeyConstraint foreignKeyConstraint = this.foreignKey;
        return foreignKeyConstraint != null ? foreignKeyConstraint.targetOf(this) : null;
    }

    public final <S extends T> Column<S> referee() {
        Column<?> column = this.getReferee();
        return column instanceof Column ? column : null;
    }

    public final Function0<T> getDefaultValueFun() {
        return this.defaultValueFun;
    }

    public final void setDefaultValueFun(Function0<? extends T> function0) {
        this.defaultValueFun = function0;
    }

    public final Expression<T> getDbDefaultValue$exposed_core() {
        return this.dbDefaultValue;
    }

    public final void setDbDefaultValue$exposed_core(Expression<T> expression) {
        this.dbDefaultValue = expression;
    }

    public final Expression<T> defaultValueInDb() {
        return this.dbDefaultValue;
    }

    public final boolean isDatabaseGenerated$exposed_core() {
        return this.isDatabaseGenerated;
    }

    public final void setDatabaseGenerated$exposed_core(boolean bl) {
        this.isDatabaseGenerated = bl;
    }

    public final boolean isDatabaseGenerated() {
        return this.isDatabaseGenerated;
    }

    @Override
    public void toQueryBuilder(QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        TransactionManager.Companion.current().fullIdentity$exposed_core(this, queryBuilder);
    }

    public final List<String> getDdl() {
        return this.createStatement();
    }

    public final String nameInDatabaseCase() {
        return DatabaseDialectKt.inProperCase(this.name);
    }

    public final String nameUnquoted() {
        String string;
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            string = this.name;
        } else {
            char[] cArray = new char[]{'\"'};
            string = StringsKt.trim((String)this.name, (char[])cArray);
        }
        return string;
    }

    private final boolean isLastColumnInPK() {
        Object[] objectArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual((Object)this, objectArray != null && (objectArray = objectArray.getColumns()) != null ? (Column)ArraysKt.last((Object[])objectArray) : null);
    }

    public final boolean isPrimaryConstraintWillBeDefined$exposed_core() {
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType()) ? false : (this.table.isCustomPKNameDefined$exposed_core() ? this.isLastColumnInPK() : (this.isOneColumnPK$exposed_core() ? false : this.isLastColumnInPK()));
    }

    @Override
    public List<String> createStatement() {
        String string = "ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + " ADD";
        boolean bl = DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect && this.isLastColumnInPK();
        String string2 = this.isPrimaryConstraintWillBeDefined$exposed_core() && this.isLastColumnInPK() && !bl ? this.descriptionDdl(false) + ", ADD " + this.table.primaryKeyConstraint$exposed_core() : (bl ? this.descriptionDdl(true) : this.descriptionDdl(false));
        String string3 = bl ? string + ' ' + this.table.primaryKeyConstraint$exposed_core() : null;
        Object[] objectArray = new String[]{string + ' ' + string2, string3};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public final List<String> modifyStatements(ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"");
        return DatabaseDialectKt.getCurrentDialect().modifyColumn(this, columnDiff);
    }

    @Override
    public List<String> modifyStatement() {
        return DatabaseDialectKt.getCurrentDialect().modifyColumn(this, ColumnDiff.Companion.getAllChanged());
    }

    @Override
    public List<String> dropStatement() {
        Transaction transaction2 = TransactionManager.Companion.current();
        return CollectionsKt.listOf((Object)("ALTER TABLE " + transaction2.identity(this.table) + " DROP COLUMN " + transaction2.identity(this)));
    }

    public final boolean isOneColumnPK$exposed_core() {
        Object[] objectArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual((Object)this, objectArray != null && (objectArray = objectArray.getColumns()) != null ? (Column)ArraysKt.singleOrNull((Object[])objectArray) : null);
    }

    public final String descriptionDdl(boolean bl) {
        String string;
        Object object;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        Transaction transaction2 = TransactionManager.Companion.current();
        Column column = this;
        stringBuilder2.append(transaction2.identity(column));
        stringBuilder2.append(" ");
        Object[] objectArray = this.table.getPrimaryKey();
        boolean bl3 = objectArray != null && (objectArray = objectArray.getColumns()) != null ? ArraysKt.contains((Object[])objectArray, (Object)column) : false;
        boolean bl4 = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType());
        if (!bl3 && bl4) {
            ExceptionsKt.throwUnsupportedException(transaction2, "Auto-increment could be applied only to primary key column");
            throw new KotlinNothingValueException();
        }
        if (bl4 && !this.isOneColumnPK$exposed_core()) {
            ExceptionsKt.throwUnsupportedException(transaction2, "Auto-increment could be applied only to a single column primary key");
            throw new KotlinNothingValueException();
        }
        if (bl4 && this.table.isCustomPKNameDefined$exposed_core()) {
            object = StringsKt.substringBefore$default((String)this.getColumnType().sqlType(), (String)"PRIMARY KEY", null, (int)2, null);
            String string2 = this.table.primaryKeyConstraint$exposed_core();
            Intrinsics.checkNotNull((Object)string2);
            string = StringsKt.substringBefore$default((String)string2, (String)"(", null, (int)2, null);
            stringBuilder2.append((String)object + ' ' + string + " AUTOINCREMENT");
        } else {
            stringBuilder2.append(this.getColumnType().sqlType());
        }
        object = this.dbDefaultValue;
        if (object != null) {
            string = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().processForDefaultValue((Expression<?>)object);
            if (!DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault((Expression<?>)object)) {
                String string3 = this.defaultValueFun != null ? " Expression will be evaluated on the client." : (!this.getColumnType().getNullable() ? " Column will be created with NULL marker." : "");
                SQLLogKt.getExposedLogger().error(DatabaseDialectKt.getCurrentDialect().getName() + ' ' + transaction2.getDb().getVersion() + " doesn't support expression '" + string + "' as default value." + string3);
            } else if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
                String string4 = column.table.getTableNameWithoutScheme$exposed_core();
                String string5 = column.name;
                String string6 = "DF_" + string4 + '_' + string5;
                stringBuilder2.append(" CONSTRAINT " + string6 + " DEFAULT " + string);
            } else {
                stringBuilder2.append(" DEFAULT " + string);
            }
        }
        if (this.getColumnType().getNullable() || object != null && this.defaultValueFun == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault((Expression<?>)object)) {
            stringBuilder2.append(" NULL");
        } else if (!bl3 || DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && !bl4) {
            stringBuilder2.append(" NOT NULL");
        }
        if (!bl && this.isOneColumnPK$exposed_core() && !this.isPrimaryConstraintWillBeDefined$exposed_core() && !bl4) {
            stringBuilder2.append(" PRIMARY KEY");
        }
        String string7 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
        return string7;
    }

    public static /* synthetic */ String descriptionDdl$default(Column column, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return column.descriptionDdl(bl);
    }

    public final Column<T> withColumnType(IColumnType<T> iColumnType) {
        Column<T> column;
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        Column<T> column2 = column = new Column<T>(this.table, this.name, iColumnType);
        boolean bl = false;
        column2.foreignKey = this.foreignKey;
        column2.defaultValueFun = this.defaultValueFun;
        column2.dbDefaultValue = this.dbDefaultValue;
        column2.isDatabaseGenerated = this.isDatabaseGenerated;
        return column;
    }

    @Override
    public int compareTo(Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        return ColumnKt.access$getComparator$p().compare(this, column);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.table, (Object)((Column)object).table)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Column)object).name)) {
            return false;
        }
        return Intrinsics.areEqual(this.getColumnType(), ((Column)object).getColumnType());
    }

    @Override
    public int hashCode() {
        return this.table.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.table.getClass().getName() + '.' + this.name;
    }
}

