/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B=\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB?\u0012\u001a\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rJ\u001d\u00103\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\fH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\tH\u00c2\u0003JK\u00107\u001a\u00020\u00002\u001c\b\u0002\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\f2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\t09H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\t09H\u0016J\u0013\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>H\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020\t09H\u0016J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0000H\u0086\u0002J\u0018\u0010C\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003J\b\u0010D\u001a\u00020\tH\u0016R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R)\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0018j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R)\u0010\u0002\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0018j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u0014\u0010'\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u0011\u0010)\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010!R\u0011\u0010+\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0010R\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0013\u00101\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0013\u00a8\u0006E"}, d2={"Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "target", "Lorg/jetbrains/exposed/sql/Column;", "from", "onUpdate", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "onDelete", "name", "", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ReferenceOption;Lorg/jetbrains/exposed/sql/ReferenceOption;Ljava/lang/String;)V", "references", "", "(Ljava/util/Map;Lorg/jetbrains/exposed/sql/ReferenceOption;Lorg/jetbrains/exposed/sql/ReferenceOption;Ljava/lang/String;)V", "customFkName", "getCustomFkName", "()Ljava/lang/String;", "deleteRule", "getDeleteRule", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "fkName", "getFkName", "foreignKeyPart", "getForeignKeyPart$exposed_core", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getFrom", "()Ljava/util/LinkedHashSet;", "fromColumns", "getFromColumns", "fromTable", "Lorg/jetbrains/exposed/sql/Table;", "getFromTable", "()Lorg/jetbrains/exposed/sql/Table;", "fromTableName", "getFromTableName", "getReferences", "()Ljava/util/Map;", "getTarget", "targetColumns", "getTargetColumns", "targetTable", "getTargetTable", "targetTableName", "getTargetTableName", "tx", "Lorg/jetbrains/exposed/sql/Transaction;", "getTx", "()Lorg/jetbrains/exposed/sql/Transaction;", "updateRule", "getUpdateRule", "component1", "component2", "component3", "component4", "copy", "createStatement", "", "dropStatement", "equals", "", "other", "", "hashCode", "", "modifyStatement", "plus", "targetOf", "toString", "exposed-core"})
public final class ForeignKeyConstraint
implements DdlAware {
    private final Map<Column<?>, Column<?>> references;
    private final ReferenceOption onUpdate;
    private final ReferenceOption onDelete;
    private final String name;
    private final LinkedHashSet<Column<?>> target;
    private final Table targetTable;
    private final LinkedHashSet<Column<?>> from;
    private final Table fromTable;

    public ForeignKeyConstraint(Map<Column<?>, ? extends Column<?>> map, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.references = map;
        this.onUpdate = referenceOption;
        this.onDelete = referenceOption2;
        this.name = string;
        this.target = new LinkedHashSet(this.references.values());
        this.targetTable = ((Column)CollectionsKt.first((Iterable)this.target)).getTable();
        this.from = new LinkedHashSet(this.references.keySet());
        this.fromTable = ((Column)CollectionsKt.first((Iterable)this.from)).getTable();
    }

    public final Map<Column<?>, Column<?>> getReferences() {
        return this.references;
    }

    public ForeignKeyConstraint(Column<?> column, Column<?> column2, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(column2, (String)"");
        this(MapsKt.mapOf((Pair)TuplesKt.to(column2, column)), referenceOption, referenceOption2, string);
    }

    private final Transaction getTx() {
        return TransactionManager.Companion.current();
    }

    public final LinkedHashSet<Column<?>> getTarget() {
        return this.target;
    }

    public final Table getTargetTable() {
        return this.targetTable;
    }

    public final String getTargetTableName() {
        return this.getTx().identity(this.targetTable);
    }

    private final String getTargetColumns() {
        return CollectionsKt.joinToString$default((Iterable)this.target, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(this){
            final /* synthetic */ ForeignKeyConstraint this$0;
            {
                this.this$0 = foreignKeyConstraint;
                super(1);
            }

            public final CharSequence invoke(Column<?> column) {
                Intrinsics.checkNotNullParameter(column, (String)"");
                return ForeignKeyConstraint.access$getTx(this.this$0).identity(column);
            }
        }, (int)31, null);
    }

    public final LinkedHashSet<Column<?>> getFrom() {
        return this.from;
    }

    public final Table getFromTable() {
        return this.fromTable;
    }

    public final String getFromTableName() {
        return this.getTx().identity(this.fromTable);
    }

    private final String getFromColumns() {
        return CollectionsKt.joinToString$default((Iterable)this.from, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(this){
            final /* synthetic */ ForeignKeyConstraint this$0;
            {
                this.this$0 = foreignKeyConstraint;
                super(1);
            }

            public final CharSequence invoke(Column<?> column) {
                Intrinsics.checkNotNullParameter(column, (String)"");
                return ForeignKeyConstraint.access$getTx(this.this$0).identity(column);
            }
        }, (int)31, null);
    }

    public final ReferenceOption getUpdateRule() {
        ReferenceOption referenceOption = this.onUpdate;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect != null ? databaseDialect.getDefaultReferenceOption() : null;
        }
        return referenceOption;
    }

    public final ReferenceOption getDeleteRule() {
        ReferenceOption referenceOption = this.onDelete;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect != null ? databaseDialect.getDefaultReferenceOption() : null;
        }
        return referenceOption;
    }

    public final String getCustomFkName() {
        return this.name;
    }

    public final String getFkName() {
        IdentifierManagerApi identifierManagerApi = this.getTx().getDb().getIdentifierManager();
        String string = this.name;
        if (string == null) {
            string = "fk_" + this.fromTable.getTableNameWithoutSchemeSanitized$exposed_core() + '_' + CollectionsKt.joinToString$default((Iterable)this.from, (CharSequence)"_", null, null, (int)0, null, (Function1)fkName.1.INSTANCE, (int)30, null) + "__" + CollectionsKt.joinToString$default((Iterable)this.target, (CharSequence)"_", null, null, (int)0, null, (Function1)fkName.2.INSTANCE, (int)30, null);
        }
        return DatabaseDialectKt.inProperCase(identifierManagerApi.cutIfNecessaryAndQuote(string));
    }

    public final String getForeignKeyPart$exposed_core() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)this.getFkName())) {
            stringBuilder2.append("CONSTRAINT " + this.getFkName() + ' ');
        }
        stringBuilder2.append("FOREIGN KEY (" + this.getFromColumns() + ") REFERENCES " + this.getTargetTableName() + '(' + this.getTargetColumns() + ')');
        if (this.getDeleteRule() != ReferenceOption.NO_ACTION) {
            if (this.getDeleteRule() == ReferenceOption.RESTRICT && !DatabaseDialectKt.getCurrentDialect().getSupportsRestrictReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with RESTRICT reference option with ON DELETE clause. Please check your " + this.getFromTableName() + " table.");
            } else if (this.getDeleteRule() == ReferenceOption.SET_DEFAULT && !DatabaseDialectKt.getCurrentDialect().getSupportsSetDefaultReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with SET DEFAULT reference option with ON DELETE clause. Please check your " + this.getFromTableName() + " table.");
            } else {
                stringBuilder2.append(" ON DELETE " + (Object)((Object)this.getDeleteRule()));
            }
        }
        if (this.getUpdateRule() != ReferenceOption.NO_ACTION) {
            if (!DatabaseDialectKt.getCurrentDialect().getSupportsOnUpdate()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else if (this.getUpdateRule() == ReferenceOption.RESTRICT && !DatabaseDialectKt.getCurrentDialect().getSupportsRestrictReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with RESTRICT reference option with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else if (this.getUpdateRule() == ReferenceOption.SET_DEFAULT && !DatabaseDialectKt.getCurrentDialect().getSupportsSetDefaultReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with SET DEFAULT reference option with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else {
                stringBuilder2.append(" ON UPDATE " + (Object)((Object)this.getUpdateRule()));
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public List<String> createStatement() {
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTableName() + " ADD " + this.getForeignKeyPart$exposed_core()));
    }

    @Override
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    public List<String> dropStatement() {
        String string = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect ? "FOREIGN KEY" : "CONSTRAINT";
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTableName() + " DROP " + string + ' ' + this.getFkName()));
    }

    public final Column<?> targetOf(Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        return this.references.get(column);
    }

    public final ForeignKeyConstraint plus(ForeignKeyConstraint foreignKeyConstraint) {
        Intrinsics.checkNotNullParameter((Object)foreignKeyConstraint, (String)"");
        return ForeignKeyConstraint.copy$default(this, MapsKt.plus(this.references, foreignKeyConstraint.references), null, null, null, 14, null);
    }

    public String toString() {
        return "ForeignKeyConstraint(fkName='" + this.getFkName() + "')";
    }

    public final Map<Column<?>, Column<?>> component1() {
        return this.references;
    }

    private final ReferenceOption component2() {
        return this.onUpdate;
    }

    private final ReferenceOption component3() {
        return this.onDelete;
    }

    private final String component4() {
        return this.name;
    }

    public final ForeignKeyConstraint copy(Map<Column<?>, ? extends Column<?>> map, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        return new ForeignKeyConstraint(map, referenceOption, referenceOption2, string);
    }

    public static /* synthetic */ ForeignKeyConstraint copy$default(ForeignKeyConstraint foreignKeyConstraint, Map map, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = foreignKeyConstraint.references;
        }
        if ((n & 2) != 0) {
            referenceOption = foreignKeyConstraint.onUpdate;
        }
        if ((n & 4) != 0) {
            referenceOption2 = foreignKeyConstraint.onDelete;
        }
        if ((n & 8) != 0) {
            string = foreignKeyConstraint.name;
        }
        return foreignKeyConstraint.copy(map, referenceOption, referenceOption2, string);
    }

    public int hashCode() {
        int n = ((Object)this.references).hashCode();
        n = n * 31 + (this.onUpdate == null ? 0 : this.onUpdate.hashCode());
        n = n * 31 + (this.onDelete == null ? 0 : this.onDelete.hashCode());
        n = n * 31 + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ForeignKeyConstraint)) {
            return false;
        }
        ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)object;
        if (!Intrinsics.areEqual(this.references, foreignKeyConstraint.references)) {
            return false;
        }
        if (this.onUpdate != foreignKeyConstraint.onUpdate) {
            return false;
        }
        if (this.onDelete != foreignKeyConstraint.onDelete) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)foreignKeyConstraint.name);
    }

    public static final /* synthetic */ Transaction access$getTx(ForeignKeyConstraint foreignKeyConstraint) {
        return foreignKeyConstraint.getTx();
    }
}

