/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "length", "", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "hexToDb", "hexString", "integerAutoincType", "integerType", "jsonType", "largeTextType", "longAutoincType", "longType", "mediumTextType", "textType", "timeType", "ubyteType", "uintegerAutoincType", "uintegerType", "ulongAutoincType", "ulongType", "ushortType", "uuidToDB", "", "Ljava/util/UUID;", "uuidType", "varcharType", "colLength", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    public String byteType() {
        return "SMALLINT";
    }

    @Override
    public String ubyteType() {
        return "NUMBER(4)";
    }

    @Override
    public String ushortType() {
        return "NUMBER(6)";
    }

    @Override
    public String integerType() {
        return "NUMBER(12)";
    }

    @Override
    public String integerAutoincType() {
        return "NUMBER(12)";
    }

    @Override
    public String uintegerType() {
        return "NUMBER(13)";
    }

    @Override
    public String uintegerAutoincType() {
        return "NUMBER(13)";
    }

    @Override
    public String longType() {
        return "NUMBER(19)";
    }

    @Override
    public String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    public String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    public String ulongAutoincType() {
        return "NUMBER(20)";
    }

    @Override
    public String varcharType(int n) {
        return "VARCHAR2(" + n + " CHAR)";
    }

    @Override
    public String textType() {
        return "CLOB";
    }

    @Override
    public String mediumTextType() {
        return this.textType();
    }

    @Override
    public String largeTextType() {
        return this.textType();
    }

    @Override
    public String timeType() {
        return this.dateTimeType();
    }

    @Override
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        throw new IllegalStateException("Binary type is unsupported for Oracle. Please use blob column type instead.".toString());
    }

    @Override
    public String binaryType(int n) {
        return n < 2000 ? "RAW (" + n + ')' : this.binaryType();
    }

    @Override
    public String uuidType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) != H2Dialect.H2CompatibilityMode.Oracle) {
            return "RAW(16)";
        }
        return "UUID";
    }

    @Override
    public Object uuidToDB(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        return (h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle ? H2DataTypeProvider.INSTANCE.uuidToDB(uUID) : super.uuidToDB(uUID);
    }

    @Override
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    public String booleanToStatementString(boolean bl) {
        return bl ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(String string) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            bl = Long.parseLong(string) != 0L;
        }
        catch (NumberFormatException numberFormatException) {
            boolean bl2;
            try {
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                bl2 = StringsKt.toBooleanStrict((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(("Unexpected value of type Boolean: " + string).toString());
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public String jsonType() {
        return "VARCHAR2(4000)";
    }

    @Override
    public String hexToDb(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "HEXTORAW('" + string + "')";
    }
}

