/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.MonoSplineKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011J \u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/animation/core/MonoSpline;", "", "time", "", "y", "", "periodicBias", "", "<init>", "([F[[FF)V", "timePoints", "values", "[[F", "tangents", "slopeTemp", "makeFloatArray", "a", "", "b", "(II)[[F", "getPos", "t", "j", "", "v", "Landroidx/compose/animation/core/AnimationVector;", "index", "getSlope", "animation-core"})
public final class MonoSpline {
    private final float[] timePoints;
    private final float[][] values;
    private final float[][] tangents;
    private final float[] slopeTemp;
    public static final int $stable = 8;

    public MonoSpline(float[] fArray, float[][] fArray2, float f2) {
        float f3;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        int n3 = fArray.length;
        int n4 = fArray2[0].length;
        this.slopeTemp = new float[n4];
        float[][] fArray3 = this.makeFloatArray(n3 - 1, n4);
        float[][] fArray4 = this.makeFloatArray(n3, n4);
        for (n2 = 0; n2 < n4; ++n2) {
            n = n3 - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                f3 = fArray[i2 + 1] - fArray[i2];
                fArray3[i2][n2] = (fArray2[i2 + 1][n2] - fArray2[i2][n2]) / f3;
                fArray4[i2][n2] = i2 == 0 ? fArray3[i2][n2] : (fArray3[i2 - 1][n2] + fArray3[i2][n2]) * 0.5f;
            }
            fArray4[n3 - 1][n2] = fArray3[n3 - 2][n2];
        }
        if (!Float.isNaN(f2)) {
            for (n2 = 0; n2 < n4; ++n2) {
                float f4;
                fArray3[0][n2] = f4 = fArray3[n3 - 2][n2] * (1.0f - f2) + fArray3[0][n2] * f2;
                fArray3[n3 - 2][n2] = f4;
                fArray4[n3 - 1][n2] = f4;
                fArray4[0][n2] = f4;
            }
        }
        int n5 = n3 - 1;
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (fArray3[n2][n] == 0.0f) {
                    fArray4[n2][n] = 0.0f;
                    fArray4[n2 + 1][n] = 0.0f;
                    continue;
                }
                f3 = fArray4[n2][n] / fArray3[n2][n];
                float f5 = fArray4[n2 + 1][n] / fArray3[n2][n];
                float f6 = (float)Math.hypot(f3, f5);
                if (!((double)f6 > 9.0)) continue;
                float f7 = 3.0f / f6;
                fArray4[n2][n] = f7 * f3 * fArray3[n2][n];
                fArray4[n2 + 1][n] = f7 * f5 * fArray3[n2][n];
            }
        }
        this.timePoints = fArray;
        this.values = fArray2;
        this.tangents = fArray4;
    }

    private final float[][] makeFloatArray(int n, int n2) {
        int n3 = 0;
        float[][] fArrayArray = new float[n][];
        while (n3 < n) {
            int n4 = n3++;
            fArrayArray[n4] = new float[n2];
        }
        return fArrayArray;
    }

    public final float getPos(float f2, int n) {
        float[][] fArray = this.values;
        float[][] fArray2 = this.tangents;
        int n2 = this.timePoints.length;
        int n3 = f2 <= this.timePoints[0] ? 0 : (f2 >= this.timePoints[n2 - 1] ? n2 - 1 : -1);
        if (n3 != -1) {
            return fArray[n3][n] + (f2 - this.timePoints[n3]) * this.getSlope(this.timePoints[n3], n);
        }
        int n4 = n2 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (f2 == this.timePoints[i2]) {
                return fArray[i2][n];
            }
            if (!(f2 < this.timePoints[i2 + 1])) continue;
            float f3 = this.timePoints[i2 + 1] - this.timePoints[i2];
            float f4 = (f2 - this.timePoints[i2]) / f3;
            float f5 = fArray[i2][n];
            float f6 = fArray[i2 + 1][n];
            float f7 = fArray2[i2][n];
            float f8 = fArray2[i2 + 1][n];
            return MonoSplineKt.hermiteInterpolate(f3, f4, f5, f6, f7, f8);
        }
        return 0.0f;
    }

    public final void getPos(float f2, AnimationVector animationVector, int n) {
        Intrinsics.checkNotNullParameter((Object)animationVector, (String)"");
        int n2 = this.timePoints.length;
        int n3 = this.values[0].length;
        int n4 = f2 <= this.timePoints[0] ? 0 : (f2 >= this.timePoints[n2 - 1] ? n2 - 1 : -1);
        if (n4 != -1) {
            this.getSlope(this.timePoints[n4], this.slopeTemp);
            for (int i2 = 0; i2 < n3; ++i2) {
                animationVector.set$animation_core(i2, this.values[n4][i2] + (f2 - this.timePoints[n4]) * this.slopeTemp[i2]);
            }
            return;
        }
        int n5 = n2 - 1;
        for (int i3 = n; i3 < n5; ++i3) {
            if (f2 == this.timePoints[i3]) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    animationVector.set$animation_core(i4, this.values[i3][i4]);
                }
                return;
            }
            if (!(f2 < this.timePoints[i3 + 1])) continue;
            float f3 = this.timePoints[i3 + 1] - this.timePoints[i3];
            float f4 = (f2 - this.timePoints[i3]) / f3;
            for (int i5 = 0; i5 < n3; ++i5) {
                float f5 = this.values[i3][i5];
                float f6 = this.values[i3 + 1][i5];
                float f7 = this.tangents[i3][i5];
                float f8 = this.tangents[i3 + 1][i5];
                animationVector.set$animation_core(i5, MonoSplineKt.hermiteInterpolate(f3, f4, f5, f6, f7, f8));
            }
            return;
        }
    }

    public static /* synthetic */ void getPos$default(MonoSpline monoSpline, float f2, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getPos(f2, animationVector, n);
    }

    private final void getSlope(float f2, float[] fArray) {
        int n = this.values[0].length;
        int n2 = this.timePoints.length;
        float f3 = f2;
        float f4 = this.timePoints[0];
        float f5 = this.timePoints[n2 - 1];
        boolean bl = false;
        float f6 = f3;
        boolean bl2 = false;
        f6 = f6 < f4 ? f4 : f6;
        bl2 = false;
        float f7 = f6 > f5 ? f5 : f6;
        if (fArray.length < n) {
            return;
        }
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(f7 <= this.timePoints[i2 + 1])) continue;
            f5 = this.timePoints[i2 + 1] - this.timePoints[i2];
            float f8 = (f7 - this.timePoints[i2]) / f5;
            for (int i3 = 0; i3 < n; ++i3) {
                float f9 = this.values[i2][i3];
                float f10 = this.values[i2 + 1][i3];
                float f11 = this.tangents[i2][i3];
                float f12 = this.tangents[i2 + 1][i3];
                fArray[i3] = MonoSplineKt.hermiteDifferential(f5, f8, f9, f10, f11, f12) / f5;
            }
            break;
        }
    }

    public final void getSlope(float f2, AnimationVector animationVector, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)animationVector, (String)"");
        float[] fArray = this.timePoints;
        float[][] fArray2 = this.values;
        float[][] fArray3 = this.tangents;
        int n3 = fArray.length;
        int n4 = fArray2[0].length;
        int n5 = f2 <= fArray[0] ? 0 : (n2 = f2 >= fArray[n3 - 1] ? n3 - 1 : -1);
        if (n2 != -1) {
            float[] fArray4 = fArray3[n2];
            if (fArray4.length < n4) {
                return;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                animationVector.set$animation_core(i2, fArray4[i2]);
            }
            return;
        }
        int n6 = n3 - 1;
        for (int i3 = n; i3 < n6; ++i3) {
            if (!(f2 <= fArray[i3 + 1])) continue;
            float f3 = fArray[i3 + 1] - fArray[i3];
            float f4 = (f2 - fArray[i3]) / f3;
            for (int i4 = 0; i4 < n4; ++i4) {
                float f5 = fArray2[i3][i4];
                float f6 = fArray2[i3 + 1][i4];
                float f7 = fArray3[i3][i4];
                float f8 = fArray3[i3 + 1][i4];
                animationVector.set$animation_core(i4, MonoSplineKt.hermiteDifferential(f3, f4, f5, f6, f7, f8) / f3);
            }
            break;
        }
    }

    public static /* synthetic */ void getSlope$default(MonoSpline monoSpline, float f2, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getSlope(f2, animationVector, n);
    }

    private final float getSlope(float f2, int n) {
        float[] fArray = this.timePoints;
        float[][] fArray2 = this.values;
        float[][] fArray3 = this.tangents;
        int n2 = fArray.length;
        float f3 = f2;
        float f4 = fArray[0];
        float f5 = fArray[n2 - 1];
        boolean bl = false;
        float f6 = f3;
        boolean bl2 = false;
        f6 = f6 < f4 ? f4 : f6;
        bl2 = false;
        float f7 = f6 > f5 ? f5 : f6;
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(f7 <= fArray[i2 + 1])) continue;
            f5 = fArray2[i2][n];
            float f8 = fArray2[i2 + 1][n];
            f6 = fArray3[i2][n];
            float f9 = fArray3[i2 + 1][n];
            float f10 = fArray[i2 + 1] - fArray[i2];
            float f11 = (f7 - fArray[i2]) / f10;
            return MonoSplineKt.hermiteDifferential(f10, f11, f5, f8, f6, f9) / f10;
        }
        return 0.0f;
    }
}

