/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Motion;
import androidx.compose.animation.core.PreconditionsKt;
import kotlin.Metadata;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\u0005R$\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\u0005\u00a8\u0006\u001b"}, d2={"Landroidx/compose/animation/core/SpringSimulation;", "", "finalPosition", "", "<init>", "(F)V", "getFinalPosition", "()F", "setFinalPosition", "naturalFreq", "", "value", "stiffness", "getStiffness", "setStiffness", "dampingRatio", "getDampingRatio", "setDampingRatio", "getAcceleration", "lastDisplacement", "lastVelocity", "updateValues", "Landroidx/compose/animation/core/Motion;", "timeElapsed", "", "updateValues-IJZedt4$animation_core", "(FFJ)J", "animation-core"})
public final class SpringSimulation {
    private float finalPosition;
    private double naturalFreq;
    private float dampingRatio;
    public static final int $stable = 8;

    public SpringSimulation(float f2) {
        this.finalPosition = f2;
        this.naturalFreq = Math.sqrt(50.0);
        this.dampingRatio = 1.0f;
    }

    public final float getFinalPosition() {
        return this.finalPosition;
    }

    public final void setFinalPosition(float f2) {
        this.finalPosition = f2;
    }

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    public final void setStiffness(float f2) {
        if (this.getStiffness() <= 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt(f2);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final void setDampingRatio(float f2) {
        if (f2 < 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = f2;
    }

    public final float getAcceleration(float f2, float f3) {
        float f4 = f2 - this.finalPosition;
        double d2 = this.naturalFreq * this.naturalFreq;
        double d3 = 2.0 * this.naturalFreq * (double)this.dampingRatio;
        return (float)(-d2 * (double)f4 - d3 * (double)f3);
    }

    public final long updateValues-IJZedt4$animation_core(float f2, float f3, long l2) {
        double d2;
        float f4 = f2 - this.finalPosition;
        double d3 = (double)l2 / 1000.0;
        double d4 = (double)this.dampingRatio * (double)this.dampingRatio;
        double d5 = (double)(-this.dampingRatio) * this.naturalFreq;
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.dampingRatio > 1.0f) {
            d2 = this.naturalFreq * Math.sqrt(d4 - 1.0);
            double d8 = d5 + d2;
            double d9 = d5 - d2;
            double d10 = (d9 * (double)f4 - (double)f3) / (d9 - d8);
            double d11 = (double)f4 - d10;
            d6 = d11 * Math.exp(d9 * d3) + d10 * Math.exp(d8 * d3);
            d7 = d11 * d9 * Math.exp(d9 * d3) + d10 * d8 * Math.exp(d8 * d3);
        } else if (this.dampingRatio == 1.0f) {
            float f5 = f4;
            double d12 = (double)f3 + this.naturalFreq * (double)f4;
            double d13 = -this.naturalFreq * d3;
            d6 = ((double)f5 + d12 * d3) * Math.exp(d13);
            d7 = ((double)f5 + d12 * d3) * Math.exp(d13) * -this.naturalFreq + d12 * Math.exp(d13);
        } else {
            d2 = this.naturalFreq * Math.sqrt(1.0 - d4);
            float f6 = f4;
            double d14 = 1.0 / d2 * (-d5 * (double)f4 + (double)f3);
            double d15 = d2 * d3;
            d6 = Math.exp(d5 * d3) * ((double)f6 * Math.cos(d15) + d14 * Math.sin(d15));
            d7 = d6 * d5 + Math.exp(d5 * d3) * (-d2 * (double)f6 * Math.sin(d15) + d2 * d14 * Math.cos(d15));
        }
        float f7 = (float)(d6 + (double)this.finalPosition);
        float f8 = (float)d7;
        boolean bl = false;
        boolean bl2 = false;
        long l3 = Float.floatToRawIntBits(f7);
        long l4 = Float.floatToRawIntBits(f8);
        return Motion.constructor-impl(l3 << 32 | l4 & 0xFFFFFFFFL);
    }
}

