/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class DefaultHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new PrefaceFrameListener();
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;
    private final Http2SettingsReceivedConsumer settingsReceivedConsumer;
    private final boolean autoAckPing;
    private final Http2Connection.PropertyKey contentLengthKey;
    private final boolean validateHeaders;

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, true);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, bl, true);
    }

    @Deprecated
    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl, boolean bl2) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, bl, bl2, true);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl, boolean bl2, boolean bl3) {
        this.validateHeaders = bl3;
        this.autoAckPing = bl2;
        if (bl) {
            this.settingsReceivedConsumer = null;
        } else {
            if (!(http2ConnectionEncoder instanceof Http2SettingsReceivedConsumer)) {
                throw new IllegalArgumentException("disabling autoAckSettings requires the encoder to be a " + Http2SettingsReceivedConsumer.class);
            }
            this.settingsReceivedConsumer = (Http2SettingsReceivedConsumer)((Object)http2ConnectionEncoder);
        }
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        this.contentLengthKey = this.connection.newKey();
        this.frameReader = (Http2FrameReader)ObjectUtil.checkNotNull((Object)http2FrameReader, (String)"frameReader");
        this.encoder = (Http2ConnectionEncoder)ObjectUtil.checkNotNull((Object)http2ConnectionEncoder, (String)"encoder");
        this.requestVerifier = (Http2PromisedRequestVerifier)ObjectUtil.checkNotNull((Object)http2PromisedRequestVerifier, (String)"requestVerifier");
        if (http2Connection.local().flowController() == null) {
            http2Connection.local().flowController(new DefaultHttp2LocalFlowController(http2Connection));
        }
        http2Connection.local().flowController().frameWriter(http2ConnectionEncoder.frameWriter());
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = (Http2LifecycleManager)ObjectUtil.checkNotNull((Object)http2LifecycleManager, (String)"lifecycleManager");
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2LocalFlowController flowController() {
        return this.connection.local().flowController();
    }

    @Override
    public void frameListener(Http2FrameListener http2FrameListener) {
        this.listener = (Http2FrameListener)ObjectUtil.checkNotNull((Object)http2FrameListener, (String)"listener");
    }

    @Override
    public Http2FrameListener frameListener() {
        return this.listener;
    }

    @Override
    public boolean prefaceReceived() {
        return FrameReadListener.class == this.internalFrameListener.getClass();
    }

    @Override
    public void decodeFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.frameReader.readFrame(channelHandlerContext, byteBuf, this.internalFrameListener);
    }

    @Override
    public Http2Settings localSettings() {
        Http2Settings http2Settings = new Http2Settings();
        Http2FrameReader.Configuration configuration = this.frameReader.configuration();
        Http2HeadersDecoder.Configuration configuration2 = configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = configuration.frameSizePolicy();
        http2Settings.initialWindowSize(this.flowController().initialWindowSize());
        http2Settings.maxConcurrentStreams(this.connection.remote().maxActiveStreams());
        http2Settings.headerTableSize(configuration2.maxHeaderTableSize());
        http2Settings.maxFrameSize(http2FrameSizePolicy.maxFrameSize());
        http2Settings.maxHeaderListSize(configuration2.maxHeaderListSize());
        if (!this.connection.isServer()) {
            http2Settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return http2Settings;
    }

    @Override
    public void close() {
        this.frameReader.close();
    }

    protected long calculateMaxHeaderListSizeGoAway(long l) {
        return Http2CodecUtil.calculateMaxHeaderListSizeGoAway(l);
    }

    private int unconsumedBytes(Http2Stream http2Stream) {
        return this.flowController().unconsumedBytes(http2Stream);
    }

    void onGoAwayRead0(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
        this.listener.onGoAwayRead(channelHandlerContext, n, l, byteBuf);
        this.connection.goAwayReceived(n, l, byteBuf);
    }

    void onUnknownFrame0(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
        this.listener.onUnknownFrame(channelHandlerContext, by, n, http2Flags, byteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyContentLength(Http2Stream http2Stream, int n, boolean bl) {
        ContentLength contentLength = (ContentLength)http2Stream.getProperty(this.contentLengthKey);
        if (contentLength != null) {
            try {
                contentLength.increaseReceivedBytes(this.connection.isServer(), http2Stream.id(), n, bl);
            }
            finally {
                if (bl) {
                    http2Stream.removeProperty(this.contentLengthKey);
                }
            }
        }
    }

    static /* synthetic */ Http2Connection.PropertyKey access$600(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.contentLengthKey;
    }

    static /* synthetic */ boolean access$700(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.validateHeaders;
    }

    private static final class ContentLength {
        private final long expected;
        private long seen;

        ContentLength(long l) {
            this.expected = l;
        }

        void increaseReceivedBytes(boolean bl, int n, int n2, boolean bl2) {
            this.seen += (long)n2;
            if (this.seen < 0L) {
                throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Received amount of data did overflow and so not match content-length header %d", this.expected);
            }
            if (this.seen > this.expected) {
                throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Received amount of data %d does not match content-length header %d", this.seen, this.expected);
            }
            if (bl2) {
                if (this.seen == 0L && !bl) {
                    return;
                }
                if (this.expected > this.seen) {
                    throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Received amount of data %d does not match content-length header %d", this.seen, this.expected);
                }
            }
        }
    }

    private final class PrefaceFrameListener
    implements Http2FrameListener {
        private PrefaceFrameListener() {
        }

        private void verifyPrefaceReceived() {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received non-SETTINGS as first frame.", new Object[0]);
            }
        }

        @Override
        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
            this.verifyPrefaceReceived();
            return DefaultHttp2ConnectionDecoder.this.internalFrameListener.onDataRead(channelHandlerContext, n, byteBuf, n2, bl);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, bl);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
        }

        @Override
        public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPriorityRead(channelHandlerContext, n, n2, s, bl);
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onRstStreamRead(channelHandlerContext, n, l);
        }

        @Override
        public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsAckRead(channelHandlerContext);
        }

        @Override
        public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                DefaultHttp2ConnectionDecoder.this.internalFrameListener = new FrameReadListener();
            }
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsRead(channelHandlerContext, http2Settings);
        }

        @Override
        public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingRead(channelHandlerContext, l);
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingAckRead(channelHandlerContext, l);
        }

        @Override
        public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPushPromiseRead(channelHandlerContext, n, n2, http2Headers, n3);
        }

        @Override
        public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0(channelHandlerContext, n, l, byteBuf);
        }

        @Override
        public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onWindowUpdateRead(channelHandlerContext, n, n2);
        }

        @Override
        public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0(channelHandlerContext, by, n, http2Flags, byteBuf);
        }
    }

    private final class FrameReadListener
    implements Http2FrameListener {
        private FrameReadListener() {
        }

        @Override
        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
            boolean bl2;
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            Http2LocalFlowController http2LocalFlowController = DefaultHttp2ConnectionDecoder.this.flowController();
            int n3 = byteBuf.readableBytes();
            int n4 = n3 + n2;
            try {
                bl2 = this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n, http2Stream, bl, "DATA");
            }
            catch (Http2Exception http2Exception) {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n2, bl);
                http2LocalFlowController.consumeBytes(http2Stream, n4);
                throw http2Exception;
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Unhandled error on data stream id %d", n);
            }
            if (bl2) {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n2, bl);
                http2LocalFlowController.consumeBytes(http2Stream, n4);
                this.verifyStreamMayHaveExisted(n, bl, "DATA");
                return n4;
            }
            Http2Exception http2Exception = null;
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: 
                case CLOSED: {
                    http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                    break;
                }
                default: {
                    http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            int n5 = DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
            try {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n2, bl);
                n5 = DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                if (http2Exception != null) {
                    throw http2Exception;
                }
                DefaultHttp2ConnectionDecoder.this.verifyContentLength(http2Stream, n3, bl);
                n4 = DefaultHttp2ConnectionDecoder.this.listener.onDataRead(channelHandlerContext, n, byteBuf, n2, bl);
                if (bl) {
                    DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
                }
                int n6 = n4;
                return n6;
            }
            catch (Http2Exception http2Exception2) {
                int n7 = n5 - DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                n4 -= n7;
                throw http2Exception2;
            }
            catch (RuntimeException runtimeException) {
                int n8 = n5 - DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                n4 -= n8;
                throw runtimeException;
            }
            finally {
                http2LocalFlowController.consumeBytes(http2Stream, n4);
            }
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
            this.onHeadersRead(channelHandlerContext, n, http2Headers, 0, (short)16, false, n2, bl);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onHeadersRead(ChannelHandlerContext var1_1, int var2_2, Http2Headers var3_3, int var4_4, short var5_5, boolean var6_6, int var7_7, boolean var8_8) {
            var9_9 = DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).stream(var2_2);
            var10_10 = false;
            var11_11 = false;
            if (var9_9 == null && !DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).streamMayHaveExisted(var2_2)) {
                var9_9 = DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).remote().createStream(var2_2, var8_8);
                var10_10 = var9_9.state() == Http2Stream.State.HALF_CLOSED_REMOTE;
            } else if (var9_9 != null) {
                var11_11 = var9_9.isHeadersReceived();
            }
            if (this.shouldIgnoreHeadersOrDataFrame(var1_1, var2_2, var9_9, var8_8, "HEADERS")) {
                return;
            }
            v0 = var12_12 = DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).isServer() == false && HttpStatusClass.valueOf((CharSequence)var3_3.status()) == HttpStatusClass.INFORMATIONAL;
            if ((var12_12 || !var8_8) && var9_9.isHeadersReceived() || var9_9.isTrailersReceived()) {
                throw Http2Exception.streamError(var2_2, Http2Error.PROTOCOL_ERROR, "Stream %d received too many headers EOS: %s state: %s", new Object[]{var2_2, var8_8, var9_9.state()});
            }
            switch (1.$SwitchMap$io$netty$handler$codec$http2$Http2Stream$State[var9_9.state().ordinal()]) {
                case 5: {
                    var9_9.open(var8_8);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    if (var10_10) break;
                    throw Http2Exception.streamError(var9_9.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{var9_9.id(), var9_9.state()});
                }
                case 4: {
                    throw Http2Exception.streamError(var9_9.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{var9_9.id(), var9_9.state()});
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{var9_9.id(), var9_9.state()});
                }
            }
            if (!var11_11) {
                var13_13 = var3_3.getAll(HttpHeaderNames.CONTENT_LENGTH);
                if (var13_13 != null && !var13_13.isEmpty()) {
                    try {
                        var14_15 = HttpUtil.normalizeAndGetContentLength((List)var13_13, (boolean)false, (boolean)true);
                        if (var14_15 == -1L) ** GOTO lbl49
                        var3_3.setLong(HttpHeaderNames.CONTENT_LENGTH, var14_15);
                        var9_9.setProperty(DefaultHttp2ConnectionDecoder.access$600(DefaultHttp2ConnectionDecoder.this), new ContentLength(var14_15));
                    }
                    catch (IllegalArgumentException var14_16) {
                        throw Http2Exception.streamError(var9_9.id(), Http2Error.PROTOCOL_ERROR, var14_16, "Multiple content-length headers received", new Object[0]);
                    }
                }
            } else if (DefaultHttp2ConnectionDecoder.access$700(DefaultHttp2ConnectionDecoder.this) && var3_3.size() > 0) {
                var13_14 = var3_3.iterator();
                while (var13_14.hasNext()) {
                    var14_17 = var13_14.next().getKey();
                    if (!Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(var14_17)) continue;
                    throw Http2Exception.streamError(var9_9.id(), Http2Error.PROTOCOL_ERROR, "Found invalid Pseudo-Header in trailers: %s", new Object[]{var14_17});
                }
            }
lbl49:
            // 6 sources

            var9_9.headersReceived(var12_12);
            DefaultHttp2ConnectionDecoder.access$300(DefaultHttp2ConnectionDecoder.this, var9_9, 0, var8_8);
            DefaultHttp2ConnectionDecoder.access$800(DefaultHttp2ConnectionDecoder.this).flowController().updateDependencyTree(var2_2, var4_4, var5_5, var6_6);
            DefaultHttp2ConnectionDecoder.access$400(DefaultHttp2ConnectionDecoder.this).onHeadersRead(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8);
            if (var8_8) {
                DefaultHttp2ConnectionDecoder.access$500(DefaultHttp2ConnectionDecoder.this).closeStreamRemote(var9_9, var1_1.newSucceededFuture());
            }
        }

        @Override
        public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().updateDependencyTree(n, n2, s, bl);
            DefaultHttp2ConnectionDecoder.this.listener.onPriorityRead(channelHandlerContext, n, n2, s, bl);
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            if (http2Stream == null) {
                this.verifyStreamMayHaveExisted(n, false, "RST_STREAM");
                return;
            }
            switch (http2Stream.state()) {
                case IDLE: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "RST_STREAM received for IDLE stream %d", n);
                }
                case CLOSED: {
                    return;
                }
            }
            DefaultHttp2ConnectionDecoder.this.listener.onRstStreamRead(channelHandlerContext, n, l);
            DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStream(http2Stream, channelHandlerContext.newSucceededFuture());
        }

        @Override
        public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) {
            Http2Settings http2Settings = DefaultHttp2ConnectionDecoder.this.encoder.pollSentSettings();
            if (http2Settings != null) {
                this.applyLocalSettings(http2Settings);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsAckRead(channelHandlerContext);
        }

        private void applyLocalSettings(Http2Settings http2Settings) {
            Integer n;
            Integer n2;
            Long l;
            Long l2;
            Long l3;
            Boolean bl = http2Settings.pushEnabled();
            Http2FrameReader.Configuration configuration = DefaultHttp2ConnectionDecoder.this.frameReader.configuration();
            Http2HeadersDecoder.Configuration configuration2 = configuration.headersConfiguration();
            Http2FrameSizePolicy http2FrameSizePolicy = configuration.frameSizePolicy();
            if (bl != null) {
                if (DefaultHttp2ConnectionDecoder.this.connection.isServer()) {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
                }
                DefaultHttp2ConnectionDecoder.this.connection.local().allowPushTo(bl);
            }
            if ((l3 = http2Settings.maxConcurrentStreams()) != null) {
                DefaultHttp2ConnectionDecoder.this.connection.remote().maxActiveStreams((int)Math.min(l3, Integer.MAX_VALUE));
            }
            if ((l2 = http2Settings.headerTableSize()) != null) {
                configuration2.maxHeaderTableSize(l2);
            }
            if ((l = http2Settings.maxHeaderListSize()) != null) {
                configuration2.maxHeaderListSize(l, DefaultHttp2ConnectionDecoder.this.calculateMaxHeaderListSizeGoAway(l));
            }
            if ((n2 = http2Settings.maxFrameSize()) != null) {
                http2FrameSizePolicy.maxFrameSize(n2);
            }
            if ((n = http2Settings.initialWindowSize()) != null) {
                DefaultHttp2ConnectionDecoder.this.flowController().initialWindowSize(n);
            }
        }

        @Override
        public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
            if (DefaultHttp2ConnectionDecoder.this.settingsReceivedConsumer == null) {
                DefaultHttp2ConnectionDecoder.this.encoder.writeSettingsAck(channelHandlerContext, channelHandlerContext.newPromise());
                DefaultHttp2ConnectionDecoder.this.encoder.remoteSettings(http2Settings);
            } else {
                DefaultHttp2ConnectionDecoder.this.settingsReceivedConsumer.consumeReceivedSettings(http2Settings);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsRead(channelHandlerContext, http2Settings);
        }

        @Override
        public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) {
            if (DefaultHttp2ConnectionDecoder.this.autoAckPing) {
                DefaultHttp2ConnectionDecoder.this.encoder.writePing(channelHandlerContext, true, l, channelHandlerContext.newPromise());
            }
            DefaultHttp2ConnectionDecoder.this.listener.onPingRead(channelHandlerContext, l);
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) {
            DefaultHttp2ConnectionDecoder.this.listener.onPingAckRead(channelHandlerContext, l);
        }

        @Override
        public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
            if (DefaultHttp2ConnectionDecoder.this.connection().isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A client cannot push.", new Object[0]);
            }
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n, http2Stream, false, "PUSH_PROMISE")) {
                return;
            }
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state for receiving push promise: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isAuthoritative(channelHandlerContext, http2Headers)) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not authoritative", n, n2);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isCacheable(http2Headers)) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be cacheable", n, n2);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isSafe(http2Headers)) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be safe", n, n2);
            }
            DefaultHttp2ConnectionDecoder.this.connection.remote().reservePushStream(n2, http2Stream);
            DefaultHttp2ConnectionDecoder.this.listener.onPushPromiseRead(channelHandlerContext, n, n2, http2Headers, n3);
        }

        @Override
        public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0(channelHandlerContext, n, l, byteBuf);
        }

        @Override
        public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            if (http2Stream == null || http2Stream.state() == Http2Stream.State.CLOSED || this.streamCreatedAfterGoAwaySent(n)) {
                this.verifyStreamMayHaveExisted(n, false, "WINDOW_UPDATE");
                return;
            }
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().incrementWindowSize(http2Stream, n2);
            DefaultHttp2ConnectionDecoder.this.listener.onWindowUpdateRead(channelHandlerContext, n, n2);
        }

        @Override
        public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0(channelHandlerContext, by, n, http2Flags, byteBuf);
        }

        private boolean shouldIgnoreHeadersOrDataFrame(ChannelHandlerContext channelHandlerContext, int n, Http2Stream http2Stream, boolean bl, String string) {
            if (http2Stream == null) {
                if (this.streamCreatedAfterGoAwaySent(n)) {
                    logger.info("{} ignoring {} frame for stream {}. Stream sent after GOAWAY sent", new Object[]{channelHandlerContext.channel(), string, n});
                    return true;
                }
                this.verifyStreamMayHaveExisted(n, bl, string);
                throw Http2Exception.streamError(n, Http2Error.STREAM_CLOSED, "Received %s frame for an unknown stream %d", string, n);
            }
            if (http2Stream.isResetSent() || this.streamCreatedAfterGoAwaySent(n)) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} ignoring {} frame for stream {}", new Object[]{channelHandlerContext.channel(), string, http2Stream.isResetSent() ? "RST_STREAM sent." : "Stream created after GOAWAY sent. Last known stream by peer " + DefaultHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer()});
                }
                return true;
            }
            return false;
        }

        private boolean streamCreatedAfterGoAwaySent(int n) {
            Http2Connection.Endpoint<Http2RemoteFlowController> endpoint = DefaultHttp2ConnectionDecoder.this.connection.remote();
            return DefaultHttp2ConnectionDecoder.this.connection.goAwaySent() && endpoint.isValidStreamId(n) && n > endpoint.lastStreamKnownByPeer();
        }

        private void verifyStreamMayHaveExisted(int n, boolean bl, String string) {
            if (!DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(n)) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist for inbound frame %s, endOfStream = %b", n, string, bl);
            }
        }
    }
}

