/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;

public final class Http2DataChunkedInput
implements ChunkedInput<Http2DataFrame> {
    private final ChunkedInput<ByteBuf> input;
    private final Http2FrameStream stream;
    private boolean endStreamSent;

    public Http2DataChunkedInput(ChunkedInput<ByteBuf> chunkedInput, Http2FrameStream http2FrameStream) {
        this.input = (ChunkedInput)ObjectUtil.checkNotNull(chunkedInput, (String)"input");
        this.stream = (Http2FrameStream)ObjectUtil.checkNotNull((Object)http2FrameStream, (String)"stream");
    }

    public boolean isEndOfInput() {
        if (this.input.isEndOfInput()) {
            return this.endStreamSent;
        }
        return false;
    }

    public void close() {
        this.input.close();
    }

    @Deprecated
    public Http2DataFrame readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    public Http2DataFrame readChunk(ByteBufAllocator byteBufAllocator) {
        if (this.endStreamSent) {
            return null;
        }
        if (this.input.isEndOfInput()) {
            this.endStreamSent = true;
            return new DefaultHttp2DataFrame(true).stream(this.stream);
        }
        ByteBuf byteBuf = (ByteBuf)this.input.readChunk(byteBufAllocator);
        if (byteBuf == null) {
            return null;
        }
        DefaultHttp2DataFrame defaultHttp2DataFrame = new DefaultHttp2DataFrame(byteBuf, this.input.isEndOfInput()).stream(this.stream);
        if (defaultHttp2DataFrame.isEndStream()) {
            this.endStreamSent = true;
        }
        return defaultHttp2DataFrame;
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

