/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2PriorityFrame;
import io.netty.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.Http2UnknownFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    private static final Class<?>[] SUPPORTED_MESSAGES = new Class[]{Http2DataFrame.class, Http2HeadersFrame.class, Http2WindowUpdateFrame.class, Http2ResetFrame.class, Http2PingFrame.class, Http2SettingsFrame.class, Http2SettingsAckFrame.class, Http2GoAwayFrame.class, Http2PushPromiseFrame.class, Http2PriorityFrame.class, Http2UnknownFrame.class};
    protected final Http2Connection.PropertyKey streamKey;
    private final Http2Connection.PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private final IntObjectMap<DefaultHttp2FrameStream> frameStreamToInitializeMap = new IntObjectHashMap(8);

    protected Http2FrameCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, boolean bl, boolean bl2) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl, bl2);
        http2ConnectionDecoder.frameListener(new FrameListener());
        this.connection().addListener(new ConnectionListener());
        this.connection().remote().flowController().listener(new Http2RemoteFlowControllerListener());
        this.streamKey = this.connection().newKey();
        this.upgradeKey = this.connection().newKey();
        this.initialFlowControlWindowSize = http2Settings.initialWindowSize();
    }

    DefaultHttp2FrameStream newStream() {
        return new DefaultHttp2FrameStream();
    }

    final void forEachActiveStream(final Http2FrameStreamVisitor http2FrameStreamVisitor) {
        assert (this.ctx.executor().inEventLoop());
        if (this.connection().numActiveStreams() > 0) {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) {
                    try {
                        return http2FrameStreamVisitor.visit((Http2FrameStream)http2Stream.getProperty(Http2FrameCodec.this.streamKey));
                    }
                    catch (Throwable throwable) {
                        Http2FrameCodec.this.onError(Http2FrameCodec.this.ctx, false, throwable);
                        return false;
                    }
                }
            });
        }
    }

    int numInitializingStreams() {
        return this.frameStreamToInitializeMap.size();
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
        this.handlerAdded0(channelHandlerContext);
        Http2Connection http2Connection = this.connection();
        if (http2Connection.isServer()) {
            this.tryExpandConnectionFlowControlWindow(http2Connection);
        }
    }

    private void tryExpandConnectionFlowControlWindow(Http2Connection http2Connection) {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream http2Stream = http2Connection.connectionStream();
            Http2LocalFlowController http2LocalFlowController = http2Connection.local().flowController();
            int n = this.initialFlowControlWindowSize - http2LocalFlowController.initialWindowSize(http2Stream);
            if (n > 0) {
                http2LocalFlowController.incrementWindowSize(http2Stream, Math.max(n << 1, n));
                this.flush(this.ctx);
            }
        }
    }

    void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void userEventTriggered(final ChannelHandlerContext channelHandlerContext, final Object object) {
        if (object == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
            this.tryExpandConnectionFlowControlWindow(this.connection());
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    channelHandlerContext.fireUserEventTriggered(object);
                }
            });
        } else if (object instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)object;
            try {
                this.onUpgradeEvent(channelHandlerContext, upgradeEvent.retain());
                Http2Stream http2Stream = this.connection().stream(1);
                if (http2Stream.getProperty(this.streamKey) == null) {
                    this.onStreamActive0(http2Stream);
                }
                upgradeEvent.upgradeRequest().headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 1);
                http2Stream.setProperty(this.upgradeKey, true);
                InboundHttpToHttp2Adapter.handle(channelHandlerContext, this.connection(), this.decoder().frameListener(), (FullHttpMessage)upgradeEvent.upgradeRequest().retain());
            }
            finally {
                upgradeEvent.release();
            }
        } else {
            this.onUserEventTriggered(channelHandlerContext, object);
            channelHandlerContext.fireUserEventTriggered(object);
        }
    }

    void onUserEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)object;
            this.encoder().writeData(channelHandlerContext, http2DataFrame.stream().id(), http2DataFrame.content(), http2DataFrame.padding(), http2DataFrame.isEndStream(), channelPromise);
        } else if (object instanceof Http2HeadersFrame) {
            this.writeHeadersFrame(channelHandlerContext, (Http2HeadersFrame)object, channelPromise);
        } else if (object instanceof Http2WindowUpdateFrame) {
            Http2WindowUpdateFrame http2WindowUpdateFrame = (Http2WindowUpdateFrame)object;
            Http2FrameStream http2FrameStream = http2WindowUpdateFrame.stream();
            try {
                if (http2FrameStream == null) {
                    this.increaseInitialConnectionWindow(http2WindowUpdateFrame.windowSizeIncrement());
                } else {
                    this.consumeBytes(http2FrameStream.id(), http2WindowUpdateFrame.windowSizeIncrement());
                }
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else if (object instanceof Http2ResetFrame) {
            Http2ResetFrame http2ResetFrame = (Http2ResetFrame)object;
            int n = http2ResetFrame.stream().id();
            if (this.connection().streamMayHaveExisted(n)) {
                this.encoder().writeRstStream(channelHandlerContext, http2ResetFrame.stream().id(), http2ResetFrame.errorCode(), channelPromise);
            } else {
                ReferenceCountUtil.release((Object)http2ResetFrame);
                channelPromise.setFailure((Throwable)Http2Exception.streamError(http2ResetFrame.stream().id(), Http2Error.PROTOCOL_ERROR, "Stream never existed", new Object[0]));
            }
        } else if (object instanceof Http2PingFrame) {
            Http2PingFrame http2PingFrame = (Http2PingFrame)object;
            this.encoder().writePing(channelHandlerContext, http2PingFrame.ack(), http2PingFrame.content(), channelPromise);
        } else if (object instanceof Http2SettingsFrame) {
            this.encoder().writeSettings(channelHandlerContext, ((Http2SettingsFrame)object).settings(), channelPromise);
        } else if (object instanceof Http2SettingsAckFrame) {
            this.encoder().writeSettingsAck(channelHandlerContext, channelPromise);
        } else if (object instanceof Http2GoAwayFrame) {
            this.writeGoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object, channelPromise);
        } else if (object instanceof Http2PushPromiseFrame) {
            Http2PushPromiseFrame http2PushPromiseFrame = (Http2PushPromiseFrame)object;
            this.writePushPromise(channelHandlerContext, http2PushPromiseFrame, channelPromise);
        } else if (object instanceof Http2PriorityFrame) {
            Http2PriorityFrame http2PriorityFrame = (Http2PriorityFrame)object;
            this.encoder().writePriority(channelHandlerContext, http2PriorityFrame.stream().id(), http2PriorityFrame.streamDependency(), http2PriorityFrame.weight(), http2PriorityFrame.exclusive(), channelPromise);
        } else if (object instanceof Http2UnknownFrame) {
            Http2UnknownFrame http2UnknownFrame = (Http2UnknownFrame)object;
            this.encoder().writeFrame(channelHandlerContext, http2UnknownFrame.frameType(), http2UnknownFrame.stream().id(), http2UnknownFrame.flags(), http2UnknownFrame.content(), channelPromise);
        } else if (!(object instanceof Http2Frame)) {
            channelHandlerContext.write(object, channelPromise);
        } else {
            ReferenceCountUtil.release((Object)object);
            throw new UnsupportedMessageTypeException(object, (Class[])SUPPORTED_MESSAGES);
        }
    }

    private void increaseInitialConnectionWindow(int n) {
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), n);
    }

    final boolean consumeBytes(int n, int n2) {
        Boolean bl;
        Http2Stream http2Stream = this.connection().stream(n);
        if (http2Stream != null && n == 1 && Boolean.TRUE.equals(bl = (Boolean)http2Stream.getProperty(this.upgradeKey))) {
            return false;
        }
        return this.connection().local().flowController().consumeBytes(http2Stream, n2);
    }

    private void writeGoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame, ChannelPromise channelPromise) {
        if (http2GoAwayFrame.lastStreamId() > -1) {
            http2GoAwayFrame.release();
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n = this.connection().remote().lastStreamCreated();
        long l = (long)n + (long)http2GoAwayFrame.extraStreamIds() * 2L;
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        this.goAway(channelHandlerContext, (int)l, http2GoAwayFrame.errorCode(), http2GoAwayFrame.content(), channelPromise);
    }

    private void writeHeadersFrame(ChannelHandlerContext channelHandlerContext, Http2HeadersFrame http2HeadersFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2HeadersFrame.stream().id())) {
            this.encoder().writeHeaders(channelHandlerContext, http2HeadersFrame.stream().id(), http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
        } else if (this.initializeNewStream(channelHandlerContext, (DefaultHttp2FrameStream)http2HeadersFrame.stream(), channelPromise)) {
            channelPromise = channelPromise.unvoid();
            final int n = http2HeadersFrame.stream().id();
            this.encoder().writeHeaders(channelHandlerContext, n, http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
            if (!channelPromise.isDone()) {
                ++this.numBufferedStreams;
                channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        Http2FrameCodec.this.numBufferedStreams--;
                        Http2FrameCodec.this.handleHeaderFuture(channelFuture, n);
                    }
                });
            } else {
                this.handleHeaderFuture((ChannelFuture)channelPromise, n);
            }
        }
    }

    private void writePushPromise(ChannelHandlerContext channelHandlerContext, Http2PushPromiseFrame http2PushPromiseFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2PushPromiseFrame.pushStream().id())) {
            this.encoder().writePushPromise(channelHandlerContext, http2PushPromiseFrame.stream().id(), http2PushPromiseFrame.pushStream().id(), http2PushPromiseFrame.http2Headers(), http2PushPromiseFrame.padding(), channelPromise);
        } else if (this.initializeNewStream(channelHandlerContext, (DefaultHttp2FrameStream)http2PushPromiseFrame.pushStream(), channelPromise)) {
            final int n = http2PushPromiseFrame.stream().id();
            this.encoder().writePushPromise(channelHandlerContext, n, http2PushPromiseFrame.pushStream().id(), http2PushPromiseFrame.http2Headers(), http2PushPromiseFrame.padding(), channelPromise);
            if (channelPromise.isDone()) {
                this.handleHeaderFuture((ChannelFuture)channelPromise, n);
            } else {
                ++this.numBufferedStreams;
                channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        Http2FrameCodec.this.numBufferedStreams--;
                        Http2FrameCodec.this.handleHeaderFuture(channelFuture, n);
                    }
                });
            }
        }
    }

    private boolean initializeNewStream(ChannelHandlerContext channelHandlerContext, DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelPromise channelPromise) {
        Http2Connection http2Connection = this.connection();
        int n = http2Connection.local().incrementAndGetNextStreamId();
        if (n < 0) {
            channelPromise.setFailure((Throwable)new Http2NoMoreStreamIdsException());
            this.onHttp2Frame(channelHandlerContext, new DefaultHttp2GoAwayFrame(http2Connection.isServer() ? Integer.MAX_VALUE : 0x7FFFFFFE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii((ByteBufAllocator)channelHandlerContext.alloc(), (CharSequence)"Stream IDs exhausted on local stream creation")));
            return false;
        }
        defaultHttp2FrameStream.id = n;
        Object object = this.frameStreamToInitializeMap.put(n, (Object)defaultHttp2FrameStream);
        assert (object == null);
        return true;
    }

    private void handleHeaderFuture(ChannelFuture channelFuture, int n) {
        if (!channelFuture.isSuccess()) {
            this.frameStreamToInitializeMap.remove(n);
        }
    }

    private void onStreamActive0(Http2Stream http2Stream) {
        if (http2Stream.id() != 1 && this.connection().local().isValidStreamId(http2Stream.id())) {
            return;
        }
        DefaultHttp2FrameStream defaultHttp2FrameStream = this.newStream().setStreamAndProperty(this.streamKey, http2Stream);
        this.onHttp2StreamStateChanged(this.ctx, defaultHttp2FrameStream);
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception http2Exception) {
        if (!bl) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
        super.onConnectionError(channelHandlerContext, bl, throwable, http2Exception);
    }

    @Override
    protected final void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception.StreamException streamException) {
        int n = streamException.streamId();
        Http2Stream http2Stream = this.connection().stream(n);
        if (http2Stream == null) {
            Http2FrameCodec.onHttp2UnknownStreamError(channelHandlerContext, throwable, streamException);
            super.onStreamError(channelHandlerContext, bl, throwable, streamException);
            return;
        }
        Http2FrameStream http2FrameStream = (Http2FrameStream)http2Stream.getProperty(this.streamKey);
        if (http2FrameStream == null) {
            LOG.warn("Stream exception thrown without stream object attached.", throwable);
            super.onStreamError(channelHandlerContext, bl, throwable, streamException);
            return;
        }
        if (!bl) {
            this.onHttp2FrameStreamException(channelHandlerContext, new Http2FrameStreamException(http2FrameStream, streamException.error(), throwable));
        }
    }

    private static void onHttp2UnknownStreamError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception.StreamException streamException) {
        LOG.log(InternalLogLevel.DEBUG, "Stream exception thrown for unknown stream {}.", (Object)streamException.streamId(), (Object)throwable);
    }

    @Override
    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    private void onUpgradeEvent(ChannelHandlerContext channelHandlerContext, HttpServerUpgradeHandler.UpgradeEvent upgradeEvent) {
        channelHandlerContext.fireUserEventTriggered((Object)upgradeEvent);
    }

    private void onHttp2StreamWritabilityChanged(ChannelHandlerContext channelHandlerContext, DefaultHttp2FrameStream defaultHttp2FrameStream, boolean bl) {
        channelHandlerContext.fireUserEventTriggered((Object)defaultHttp2FrameStream.writabilityChanged);
    }

    void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, DefaultHttp2FrameStream defaultHttp2FrameStream) {
        channelHandlerContext.fireUserEventTriggered((Object)defaultHttp2FrameStream.stateChanged);
    }

    void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        channelHandlerContext.fireChannelRead((Object)http2Frame);
    }

    protected Http2StreamFrame newHttp2UnknownFrame(byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
        return new DefaultHttp2UnknownFrame(by, http2Flags, byteBuf);
    }

    void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        channelHandlerContext.fireExceptionCaught((Throwable)http2FrameStreamException);
    }

    static class DefaultHttp2FrameStream
    implements Http2FrameStream {
        private volatile int id = -1;
        private volatile Http2Stream stream;
        final Http2FrameStreamEvent stateChanged = Http2FrameStreamEvent.stateChanged(this);
        final Http2FrameStreamEvent writabilityChanged = Http2FrameStreamEvent.writabilityChanged(this);
        Channel attachment;

        DefaultHttp2FrameStream() {
        }

        DefaultHttp2FrameStream setStreamAndProperty(Http2Connection.PropertyKey propertyKey, Http2Stream http2Stream) {
            assert (this.id == -1 || http2Stream.id() == this.id);
            this.stream = http2Stream;
            http2Stream.setProperty(propertyKey, this);
            return this;
        }

        @Override
        public int id() {
            Http2Stream http2Stream = this.stream;
            return http2Stream == null ? this.id : http2Stream.id();
        }

        @Override
        public Http2Stream.State state() {
            Http2Stream http2Stream = this.stream;
            return http2Stream == null ? Http2Stream.State.IDLE : http2Stream.state();
        }

        public String toString() {
            return String.valueOf(this.id());
        }
    }

    private final class Http2RemoteFlowControllerListener
    implements Http2RemoteFlowController.Listener {
        private Http2RemoteFlowControllerListener() {
        }

        @Override
        public void writabilityChanged(Http2Stream http2Stream) {
            DefaultHttp2FrameStream defaultHttp2FrameStream = (DefaultHttp2FrameStream)http2Stream.getProperty(Http2FrameCodec.this.streamKey);
            if (defaultHttp2FrameStream == null) {
                return;
            }
            Http2FrameCodec.this.onHttp2StreamWritabilityChanged(Http2FrameCodec.this.ctx, defaultHttp2FrameStream, Http2FrameCodec.this.connection().remote().flowController().isWritable(http2Stream));
        }
    }

    private final class FrameListener
    implements Http2FrameListener {
        private FrameListener() {
        }

        @Override
        public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
            if (n == 0) {
                return;
            }
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, Http2FrameCodec.this.newHttp2UnknownFrame(by, n, http2Flags, byteBuf.retain()).stream(http2FrameStream));
        }

        @Override
        public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2SettingsFrame(http2Settings));
        }

        @Override
        public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PingFrame(l, false));
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PingFrame(l, true));
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2ResetFrame(l).stream(http2FrameStream));
        }

        @Override
        public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) {
            if (n == 0) {
                return;
            }
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2WindowUpdateFrame(n2).stream(http2FrameStream));
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
            this.onHeadersRead(channelHandlerContext, n, http2Headers, n3, bl2);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2HeadersFrame(http2Headers, bl, n2).stream(http2FrameStream));
        }

        @Override
        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
            DefaultHttp2DataFrame defaultHttp2DataFrame;
            Http2FrameStream http2FrameStream = this.requireStream(n);
            try {
                defaultHttp2DataFrame = new DefaultHttp2DataFrame(byteBuf.retain(), bl, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byteBuf.release();
                throw illegalArgumentException;
            }
            defaultHttp2DataFrame.stream(http2FrameStream);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, defaultHttp2DataFrame);
            return 0;
        }

        @Override
        public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2GoAwayFrame(n, l, byteBuf.retain()));
        }

        @Override
        public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
            Http2Stream http2Stream = Http2FrameCodec.this.connection().stream(n);
            if (http2Stream == null) {
                return;
            }
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PriorityFrame(n2, s, bl).stream(http2FrameStream));
        }

        @Override
        public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) {
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, Http2SettingsAckFrame.INSTANCE);
        }

        @Override
        public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
            Http2FrameStream http2FrameStream = this.requireStream(n);
            Http2FrameCodec.this.onHttp2Frame(channelHandlerContext, new DefaultHttp2PushPromiseFrame(http2Headers, n3, n2).pushStream(new DefaultHttp2FrameStream().setStreamAndProperty(Http2FrameCodec.this.streamKey, Http2FrameCodec.this.connection().stream(n2))).stream(http2FrameStream));
        }

        private Http2FrameStream requireStream(int n) {
            Http2FrameStream http2FrameStream = (Http2FrameStream)Http2FrameCodec.this.connection().stream(n).getProperty(Http2FrameCodec.this.streamKey);
            if (http2FrameStream == null) {
                throw new IllegalStateException("Stream object required for identifier: " + n);
            }
            return http2FrameStream;
        }
    }

    private final class ConnectionListener
    extends Http2ConnectionAdapter {
        private ConnectionListener() {
        }

        @Override
        public void onStreamAdded(Http2Stream http2Stream) {
            DefaultHttp2FrameStream defaultHttp2FrameStream = (DefaultHttp2FrameStream)Http2FrameCodec.this.frameStreamToInitializeMap.remove(http2Stream.id());
            if (defaultHttp2FrameStream != null) {
                defaultHttp2FrameStream.setStreamAndProperty(Http2FrameCodec.this.streamKey, http2Stream);
            }
        }

        @Override
        public void onStreamActive(Http2Stream http2Stream) {
            Http2FrameCodec.this.onStreamActive0(http2Stream);
        }

        @Override
        public void onStreamClosed(Http2Stream http2Stream) {
            this.onHttp2StreamStateChanged0(http2Stream);
        }

        @Override
        public void onStreamHalfClosed(Http2Stream http2Stream) {
            this.onHttp2StreamStateChanged0(http2Stream);
        }

        private void onHttp2StreamStateChanged0(Http2Stream http2Stream) {
            DefaultHttp2FrameStream defaultHttp2FrameStream = (DefaultHttp2FrameStream)http2Stream.getProperty(Http2FrameCodec.this.streamKey);
            if (defaultHttp2FrameStream != null) {
                Http2FrameCodec.this.onHttp2StreamStateChanged(Http2FrameCodec.this.ctx, defaultHttp2FrameStream);
            }
        }
    }
}

