/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.text.StringsKt;

public final class FunctionTypeKindExtractor {
    public static final Companion Companion = new Companion(null);
    private final List<FunctionTypeKind> kinds;
    private final Map<FqName, List<FunctionTypeKind>> knownKindsByPackageFqName;
    private static final FunctionTypeKindExtractor Default;

    public FunctionTypeKindExtractor(List<? extends FunctionTypeKind> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.kinds = list;
        Iterable iterable = this.kinds;
        FunctionTypeKindExtractor functionTypeKindExtractor = this;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Map map = new LinkedHashMap();
        boolean bl2 = false;
        for (Object t : iterable2) {
            Object object;
            Object object2 = (FunctionTypeKind)t;
            boolean bl3 = false;
            FqName fqName = ((FunctionTypeKind)object2).getPackageFqName();
            Map map2 = map;
            boolean bl4 = false;
            Object v = map2.get(fqName);
            if (v == null) {
                boolean bl5 = false;
                List list2 = new ArrayList();
                map2.put(fqName, list2);
                object = list2;
            } else {
                object = v;
            }
            object2 = (List)object;
            object2.add(t);
        }
        functionTypeKindExtractor.knownKindsByPackageFqName = map;
    }

    public final FunctionTypeKind getFunctionalClassKind(FqName fqName, String string) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        KindWithArity kindWithArity = this.getFunctionalClassKindWithArity(fqName, string);
        return kindWithArity != null ? kindWithArity.getKind() : null;
    }

    public final KindWithArity getFunctionalClassKindWithArity(FqName fqName, String string) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        List<FunctionTypeKind> list = this.knownKindsByPackageFqName.get(fqName);
        if (list == null) {
            return null;
        }
        List<FunctionTypeKind> list2 = list;
        for (FunctionTypeKind functionTypeKind : list2) {
            if (!StringsKt.startsWith$default((String)string, (String)functionTypeKind.getClassNamePrefix(), (boolean)false, (int)2, null)) continue;
            String string2 = string.substring(functionTypeKind.getClassNamePrefix().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            Integer n = this.toInt(string2);
            if (n == null) {
                continue;
            }
            int n2 = n;
            return new KindWithArity(functionTypeKind, n2);
        }
        return null;
    }

    private final Integer toInt(String string) {
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = c - 48;
            if (!(0 <= n3 ? n3 < 10 : false)) {
                return null;
            }
            n = n * 10 + n3;
        }
        return n;
    }

    static {
        Object[] objectArray = new FunctionTypeKind[]{FunctionTypeKind.Function.INSTANCE, FunctionTypeKind.SuspendFunction.INSTANCE, FunctionTypeKind.KFunction.INSTANCE, FunctionTypeKind.KSuspendFunction.INSTANCE};
        Default = new FunctionTypeKindExtractor(CollectionsKt.listOf((Object[])objectArray));
    }

    public static final class Companion {
        private Companion() {
        }

        public final FunctionTypeKindExtractor getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public static final class KindWithArity {
        private final FunctionTypeKind kind;
        private final int arity;

        public KindWithArity(FunctionTypeKind functionTypeKind, int n) {
            Intrinsics.checkNotNullParameter((Object)functionTypeKind, (String)"");
            this.kind = functionTypeKind;
            this.arity = n;
        }

        public final FunctionTypeKind getKind() {
            return this.kind;
        }

        public final FunctionTypeKind component1() {
            return this.kind;
        }

        public final int component2() {
            return this.arity;
        }

        public String toString() {
            return "KindWithArity(kind=" + this.kind + ", arity=" + this.arity + ')';
        }

        public int hashCode() {
            int n = this.kind.hashCode();
            n = n * 31 + Integer.hashCode(this.arity);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof KindWithArity)) {
                return false;
            }
            KindWithArity kindWithArity = (KindWithArity)object;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)kindWithArity.kind)) {
                return false;
            }
            return this.arity == kindWithArity.arity;
        }
    }
}

