/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;

public final class DescriptorUtilKt {
    public static final ClassDescriptor resolveClassByFqName(ModuleDescriptor moduleDescriptor, FqName fqName, LookupLocation lookupLocation) {
        MemberScope memberScope;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        if (fqName.isRoot()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = moduleDescriptor.getPackage(fqName.parent()).getMemberScope().getContributedClassifier(fqName.shortName(), lookupLocation);
        ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor != null) {
            ClassDescriptor classDescriptor3 = classDescriptor;
            boolean bl = false;
            return classDescriptor3;
        }
        classifierDescriptor = DescriptorUtilKt.resolveClassByFqName(moduleDescriptor, fqName.parent(), lookupLocation);
        classDescriptor = classifierDescriptor != null && (memberScope = classifierDescriptor.getUnsubstitutedInnerClassesScope()) != null ? memberScope.getContributedClassifier(fqName.shortName(), lookupLocation) : null;
        return classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
    }

    public static final boolean isTopLevelInPackage(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static final ClassifierDescriptor getTopLevelContainingClassifier(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
        if (declarationDescriptor2 == null || declarationDescriptor instanceof PackageFragmentDescriptor) {
            return null;
        }
        return !DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor2) ? DescriptorUtilKt.getTopLevelContainingClassifier(declarationDescriptor2) : (declarationDescriptor2 instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor2 : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTypedEqualsInValueClass(FunctionDescriptor functionDescriptor) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        Annotated annotated = classDescriptor2;
        if (classDescriptor2 == null) return false;
        ClassDescriptor classDescriptor3 = classDescriptor = annotated;
        boolean bl = false;
        if (!InlineClassesUtilsKt.isValueClass(classDescriptor3)) return false;
        ClassDescriptor classDescriptor4 = classDescriptor;
        annotated = classDescriptor4;
        if (classDescriptor4 == null) return false;
        SimpleType simpleType = annotated.getDefaultType();
        annotated = simpleType;
        if (simpleType == null) return false;
        if ((annotated = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated)) == null) {
            return false;
        }
        Annotated annotated2 = annotated;
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = kotlinType;
        if (!Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if (!TypeUtilsKt.isBoolean(kotlinType2)) {
            if (!TypeUtilsKt.isNothing(kotlinType2)) return false;
        }
        if (functionDescriptor.getValueParameters().size() != 1) return false;
        KotlinType kotlinType3 = functionDescriptor.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
        if (!Intrinsics.areEqual((Object)TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType3), (Object)annotated2)) return false;
        if (!functionDescriptor.getContextReceiverParameters().isEmpty()) return false;
        if (functionDescriptor.getExtensionReceiverParameter() != null) return false;
        return true;
    }
}

