/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectClassStructure;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.text.StringsKt;

public final class ReflectKotlinClass
implements KotlinJvmBinaryClass {
    public static final Factory Factory = new Factory(null);
    private final Class<?> klass;
    private final KotlinClassHeader classHeader;

    private ReflectKotlinClass(Class<?> clazz, KotlinClassHeader kotlinClassHeader) {
        this.klass = clazz;
        this.classHeader = kotlinClassHeader;
    }

    public final Class<?> getKlass() {
        return this.klass;
    }

    @Override
    public KotlinClassHeader getClassHeader() {
        return this.classHeader;
    }

    @Override
    public String getLocation() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.klass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
    }

    @Override
    public ClassId getClassId() {
        return ReflectClassUtilKt.getClassId(this.klass);
    }

    @Override
    public void loadClassAnnotations(KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"");
        ReflectClassStructure.INSTANCE.loadClassAnnotations(this.klass, annotationVisitor);
    }

    @Override
    public void visitMembers(KotlinJvmBinaryClass.MemberVisitor memberVisitor, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"");
        ReflectClassStructure.INSTANCE.visitMembers(this.klass, memberVisitor);
    }

    public boolean equals(Object object) {
        return object instanceof ReflectKotlinClass && Intrinsics.areEqual(this.klass, ((ReflectKotlinClass)object).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    public /* synthetic */ ReflectKotlinClass(Class clazz, KotlinClassHeader kotlinClassHeader, DefaultConstructorMarker defaultConstructorMarker) {
        this(clazz, kotlinClassHeader);
    }

    public static final class Factory {
        private Factory() {
        }

        public final ReflectKotlinClass create(Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"");
            ReadKotlinClassHeaderAnnotationVisitor readKotlinClassHeaderAnnotationVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
            ReflectClassStructure.INSTANCE.loadClassAnnotations(clazz, readKotlinClassHeaderAnnotationVisitor);
            KotlinClassHeader kotlinClassHeader = readKotlinClassHeaderAnnotationVisitor.createHeaderWithDefaultMetadataVersion();
            if (kotlinClassHeader == null) {
                return null;
            }
            return new ReflectKotlinClass(clazz, kotlinClassHeader, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

